/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.md.providers;

import java.io.InputStream;
import java.security.PublicKey;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.picketlink.identity.federation.core.interfaces.IMetadataProvider;
import org.picketlink.identity.federation.core.saml.md.providers.AbstractMetadataProvider;
import org.picketlink.identity.federation.core.saml.md.providers.MetaDataBuilderDelegate;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedEntityMetadataProvider
extends AbstractMetadataProvider
implements IMetadataProvider<EntityDescriptorType> {
    private static final String FILENAME_KEY = "FileName";
    private String fileName;
    private InputStream metadataFileStream;
    private PublicKey encryptionKey;
    private PublicKey signingKey;

    @Override
    public void init(Map<String, String> options) {
        super.init(options);
        this.fileName = options.get(FILENAME_KEY);
        if (this.fileName == null) {
            throw new IllegalStateException("FileName option not set");
        }
    }

    @Override
    public EntityDescriptorType getMetaData() {
        EntityDescriptorType edt = null;
        if (this.metadataFileStream == null) {
            throw new RuntimeException("Metadata file is not injected");
        }
        try {
            JAXBElement j = (JAXBElement)MetaDataBuilderDelegate.getUnmarshaller().unmarshal(this.metadataFileStream);
            edt = (EntityDescriptorType)j.getValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return edt;
    }

    @Override
    public boolean isMultiple() {
        return false;
    }

    @Override
    public void injectEncryptionKey(PublicKey publicKey) {
        this.encryptionKey = publicKey;
    }

    @Override
    public void injectFileStream(InputStream fileStream) {
        this.metadataFileStream = fileStream;
    }

    @Override
    public void injectSigningKey(PublicKey publicKey) {
        this.signingKey = publicKey;
    }

    @Override
    public String requireFileInjection() {
        return this.fileName;
    }
}

