/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.util;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.picketlink.identity.federation.core.util.SecurityActions;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class IDFedLSInputResolver
implements LSResourceResolver {
    private static Map<String, LSInput> lsmap = new HashMap<String, LSInput>();
    private static Map<String, String> schemaLocationMap = new HashMap<String, String>();

    public LSInput resolveResource(String type, String namespaceURI, final String publicId, final String systemId, final String baseURI) {
        LSInput lsi = lsmap.get(systemId);
        if (lsi == null) {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            String loc = schemaLocationMap.get(systemId);
            if (loc == null) {
                return null;
            }
            final InputStream is = tcl.getResourceAsStream(loc);
            if (is == null) {
                System.out.println("inputstream is null for " + loc);
            }
            lsi = new LSInput(){

                public String getBaseURI() {
                    return baseURI;
                }

                public InputStream getByteStream() {
                    return is;
                }

                public boolean getCertifiedText() {
                    return false;
                }

                public Reader getCharacterStream() {
                    return null;
                }

                public String getEncoding() {
                    return null;
                }

                public String getPublicId() {
                    return publicId;
                }

                public String getStringData() {
                    return null;
                }

                public String getSystemId() {
                    return systemId;
                }

                public void setBaseURI(String baseURI2) {
                }

                public void setByteStream(InputStream byteStream) {
                }

                public void setCertifiedText(boolean certifiedText) {
                }

                public void setCharacterStream(Reader characterStream) {
                }

                public void setEncoding(String encoding) {
                }

                public void setPublicId(String publicId2) {
                }

                public void setStringData(String stringData) {
                }

                public void setSystemId(String systemId2) {
                }
            };
            lsmap.put(systemId, lsi);
        }
        return lsi;
    }

    static {
        schemaLocationMap.put("saml-schema-assertion-2.0.xsd", "schema/saml/v2/saml-schema-assertion-2.0.xsd");
        schemaLocationMap.put("http://docs.oasis-open.org/ws-sx/ws-trust/200512/", "schema/wstrust/v1_3/ws-trust-1.3.xsd");
        schemaLocationMap.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "schema/wstrust/v1_3/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        schemaLocationMap.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "schema/wstrust/v1_3/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        schemaLocationMap.put("http://schemas.xmlsoap.org/ws/2004/09/policy", "schema/wstrust/v1_3/ws-policy.xsd");
        schemaLocationMap.put("http://www.w3.org/2005/08/addressing", "schema/wstrust/v1_3/ws-addr.xsd");
        schemaLocationMap.put("http://www.w3.org/2000/09/xmldsig#", "schema/w3c/xmldsig/xmldsig-core-schema.xsd");
        schemaLocationMap.put("http://www.w3.org/TR/2002/REC-xmldsig-core-20020212/xmldsig-core-schema.xsd", "schema/w3c/xmldsig/xmldsig-core-schema.xsd");
        schemaLocationMap.put("http://www.w3.org/2001/04/xmlenc#", "schema/w3c/xmlenc/xenc-schema.xsd");
        schemaLocationMap.put("http://www.w3.org/TR/2002/REC-xmlenc-core-20021210/xenc-schema.xsd", "schema/w3c/xmlenc/xenc-schema.xsd");
        schemaLocationMap.put("datatypes.dtd", "schema/w3c/xmlschema/datatypes.dtd");
        schemaLocationMap.put("http://www.w3.org/2001/XMLSchema.dtd", "schema/w3c/xmlschema/XMLSchema.dtd");
    }
}

