/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.factories;

import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.factories.SecurityActions;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;

public class SAML2HandlerChainFactory {
    public static SAML2HandlerChain createChain() {
        return new DefaultSAML2HandlerChain();
    }

    public static SAML2HandlerChain createChain(String fqn) throws ProcessingException {
        if (fqn == null) {
            throw new IllegalArgumentException("fqn is null");
        }
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        try {
            return (SAML2HandlerChain)tcl.loadClass(fqn).newInstance();
        }
        catch (Exception e) {
            throw new ProcessingException("Cannot create chain:", e);
        }
    }
}

