/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.WSTrustJAXBFactory;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponse;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponseCollection;
import org.picketlink.identity.federation.ws.trust.CancelTargetType;
import org.picketlink.identity.federation.ws.trust.RenewTargetType;
import org.picketlink.identity.federation.ws.trust.StatusType;
import org.picketlink.identity.federation.ws.trust.ValidateTargetType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSClient {
    private ThreadLocal<Dispatch<Source>> dispatchLocal = new InheritableThreadLocal<Dispatch<Source>>();
    private String targetNS = "http://org.picketlink.trust/sts/";

    public STSClient(STSClientConfig config) {
        QName service = new QName(this.targetNS, config.getServiceName());
        QName portName = new QName(this.targetNS, config.getPortName());
        Service jaxwsService = Service.create((QName)service);
        jaxwsService.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", config.getEndPointAddress());
        Dispatch dispatch = jaxwsService.createDispatch(portName, Source.class, Service.Mode.PAYLOAD);
        Map reqContext = dispatch.getRequestContext();
        String username = config.getUsername();
        if (username != null) {
            reqContext.put("javax.xml.ws.security.auth.username", config.getUsername());
            reqContext.put("javax.xml.ws.security.auth.password", config.getPassword());
        }
        this.dispatchLocal.set((Dispatch<Source>)dispatch);
    }

    public Element issueTokenForEndpoint(String endpointURI) throws WSTrustException {
        RequestSecurityToken request = new RequestSecurityToken();
        this.setAppliesTo(endpointURI, request);
        return this.issueToken(request);
    }

    public Element issueToken(String endpointURI, String tokenType) throws WSTrustException {
        if (endpointURI == null && tokenType == null) {
            throw new IllegalArgumentException("One of endpointURI or tokenType must be provided.");
        }
        RequestSecurityToken request = new RequestSecurityToken();
        this.setAppliesTo(endpointURI, request);
        this.setTokenType(tokenType, request);
        return this.issueToken(request);
    }

    public Element issueToken(String tokenType) throws WSTrustException {
        RequestSecurityToken request = new RequestSecurityToken();
        this.setTokenType(tokenType, request);
        return this.issueToken(request);
    }

    private RequestSecurityToken setAppliesTo(String endpointURI, RequestSecurityToken rst) {
        if (endpointURI != null) {
            rst.setAppliesTo(WSTrustUtil.createAppliesTo(endpointURI));
        }
        return rst;
    }

    private RequestSecurityToken setTokenType(String tokenType, RequestSecurityToken rst) {
        if (tokenType != null) {
            rst.setTokenType(URI.create(tokenType));
        }
        return rst;
    }

    private Element issueToken(RequestSecurityToken request) throws WSTrustException {
        NodeList nodes;
        request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue"));
        request.setContext("context");
        WSTrustJAXBFactory jaxbFactory = WSTrustJAXBFactory.getInstance();
        DOMSource requestSource = (DOMSource)jaxbFactory.marshallRequestSecurityToken(request);
        Source response = (Source)this.dispatchLocal.get().invoke((Object)requestSource);
        try {
            Node documentNode = DocumentUtil.getNodeFromSource(response);
            Document responseDoc = documentNode instanceof Document ? (Document)documentNode : documentNode.getOwnerDocument();
            Document myDocument = DocumentUtil.createDocument();
            Node importedNode = myDocument.importNode(responseDoc.getDocumentElement(), true);
            myDocument.appendChild(importedNode);
            nodes = null;
            if (responseDoc instanceof SOAPPart) {
                SOAPPart soapPart = (SOAPPart)responseDoc;
                SOAPEnvelope env = soapPart.getEnvelope();
                SOAPBody body = env.getBody();
                Node data = body.getFirstChild();
                nodes = ((Element)data).getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken");
                if (nodes == null || nodes.getLength() == 0) {
                    nodes = ((Element)data).getElementsByTagName("RequestedSecurityToken");
                }
            } else {
                nodes = responseDoc.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken");
                if (nodes == null || nodes.getLength() == 0) {
                    nodes = responseDoc.getElementsByTagName("RequestedSecurityToken");
                }
            }
        }
        catch (Exception e) {
            throw new WSTrustException("Exception in issuing token:", e);
        }
        if (nodes == null) {
            throw new WSTrustException("NodeList is null");
        }
        Node rstr = nodes.item(0);
        return (Element)rstr.getFirstChild();
    }

    public Element renewToken(String tokenType, Element token) throws WSTrustException {
        NodeList nodes;
        RequestSecurityToken request = new RequestSecurityToken();
        request.setContext("context");
        request.setTokenType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status"));
        request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew"));
        RenewTargetType renewTarget = new RenewTargetType();
        renewTarget.setAny(token);
        request.setRenewTarget(renewTarget);
        WSTrustJAXBFactory jaxbFactory = WSTrustJAXBFactory.getInstance();
        DOMSource requestSource = (DOMSource)jaxbFactory.marshallRequestSecurityToken(request);
        Source response = (Source)this.dispatchLocal.get().invoke((Object)requestSource);
        Node documentNode = ((DOMSource)response).getNode();
        Document responseDoc = documentNode instanceof Document ? (Document)documentNode : documentNode.getOwnerDocument();
        try {
            Document myDocument = DocumentUtil.createDocument();
            Node importedNode = myDocument.importNode(responseDoc.getDocumentElement(), true);
            myDocument.appendChild(importedNode);
            nodes = null;
            if (responseDoc instanceof SOAPPart) {
                SOAPPart soapPart = (SOAPPart)responseDoc;
                SOAPEnvelope env = soapPart.getEnvelope();
                SOAPBody body = env.getBody();
                Node data = body.getFirstChild();
                nodes = ((Element)data).getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken");
                if (nodes == null || nodes.getLength() == 0) {
                    nodes = ((Element)data).getElementsByTagName("RequestedSecurityToken");
                }
            } else {
                nodes = responseDoc.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken");
                if (nodes == null || nodes.getLength() == 0) {
                    nodes = responseDoc.getElementsByTagName("RequestedSecurityToken");
                }
            }
        }
        catch (Exception e) {
            throw new WSTrustException("Exception in renewing token:", e);
        }
        if (nodes == null) {
            throw new WSTrustException("NodeList is null");
        }
        Node rstr = nodes.item(0);
        return (Element)rstr.getFirstChild();
    }

    public boolean validateToken(Element token) throws WSTrustException {
        RequestSecurityToken request = new RequestSecurityToken();
        request.setContext("context");
        request.setTokenType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status"));
        request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate"));
        ValidateTargetType validateTarget = new ValidateTargetType();
        validateTarget.setAny(token);
        request.setValidateTarget(validateTarget);
        WSTrustJAXBFactory jaxbFactory = WSTrustJAXBFactory.getInstance();
        DOMSource requestSource = (DOMSource)jaxbFactory.marshallRequestSecurityToken(request);
        Source response = (Source)this.dispatchLocal.get().invoke((Object)requestSource);
        RequestSecurityTokenResponseCollection responseCollection = (RequestSecurityTokenResponseCollection)jaxbFactory.parseRequestSecurityTokenResponse(response);
        RequestSecurityTokenResponse tokenResponse = responseCollection.getRequestSecurityTokenResponses().get(0);
        StatusType status = tokenResponse.getStatus();
        if (status != null) {
            String code = status.getCode();
            return "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/valid".equals(code);
        }
        return false;
    }

    public boolean cancelToken(Element securityToken) throws WSTrustException {
        RequestSecurityToken request = new RequestSecurityToken();
        request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel"));
        CancelTargetType cancelTarget = new CancelTargetType();
        cancelTarget.setAny(securityToken);
        request.setCancelTarget(cancelTarget);
        WSTrustJAXBFactory jaxbFactory = WSTrustJAXBFactory.getInstance();
        DOMSource requestSource = (DOMSource)jaxbFactory.marshallRequestSecurityToken(request);
        Source response = (Source)this.dispatchLocal.get().invoke((Object)requestSource);
        RequestSecurityTokenResponseCollection responseCollection = (RequestSecurityTokenResponseCollection)jaxbFactory.parseRequestSecurityTokenResponse(response);
        RequestSecurityTokenResponse tokenResponse = responseCollection.getRequestSecurityTokenResponses().get(0);
        return tokenResponse.getRequestedTokenCancelled() != null;
    }

    public Dispatch<Source> getDispatch() {
        return this.dispatchLocal.get();
    }
}

