/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class STSClientConfig {
    public static final String DEFAULT_CONFIG_FILE = "sts-client.properties";
    public static final String SERVICE_NAME = "serviceName";
    public static final String PORT_NAME = "portName";
    public static final String ENDPOINT_ADDRESS = "endpointAddress";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String TOKEN_TYPE = "tokenType";
    private String serviceName;
    private String portName;
    private String endpointAddress;
    private String username;
    private String password;

    private STSClientConfig(Builder builder) {
        this.serviceName = builder.serviceName;
        this.portName = builder.portName;
        this.endpointAddress = builder.endpointAddress;
        this.username = builder.username;
        this.password = builder.password;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getEndPointAddress() {
        return this.endpointAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[serviceName=" + this.serviceName + ", portName=" + this.portName + ", endpointAddress=" + this.endpointAddress + "]";
    }

    private static InputStream getResource(String resource) throws IOException {
        InputStream is;
        File file = new File(resource);
        if (file.exists() && !file.isDirectory()) {
            return new FileInputStream(file);
        }
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        if (threadClassLoader != null && (is = threadClassLoader.getResourceAsStream(resource)) != null) {
            return is;
        }
        return null;
    }

    public static class Builder {
        private String serviceName;
        private String portName;
        private String endpointAddress;
        private String username;
        private String password;

        public Builder() {
        }

        public Builder(String configFile) {
            this.populate(configFile);
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder portName(String portName) {
            this.portName = portName;
            return this;
        }

        public Builder endpointAddress(String address) {
            this.endpointAddress = address;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getPortName() {
            return this.portName;
        }

        public String getEndpointAddress() {
            return this.endpointAddress;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public STSClientConfig build() {
            this.validate(this);
            return new STSClientConfig(this);
        }

        private void populate(String configFile) {
            InputStream in = null;
            try {
                in = STSClientConfig.getResource(configFile);
                if (in == null) {
                    throw new IllegalStateException("Could not find properties file " + configFile);
                }
                Properties properties = new Properties();
                properties.load(in);
                this.serviceName = properties.getProperty(STSClientConfig.SERVICE_NAME);
                this.portName = properties.getProperty(STSClientConfig.PORT_NAME);
                this.endpointAddress = properties.getProperty(STSClientConfig.ENDPOINT_ADDRESS);
                this.username = properties.getProperty(STSClientConfig.USERNAME);
                this.password = properties.getProperty(STSClientConfig.PASSWORD);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not load properties from " + configFile);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ignored) {
                    ignored.printStackTrace();
                }
            }
        }

        private void validate(Builder builder) {
            this.checkPropertyShowValue(this.serviceName, STSClientConfig.SERVICE_NAME);
            this.checkPropertyShowValue(this.portName, STSClientConfig.PORT_NAME);
            this.checkPropertyShowValue(this.endpointAddress, this.endpointAddress);
            this.checkProperty(this.username, STSClientConfig.USERNAME);
            this.checkProperty(this.password, STSClientConfig.PASSWORD);
        }

        private void checkPropertyShowValue(String propertyName, String propertyValue) {
            if (propertyValue == null || propertyValue.equals("")) {
                throw new IllegalArgumentException(propertyName + " property must not be null or empty was:" + propertyValue);
            }
        }

        private void checkProperty(String propertyName, String propertyValue) {
            if (propertyValue == null || propertyValue.equals("")) {
                throw new IllegalArgumentException(propertyName + " property must not be null");
            }
        }
    }
}

