/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import javax.xml.bind.Binder;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.JAXBUtil;
import org.picketlink.identity.federation.core.wstrust.SAML2SecurityToken;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.wrappers.BaseRequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.BaseRequestSecurityTokenResponse;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponse;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponseCollection;
import org.picketlink.identity.federation.ws.trust.ObjectFactory;
import org.picketlink.identity.federation.ws.trust.RequestSecurityTokenResponseCollectionType;
import org.picketlink.identity.federation.ws.trust.RequestSecurityTokenType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSTrustJAXBFactory {
    private static Logger log = Logger.getLogger(WSTrustJAXBFactory.class);
    private boolean trace = log.isTraceEnabled();
    private static final WSTrustJAXBFactory instance = new WSTrustJAXBFactory();
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private Binder<Node> binder;
    private final ObjectFactory objectFactory;
    private ThreadLocal<SAMLDocumentHolder> holders = new ThreadLocal();

    private WSTrustJAXBFactory() {
        try {
            this.marshaller = JAXBUtil.getMarshaller(this.getPackages());
            this.unmarshaller = JAXBUtil.getUnmarshaller(this.getPackages());
            this.binder = JAXBUtil.getJAXBContext(this.getPackages()).createBinder();
            this.objectFactory = new ObjectFactory();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static WSTrustJAXBFactory getInstance() {
        return instance;
    }

    private String getPackages() {
        StringBuilder packages = new StringBuilder();
        packages.append("org.picketlink.identity.federation.ws.addressing");
        packages.append(":org.picketlink.identity.federation.ws.policy");
        packages.append(":org.picketlink.identity.federation.ws.trust");
        packages.append(":org.picketlink.identity.federation.ws.wss.secext");
        packages.append(":org.picketlink.identity.federation.ws.wss.utility");
        packages.append(":org.picketlink.identity.xmlsec.w3.xmldsig");
        return packages.toString();
    }

    public BaseRequestSecurityToken parseRequestSecurityToken(Source request) throws WSTrustException {
        try {
            Node documentNode = DocumentUtil.getNodeFromSource(request);
            Document document = documentNode instanceof Document ? (Document)documentNode : documentNode.getOwnerDocument();
            Node rst = this.findNodeByNameNS(document, "RequestSecurityToken", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            if (rst == null) {
                throw new RuntimeException("Request Security Token node not found");
            }
            JAXBElement jaxbRST = (JAXBElement)this.binder.unmarshal((Object)rst);
            RequestSecurityTokenType rstt = (RequestSecurityTokenType)jaxbRST.getValue();
            SAML2SecurityToken samlSecurityToken = new SAML2SecurityToken(rstt);
            this.holders.set(new SAMLDocumentHolder(samlSecurityToken, document));
            return new RequestSecurityToken(rstt);
        }
        catch (Exception e) {
            throw new WSTrustException("Error parsing security token request", e);
        }
    }

    public BaseRequestSecurityTokenResponse parseRequestSecurityTokenResponse(Source response) throws WSTrustException {
        Element tokenElement = null;
        Node documentNode = null;
        try {
            documentNode = DocumentUtil.getNodeFromSource(response);
        }
        catch (Exception e) {
            throw new WSTrustException("Failed to transform request source", e);
        }
        Document document = documentNode instanceof Document ? (Document)documentNode : documentNode.getOwnerDocument();
        Node requestedTokenNode = this.findNodeByNameNS(document, "RequestedSecurityToken", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        if (requestedTokenNode != null) {
            tokenElement = (Element)requestedTokenNode.getFirstChild();
        }
        try {
            Object object = this.unmarshaller.unmarshal(documentNode);
            if (object instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)object;
                if (element.getDeclaredType().equals(RequestSecurityTokenResponseCollectionType.class)) {
                    RequestSecurityTokenResponseCollection collection = new RequestSecurityTokenResponseCollection((RequestSecurityTokenResponseCollectionType)element.getValue());
                    if (tokenElement != null) {
                        RequestSecurityTokenResponse parsedResponse = collection.getRequestSecurityTokenResponses().get(0);
                        parsedResponse.getRequestedSecurityToken().setAny(tokenElement);
                    }
                    return collection;
                }
                throw new RuntimeException("Invalid response type: " + element.getDeclaredType());
            }
            throw new RuntimeException("Invalid response type: " + object.getClass().getName());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to unmarshall security token response", e);
        }
    }

    public Source marshallRequestSecurityToken(RequestSecurityToken request) {
        Element targetElement = null;
        String requestType = request.getRequestType().toString();
        if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate") && request.getValidateTarget() != null) {
            targetElement = (Element)request.getValidateTarget().getAny();
            request.getValidateTarget().setAny(null);
        } else if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew") && request.getRenewTarget() != null) {
            targetElement = (Element)request.getRenewTarget().getAny();
            request.getRenewTarget().setAny(null);
        } else if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel") && request.getCancelTarget() != null) {
            targetElement = (Element)request.getCancelTarget().getAny();
            request.getCancelTarget().setAny(null);
        }
        Document result = null;
        try {
            result = DocumentUtil.createDocument();
            this.marshaller.marshal(this.objectFactory.createRequestSecurityToken(request.getDelegate()), (Node)result);
            if (targetElement != null) {
                Node node = null;
                if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate")) {
                    node = this.findNodeByNameNS(result, "ValidateTarget", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                } else if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew")) {
                    node = this.findNodeByNameNS(result, "RenewTarget", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                } else if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel")) {
                    node = this.findNodeByNameNS(result, "CancelTarget", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                }
                if (node == null) {
                    throw new RuntimeException("Unsupported request type:" + requestType);
                }
                node.appendChild(result.importNode(targetElement, true));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to marshall security token request", e);
        }
        return DocumentUtil.getXMLSource(result);
    }

    public Source marshallRequestSecurityTokenResponse(RequestSecurityTokenResponseCollection collection) {
        if (collection.getRequestSecurityTokenResponses().size() == 0) {
            throw new IllegalArgumentException("The response collection must contain at least one response");
        }
        Element tokenElement = null;
        RequestSecurityTokenResponse response = collection.getRequestSecurityTokenResponses().get(0);
        if (response.getRequestedSecurityToken() != null) {
            tokenElement = (Element)response.getRequestedSecurityToken().getAny();
            response.getRequestedSecurityToken().setAny(null);
        }
        Document result = null;
        try {
            result = DocumentUtil.createDocument();
            this.marshaller.marshal(this.objectFactory.createRequestSecurityTokenResponseCollection(collection.getDelegate()), (Node)result);
            if (tokenElement != null) {
                Node node = this.findNodeByNameNS(result, "RequestedSecurityToken", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                node.appendChild(result.importNode(tokenElement, true));
            }
            if (this.trace) {
                log.trace((Object)("Final RSTR doc:" + DocumentUtil.asString(result)));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to marshall security token response", e);
        }
        return DocumentUtil.getXMLSource(result);
    }

    public SAMLDocumentHolder getSAMLDocumentHolderOnThread() {
        return this.holders.get();
    }

    private Node findNodeByNameNS(Document document, String localName, String namespace) {
        NodeList list = document.getElementsByTagNameNS(namespace, localName);
        if (list == null || list.getLength() == 0) {
            return null;
        }
        return list.item(0);
    }
}

