/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;

public class IdentityServer
implements HttpSessionListener {
    private static Logger log = Logger.getLogger(IdentityServer.class);
    private boolean trace = log.isTraceEnabled();
    private static int count = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            String val = System.getProperty("identity.server.log.count", "100");
            return Integer.parseInt(val);
        }
    });
    private static int activeSessionCount = 0;
    private STACK stack = new STACK();

    public int getActiveSessionCount() {
        return activeSessionCount;
    }

    public STACK stack() {
        return this.stack;
    }

    public void sessionCreated(HttpSessionEvent sessionEvent) {
        ServletContext servletContext;
        IdentityServer idserver;
        if (++activeSessionCount % count == 0) {
            log.info((Object)("Active Session Count=" + activeSessionCount));
        }
        HttpSession session = sessionEvent.getSession();
        if (this.trace) {
            log.trace((Object)("Session Created with id=" + session.getId() + "::active session count=" + activeSessionCount));
        }
        if ((idserver = (IdentityServer)(servletContext = session.getServletContext()).getAttribute("IDENTITY_SERVER")) == null) {
            idserver = this;
            servletContext.setAttribute("IDENTITY_SERVER", (Object)this);
        }
        if (idserver != this) {
            throw new IllegalStateException("Identity Server mismatch");
        }
        String id = sessionEvent.getSession().getId();
        this.stack.put(id);
    }

    public void sessionDestroyed(HttpSessionEvent sessionEvent) {
        --activeSessionCount;
        String id = sessionEvent.getSession().getId();
        if (this.trace) {
            log.trace((Object)("Session Destroyed with id=" + id + "::active session count=" + activeSessionCount));
        }
        this.stack.remove(id);
    }

    public class STACK {
        private ConcurrentHashMap<String, Stack<String>> sessionParticipantsMap = new ConcurrentHashMap();
        private ConcurrentHashMap<String, Set<String>> inTransitMap = new ConcurrentHashMap();
        private ConcurrentHashMap<String, Boolean> postBindingMap = new ConcurrentHashMap();

        public String peek(String sessionID) {
            Stack<String> stack = this.sessionParticipantsMap.get(sessionID);
            if (stack != null) {
                return stack.peek();
            }
            return "";
        }

        public String pop(String sessionID) {
            String result = null;
            Stack<String> stack = this.sessionParticipantsMap.get(sessionID);
            if (stack != null && !stack.isEmpty()) {
                result = stack.pop();
            }
            return result;
        }

        public void register(String sessionID, String participant, boolean postBinding) {
            Stack<String> stack = this.sessionParticipantsMap.get(sessionID);
            if (stack == null) {
                stack = new Stack();
                this.sessionParticipantsMap.put(sessionID, stack);
            }
            if (!stack.contains(participant)) {
                stack.push(participant);
                this.postBindingMap.put(participant, postBinding);
            }
        }

        public int getParticipants(String sessionID) {
            Stack<String> stack = this.sessionParticipantsMap.get(sessionID);
            if (stack != null) {
                return stack.size();
            }
            return 0;
        }

        public boolean registerTransitParticipant(String sessionID, String participant) {
            Set<String> transitSet = this.inTransitMap.get(sessionID);
            if (transitSet == null) {
                transitSet = new HashSet<String>();
                this.inTransitMap.put(sessionID, transitSet);
            }
            if (transitSet != null) {
                return transitSet.add(participant);
            }
            return false;
        }

        public boolean deRegisterTransitParticipant(String sessionID, String participant) {
            Set<String> transitSet = this.inTransitMap.get(sessionID);
            if (transitSet != null) {
                this.postBindingMap.remove(participant);
                return transitSet.remove(participant);
            }
            return false;
        }

        public int getNumOfParticipantsInTransit(String sessionID) {
            Set<String> transitSet = this.inTransitMap.get(sessionID);
            if (transitSet != null) {
                return transitSet.size();
            }
            return 0;
        }

        public Boolean getBinding(String participant) {
            return this.postBindingMap.get(participant);
        }

        public int totalSessions() {
            return this.sessionParticipantsMap.keySet().size();
        }

        private void put(String id) {
            this.sessionParticipantsMap.put(id, new Stack());
            this.inTransitMap.put(id, new HashSet());
        }

        private void remove(String id) {
            this.sessionParticipantsMap.remove(id);
            this.inTransitMap.remove(id);
        }
    }
}

