/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.picketlink.identity.federation.core.wstrust;

/**
 * Define constants used by the PicketLink STS
 * @author Anil.Saldhana@redhat.com
 * @since Sep 8, 2010
 */
public interface PicketLinkSTSConstants
{
   /**
    * Constant for the home directory where the JDK is in operation
    */
   String USER_HOME_DIR = SecurityActions.getSystemProperty(  "user.home", null );
   
   /**
    * File separator (Dependent on the OS)
    */
   String SEPARATOR = SecurityActions.getSystemProperty( "file.separator", "/" );

   /**
    * Configuration file for the STS - available in the deployment via TCCL
    */
   String STS_CONFIG_FILE = "picketlink-sts.xml";

   String STS_CONFIG_DIR = "picketlink-store" + SEPARATOR + "sts" + SEPARATOR; 
   
   /**
    * Configuration handlers for the STS
    */
   String CONFIG_HANDLER_FILE = "picketlink-sts-confighandlers.xml";
}