/*
 * JBoss, Home of Professional Open Source. Copyright 2008, Red Hat Middleware LLC, and individual contributors as
 * indicated by the @author tags. See the copyright.txt file in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this software; if not, write to
 * the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF site:
 * http://www.fsf.org.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.io.Serializable;
import java.security.Principal;

/**
 * <p>
 * A {@code Principal} implementation that encloses a {@code SamlCredential}.
 * </p> 
 * 
 * @author <a href="mailto:sguilhen@redhat.com">Stefan Guilhen</a>
 */
public class SAMLPrincipal implements Principal, Serializable
{
   private static final long serialVersionUID = -1920118158545149797L;

   private String principalName;
   
   private SamlCredential credential;
   
   public SAMLPrincipal(String name, SamlCredential credential)
   {
      this.principalName = name;
      this.credential = credential;
   }
   
   /*
    * (non-Javadoc)
    * @see java.security.Principal#getName()
    */
   public String getName()
   {
      return this.principalName;
   }
   
   public SamlCredential getSAMLCredential()
   {
      return this.credential;
   }
}
