/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.picketlink.identity.federation.core.wstrust.confighandlers;

import java.io.InputStream;
import java.net.URL;

import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.config.STSType;
import org.picketlink.identity.federation.core.wstrust.PicketLinkSTSConfiguration;
import org.picketlink.identity.federation.core.wstrust.PicketLinkSTSConstants;
import org.picketlink.identity.federation.core.wstrust.STSConfiguration;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;

/**
 * Configuration Handler that reads the configuration from the {@code PicketLinkSTSConstants#STS_CONFIG_FILE} that
 * is from the classpath, reachable from the Thread Context Class Loader
 * 
 * @author Anil.Saldhana@redhat.com
 * @since Sep 8, 2010
 */
public class ClassPathConfigHandler extends BaseSTSConfigHandler
{ 
   protected static Logger log = Logger.getLogger( ClassPathConfigHandler.class );
   
   /* (non-Javadoc)
    * @see org.picketlink.identity.federation.core.wstrust.confighandlers.STSConfigHandler#getConfiguration()
    */ 
   public STSConfiguration getConfiguration()
   {
      STSConfiguration configuration = null;
      
      try
      {
         URL configurationFileURL = SecurityActions.getContextClassLoader().getResource( PicketLinkSTSConstants.STS_CONFIG_FILE );
         
         if (configurationFileURL != null)
         {
            InputStream stream = configurationFileURL.openStream();
            STSType stsConfig = WSTrustUtil.getSTSConfiguration(stream);
            configuration = new PicketLinkSTSConfiguration(stsConfig); 
         }
      }
      catch ( Exception e )
      {
         if( log.isTraceEnabled() )
         {
            log.trace( "Error in handling classpath based configuration:", e );
         } 
      }     
      return configuration; 
   }
}