/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.picketlink.identity.federation.core.wstrust.confighandlers;

import java.io.File;
import java.io.InputStream;
import java.net.URL;

import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.config.STSType;
import org.picketlink.identity.federation.core.wstrust.PicketLinkSTSConfiguration;
import org.picketlink.identity.federation.core.wstrust.PicketLinkSTSConstants;
import org.picketlink.identity.federation.core.wstrust.STSConfiguration;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;

/**
 * PicketLink console stores the sts configuration in the home directory
 * 
 * @author Anil.Saldhana@redhat.com
 * @since Sep 8, 2010
 */
public class ConsoleHomeDirectoryConfigHandler extends BaseSTSConfigHandler
{
   protected static Logger log = Logger.getLogger( ConsoleHomeDirectoryConfigHandler.class );
   
   /* (non-Javadoc)
    * @see org.picketlink.identity.federation.core.wstrust.confighandlers.STSConfigHandler#getConfiguration()
    */ 
   public STSConfiguration getConfiguration()
   {
      STSConfiguration configuration = null;
      
      URL configurationFileURL = null;
      
      // Check the user home for a configuration file generated by the picketlink console.
      try
      {
         StringBuilder builder = new StringBuilder( PicketLinkSTSConstants.USER_HOME_DIR );
         builder.append( PicketLinkSTSConstants.SEPARATOR );
         builder.append( PicketLinkSTSConstants.STS_CONFIG_DIR );
         builder.append( PicketLinkSTSConstants.STS_CONFIG_FILE );
         
         String configurationFilePath = builder.toString();
         
         /*String configurationFilePath = System.getProperty( "user.home" ) + PicketLinkSTSConstants.SEPARATOR + 
         PicketLinkSTSConstants.STS_CONFIG_DIR + PicketLinkSTSConstants.STS_CONFIG_FILE;*/
         
         File configurationFile = new File( configurationFilePath );
         if ( configurationFile != null && configurationFile.exists() )
         {
            configurationFileURL = configurationFile.toURI().toURL(); 
            InputStream stream = configurationFileURL.openStream();
            STSType stsConfig = WSTrustUtil.getSTSConfiguration(stream);
            configuration = new PicketLinkSTSConfiguration(stsConfig);
         }
      }
      catch ( Exception e )
      {
         if( log.isTraceEnabled() )
         {
            log.trace( "Error in handling Console based configuration in home directory:", e );
         } 
      } 
      
      return configuration;
   }
}