/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.metadata.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.saml.v2.metadata.store.IMetadataConfigurationStore;
import org.picketlink.identity.federation.core.saml.v2.metadata.store.SecurityActions;
import org.picketlink.identity.federation.core.util.JAXBUtil;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.ObjectFactory;
import org.picketlink.identity.federation.saml.v2.metadata.RoleDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedMetadataConfigurationStore
implements IMetadataConfigurationStore {
    private static Logger log = Logger.getLogger(FileBasedMetadataConfigurationStore.class);
    private boolean trace = log.isTraceEnabled();
    private String userHome = null;
    private String baseDirectory = null;
    private String pkgName = "org.picketlink.identity.federation.saml.v2.metadata";

    public FileBasedMetadataConfigurationStore() {
        this.bootstrap();
    }

    @Override
    public void bootstrap() {
        this.userHome = SecurityActions.getSystemProperty("user.home");
        if (this.userHome == null) {
            throw new RuntimeException("user.home system property not set");
        }
        StringBuilder builder = new StringBuilder(this.userHome);
        builder.append("/picketlink-store");
        this.baseDirectory = builder.toString();
        File plStore = new File(this.baseDirectory);
        if (!plStore.exists()) {
            if (this.trace) {
                log.trace((Object)(plStore.getPath() + " does not exist. Hence creating."));
            }
            plStore.mkdir();
        }
    }

    @Override
    public Set<String> getIdentityProviderID() {
        HashSet<String> identityProviders = new HashSet<String>();
        Properties idp = new Properties();
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/identityproviders.properties");
        File identityProviderFile = new File(builder.toString());
        if (identityProviderFile.exists()) {
            try {
                idp.load(new FileInputStream(identityProviderFile));
                String listOfIDP = (String)idp.get("IDP");
                StringTokenizer st = new StringTokenizer(listOfIDP, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    identityProviders.add(token);
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception loading the identity providers:", (Throwable)e);
            }
        }
        return identityProviders;
    }

    @Override
    public Set<String> getServiceProviderID() {
        HashSet<String> serviceProviders = new HashSet<String>();
        Properties sp = new Properties();
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/serviceproviders.properties");
        File serviceProviderFile = new File(builder.toString());
        if (serviceProviderFile.exists()) {
            try {
                sp.load(new FileInputStream(serviceProviderFile));
                String listOfSP = (String)sp.get("SP");
                StringTokenizer st = new StringTokenizer(listOfSP, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    serviceProviders.add(token);
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception loading the service providers:", (Throwable)e);
            }
        }
        return serviceProviders;
    }

    @Override
    public EntityDescriptorType load(String id) throws IOException {
        File persistedFile = this.validateIdAndReturnMDFile(id);
        try {
            Unmarshaller un = JAXBUtil.getUnmarshaller(this.pkgName);
            JAXBElement je = (JAXBElement)un.unmarshal(persistedFile);
            return (EntityDescriptorType)je.getValue();
        }
        catch (JAXBException e) {
            IOException ioe = new IOException(e.getLocalizedMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public void persist(EntityDescriptorType entity, String id) throws IOException {
        boolean isIDP = false;
        boolean isSP = false;
        File persistedFile = this.validateIdAndReturnMDFile(id);
        ObjectFactory of = new ObjectFactory();
        JAXBElement<EntityDescriptorType> jentity = of.createEntityDescriptor(entity);
        try {
            Marshaller m = JAXBUtil.getMarshaller(this.pkgName);
            m.marshal(jentity, persistedFile);
        }
        catch (JAXBException e) {
            IOException ioe = new IOException(e.getLocalizedMessage());
            ioe.initCause(e);
            throw ioe;
        }
        if (this.trace) {
            log.trace((Object)("Persisted into " + persistedFile.getPath()));
        }
        List<RoleDescriptorType> roleDescriptorTypes = entity.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor();
        for (RoleDescriptorType rdt : roleDescriptorTypes) {
            if (rdt instanceof IDPSSODescriptorType) {
                isIDP = true;
                break;
            }
            if (!(rdt instanceof SPSSODescriptorType)) continue;
            isSP = true;
            break;
        }
        if (isSP) {
            this.addServiceProvider(id);
        } else if (isIDP) {
            this.addIdentityProvider(id);
        }
    }

    @Override
    public void delete(String id) {
        File persistedFile = this.validateIdAndReturnMDFile(id);
        if (persistedFile.exists()) {
            persistedFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> loadTrustedProviders(String id) throws IOException, ClassNotFoundException {
        File trustedFile = this.validateIdAndReturnTrustedProvidersFile(id);
        ObjectInputStream ois = null;
        try {
            Map trustedMap;
            ois = new ObjectInputStream(new FileInputStream(trustedFile));
            Map map = trustedMap = (Map)ois.readObject();
            return map;
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistTrustedProviders(String id, Map<String, String> trusted) throws IOException {
        File trustedFile = this.validateIdAndReturnTrustedProvidersFile(id);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(trustedFile));
            oos.writeObject(trusted);
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        if (this.trace) {
            log.trace((Object)("Persisted trusted map into " + trustedFile.getPath()));
        }
    }

    @Override
    public void deleteTrustedProviders(String id) {
        File persistedFile = this.validateIdAndReturnTrustedProvidersFile(id);
        if (persistedFile.exists()) {
            persistedFile.delete();
        }
    }

    private File validateIdAndReturnMDFile(String id) {
        String serializationExtension = ".SER";
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (!id.endsWith(serializationExtension)) {
            id = id + serializationExtension;
        }
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/").append(id);
        return new File(builder.toString());
    }

    private File validateIdAndReturnTrustedProvidersFile(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        id = id + "-trusted.SER";
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/").append(id);
        return new File(builder.toString());
    }

    private void addServiceProvider(String id) {
        Properties sp = new Properties();
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/serviceproviders.properties");
        File serviceProviderFile = new File(builder.toString());
        try {
            if (!serviceProviderFile.exists()) {
                serviceProviderFile.createNewFile();
            }
            sp.load(new FileInputStream(serviceProviderFile));
            String listOfSP = (String)sp.get("SP");
            listOfSP = listOfSP == null ? id : listOfSP + "," + id;
            sp.put("SP", listOfSP);
            sp.store(new FileWriter(serviceProviderFile), "");
        }
        catch (Exception e) {
            log.error((Object)"Exception loading the service providers:", (Throwable)e);
        }
    }

    private void addIdentityProvider(String id) {
        Properties idp = new Properties();
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/identityproviders.properties");
        File idpProviderFile = new File(builder.toString());
        try {
            if (!idpProviderFile.exists()) {
                idpProviderFile.createNewFile();
            }
            idp.load(new FileInputStream(idpProviderFile));
            String listOfIDP = (String)idp.get("IDP");
            listOfIDP = listOfIDP == null ? id : listOfIDP + "," + id;
            idp.put("IDP", listOfIDP);
            idp.store(new FileWriter(idpProviderFile), "");
        }
        catch (Exception e) {
            log.error((Object)"Exception loading the identity providers:", (Throwable)e);
        }
    }

    @Override
    public void cleanup() {
    }
}

