/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.util;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.config.AuthPropertyType;
import org.picketlink.identity.federation.core.config.ClaimsProcessorType;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.config.KeyValueType;
import org.picketlink.identity.federation.core.config.ProviderType;
import org.picketlink.identity.federation.core.config.TokenProviderType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.util.PBEUtils;
import org.picketlink.identity.federation.core.util.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreConfigUtil {
    private static Logger log = Logger.getLogger(CoreConfigUtil.class);

    public static TrustKeyManager getTrustKeyManager(ProviderType idpOrSPConfiguration) {
        KeyProviderType keyProvider = idpOrSPConfiguration.getKeyProvider();
        return CoreConfigUtil.getTrustKeyManager(keyProvider);
    }

    public static TrustKeyManager getTrustKeyManager(KeyProviderType keyProvider) {
        TrustKeyManager trustKeyManager = null;
        try {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("KeyManager class name is null");
            }
            Class<?> clazz = tcl.loadClass(keyManagerClassName);
            trustKeyManager = (TrustKeyManager)clazz.newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Exception in getting TrustKeyManager:", (Throwable)e);
        }
        return trustKeyManager;
    }

    public static PublicKey getValidatingKey(ProviderType idpSpConfiguration, String domain) throws ConfigurationException, ProcessingException {
        TrustKeyManager trustKeyManager = CoreConfigUtil.getTrustKeyManager(idpSpConfiguration);
        return CoreConfigUtil.getValidatingKey(trustKeyManager, domain);
    }

    public static PublicKey getValidatingKey(TrustKeyManager trustKeyManager, String domain) throws ConfigurationException, ProcessingException {
        if (trustKeyManager == null) {
            throw new IllegalArgumentException("Trust Key Manager is null");
        }
        return trustKeyManager.getValidatingKey(domain);
    }

    public static List<AuthPropertyType> getKeyProviderProperties(KeyProviderType keyProviderType) throws GeneralSecurityException {
        List authProperties = keyProviderType.getAuth();
        if (CoreConfigUtil.decryptionNeeded(authProperties)) {
            authProperties = CoreConfigUtil.decryptPasswords(authProperties);
        }
        return authProperties;
    }

    public static List<KeyValueType> getProperties(TokenProviderType tokenProviderType) throws GeneralSecurityException {
        List keyValueTypeList = tokenProviderType.getProperty();
        if (CoreConfigUtil.decryptionNeeded(keyValueTypeList)) {
            keyValueTypeList = CoreConfigUtil.decryptPasswords(keyValueTypeList);
        }
        return keyValueTypeList;
    }

    public static List<KeyValueType> getProperties(ClaimsProcessorType claimsProcessorType) throws GeneralSecurityException {
        List keyValueTypeList = claimsProcessorType.getProperty();
        if (CoreConfigUtil.decryptionNeeded(keyValueTypeList)) {
            keyValueTypeList = CoreConfigUtil.decryptPasswords(keyValueTypeList);
        }
        return keyValueTypeList;
    }

    public static boolean decryptionNeeded(List<? extends KeyValueType> keyValueList) {
        int length = keyValueList.size();
        for (int i = 0; i < length; ++i) {
            KeyValueType kvt = keyValueList.get(i);
            String key = kvt.getKey();
            if (!"salt".equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    private static List decryptPasswords(List keyValueList) throws GeneralSecurityException {
        String pbeAlgo = "PBEwithMD5andDES";
        String salt = null;
        int iterationCount = 0;
        int length = keyValueList.size();
        for (int i = 0; i < length; ++i) {
            KeyValueType kvt = (KeyValueType)keyValueList.get(i);
            String key = kvt.getKey();
            if ("salt".equalsIgnoreCase(key)) {
                salt = kvt.getValue();
            }
            if (!"iterationCount".equalsIgnoreCase(key)) continue;
            iterationCount = Integer.parseInt(kvt.getValue());
        }
        if (salt == null) {
            return keyValueList;
        }
        ArrayList<KeyValueType> returningList = new ArrayList<KeyValueType>();
        SecretKeyFactory factory = SecretKeyFactory.getInstance(pbeAlgo);
        char[] password = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt.getBytes(), iterationCount);
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKey cipherKey = factory.generateSecret(keySpec);
        for (int i = 0; i < length; ++i) {
            KeyValueType kvt = (KeyValueType)keyValueList.get(i);
            String val = kvt.getValue();
            if (val.startsWith("MASK-")) {
                String decodedValue;
                val = val.substring("MASK-".length());
                try {
                    decodedValue = PBEUtils.decode64(val, pbeAlgo, cipherKey, cipherSpec);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                KeyValueType newKVT = new KeyValueType();
                if (keyValueList.get(0) instanceof AuthPropertyType) {
                    newKVT = new AuthPropertyType();
                }
                newKVT.setKey(kvt.getKey());
                newKVT.setValue(new String(decodedValue));
                returningList.add(newKVT);
                continue;
            }
            returningList.add(kvt);
        }
        return returningList;
    }
}

