/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.io.InputStream;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.handler.config.Handler;
import org.picketlink.identity.federation.core.handler.config.Handlers;
import org.picketlink.identity.federation.core.util.JAXBUtil;
import org.picketlink.identity.federation.core.wstrust.PicketLinkSTSConfiguration;
import org.picketlink.identity.federation.core.wstrust.STSConfiguration;
import org.picketlink.identity.federation.core.wstrust.SecurityActions;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.WSTrustJAXBFactory;
import org.picketlink.identity.federation.core.wstrust.WSTrustRequestHandler;
import org.picketlink.identity.federation.core.wstrust.confighandlers.STSConfigHandler;
import org.picketlink.identity.federation.core.wstrust.wrappers.BaseRequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenCollection;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponse;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponseCollection;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider(serviceName="PicketLinkSTS", portName="PicketLinkSTSPort", targetNamespace="urn:picketlink:identity-federation:sts", wsdlLocation="WEB-INF/wsdl/PicketLinkSTS.wsdl")
@ServiceMode(value=Service.Mode.PAYLOAD)
public class PicketLinkSTS
implements Provider<Source> {
    private static Logger logger = Logger.getLogger(PicketLinkSTS.class);
    @Resource
    protected WebServiceContext context;
    protected STSConfiguration config;

    public Source invoke(Source request) {
        BaseRequestSecurityToken baseRequest;
        if (this.config == null) {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Loading STS configuration");
                }
                this.config = this.getConfiguration();
            }
            catch (ConfigurationException e) {
                throw new WebServiceException("Encountered configuration exception:", (Throwable)e);
            }
        }
        try {
            baseRequest = WSTrustJAXBFactory.getInstance().parseRequestSecurityToken(request);
        }
        catch (WSTrustException we) {
            throw new RuntimeException(we);
        }
        if (baseRequest instanceof RequestSecurityToken) {
            return this.handleTokenRequest((RequestSecurityToken)baseRequest);
        }
        if (baseRequest instanceof RequestSecurityTokenCollection) {
            return this.handleTokenRequestCollection((RequestSecurityTokenCollection)baseRequest);
        }
        throw new WebServiceException("Invalid security token request");
    }

    protected Source handleTokenRequest(RequestSecurityToken request) {
        WSTrustRequestHandler handler = this.config.getRequestHandler();
        String requestType = request.getRequestType().toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("STS received request of type " + requestType));
        }
        try {
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue")) {
                Source source = this.marshallResponse(handler.issue(request, this.context.getUserPrincipal()));
                Document doc = handler.postProcess((Document)((DOMSource)source).getNode(), request);
                return new DOMSource(doc);
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew")) {
                Source source = this.marshallResponse(handler.renew(request, this.context.getUserPrincipal()));
                Document document = handler.postProcess((Document)((DOMSource)source).getNode(), request);
                return new DOMSource(document);
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel")) {
                return this.marshallResponse(handler.cancel(request, this.context.getUserPrincipal()));
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate")) {
                return this.marshallResponse(handler.validate(request, this.context.getUserPrincipal()));
            }
            throw new WSTrustException("Invalid request type: " + requestType);
        }
        catch (WSTrustException we) {
            throw new WebServiceException("Exception in handling token request: " + we.getMessage(), (Throwable)we);
        }
    }

    protected Source handleTokenRequestCollection(RequestSecurityTokenCollection requestCollection) {
        String requestType = requestCollection.getRequestSecurityTokens().get(0).getRequestType().toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("STS received requests of type " + requestType));
        }
        WSTrustRequestHandler handler = this.config.getRequestHandler();
        try {
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchIssue")) {
                RequestSecurityTokenResponseCollection responseCollection = new RequestSecurityTokenResponseCollection();
                for (RequestSecurityToken request : requestCollection.getRequestSecurityTokens()) {
                    responseCollection.addRequestSecurityTokenResponse(handler.issue(request, this.context.getUserPrincipal()));
                }
                Source source = WSTrustJAXBFactory.getInstance().marshallRequestSecurityTokenResponse(responseCollection);
                handler.postProcess((Document)((DOMSource)source).getNode(), requestCollection.getRequestSecurityTokens().toArray(new RequestSecurityToken[0]));
                return source;
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchRenew")) {
                RequestSecurityTokenResponseCollection responseCollection = new RequestSecurityTokenResponseCollection();
                for (RequestSecurityToken request : requestCollection.getRequestSecurityTokens()) {
                    responseCollection.addRequestSecurityTokenResponse(handler.renew(request, this.context.getUserPrincipal()));
                }
                Source source = WSTrustJAXBFactory.getInstance().marshallRequestSecurityTokenResponse(responseCollection);
                handler.postProcess((Document)((DOMSource)source).getNode(), requestCollection.getRequestSecurityTokens().toArray(new RequestSecurityToken[0]));
                return source;
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchCancel")) {
                RequestSecurityTokenResponseCollection responseCollection = new RequestSecurityTokenResponseCollection();
                for (RequestSecurityToken request : requestCollection.getRequestSecurityTokens()) {
                    responseCollection.addRequestSecurityTokenResponse(handler.cancel(request, this.context.getUserPrincipal()));
                }
                return WSTrustJAXBFactory.getInstance().marshallRequestSecurityTokenResponse(responseCollection);
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchValidate")) {
                RequestSecurityTokenResponseCollection responseCollection = new RequestSecurityTokenResponseCollection();
                for (RequestSecurityToken request : requestCollection.getRequestSecurityTokens()) {
                    responseCollection.addRequestSecurityTokenResponse(handler.validate(request, this.context.getUserPrincipal()));
                }
                return WSTrustJAXBFactory.getInstance().marshallRequestSecurityTokenResponse(responseCollection);
            }
            throw new WSTrustException("Invalid request type: " + requestType);
        }
        catch (WSTrustException we) {
            throw new WebServiceException("Exception in handling token request: " + we.getMessage(), (Throwable)we);
        }
    }

    protected Source marshallResponse(RequestSecurityTokenResponse response) {
        RequestSecurityTokenResponseCollection responseCollection = new RequestSecurityTokenResponseCollection();
        responseCollection.addRequestSecurityTokenResponse(response);
        return WSTrustJAXBFactory.getInstance().marshallRequestSecurityTokenResponse(responseCollection);
    }

    protected STSConfiguration getConfiguration() throws ConfigurationException {
        STSConfiguration configuration = null;
        try {
            JAXBElement handlersJaxb = (JAXBElement)this.unmarshall("picketlink-sts-confighandlers.xml");
            if (handlersJaxb == null) {
                throw new RuntimeException("picketlink-sts-confighandlers.xml not found ");
            }
            Handlers handlers = (Handlers)handlersJaxb.getValue();
            List<Handler> handlerList = handlers.getHandler();
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            if (handlerList != null) {
                for (Handler handler : handlerList) {
                    Class<?> clazz = tcl.loadClass(handler.getClazz());
                    STSConfigHandler stsConfigHandler = (STSConfigHandler)clazz.newInstance();
                    stsConfigHandler.setOptions(handler.getOption());
                    configuration = stsConfigHandler.getConfiguration();
                    if (configuration == null) continue;
                    break;
                }
            }
            if (configuration == null) {
                logger.warn((Object)"Configuration handlers returned null. Using default configuration values");
                return new PicketLinkSTSConfiguration();
            }
            return configuration;
        }
        catch (Exception e) {
            throw new ConfigurationException("Error parsing the configuration file:", e);
        }
    }

    private Object unmarshall(String configFile) throws Exception {
        String[] schemas = new String[]{"schema/config/picketlink-fed.xsd", "schema/config/picketlink-fed-handler.xsd"};
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        InputStream is = tcl.getResourceAsStream(configFile);
        if (is == null) {
            throw new RuntimeException("Inputstream not null for config file:" + configFile);
        }
        String[] pkgNames = new String[]{"org.picketlink.identity.federation.core.config", "org.picketlink.identity.federation.core.handler.config"};
        Unmarshaller un = JAXBUtil.getValidatingUnmarshaller(pkgNames, schemas);
        return un.unmarshal(is);
    }
}

