/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.servlets;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.picketlink.identity.federation.api.openid.OpenIDManager;
import org.picketlink.identity.federation.api.openid.OpenIDRequest;
import org.picketlink.identity.federation.api.openid.exceptions.OpenIDGeneralException;
import org.picketlink.identity.federation.web.openid.HTTPOpenIDContext;
import org.picketlink.identity.federation.web.openid.HTTPProtocolAdaptor;

public class OpenIDConsumerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private transient ServletContext servletContext;
    private String returnURL;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletContext = config.getServletContext();
        this.returnURL = this.servletContext.getInitParameter("returnURL");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.returnURL == null) {
            this.returnURL = "http://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath() + "/consumer_return.jsp";
        }
        String userEntry = req.getParameter("openid");
        OpenIDRequest openIDReq = new OpenIDRequest(userEntry);
        HttpSession session = req.getSession();
        OpenIDManager manager = (OpenIDManager)session.getAttribute("openid_manager");
        if (manager == null) {
            manager = new OpenIDManager(openIDReq);
            session.setAttribute("openid_manager", (Object)manager);
        }
        try {
            OpenIDManager.OpenIDProviderList listOfProviders = manager.discoverProviders();
            HTTPOpenIDContext httpOpenIDCtx = new HTTPOpenIDContext(req, resp, this.servletContext);
            httpOpenIDCtx.setReturnURL(this.returnURL);
            HTTPProtocolAdaptor adapter = new HTTPProtocolAdaptor(httpOpenIDCtx);
            OpenIDManager.OpenIDProviderInformation providerInfo = manager.associate(adapter, listOfProviders);
            manager.authenticate(adapter, providerInfo);
        }
        catch (OpenIDGeneralException e) {
            this.log("[OpenIDConsumerServlet]Exception in dealing with the provider:", e);
            resp.sendError(500);
        }
    }
}

