/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.picketlink.identity.federation.core.saml.v2.interfaces;

import java.util.List;

import org.w3c.dom.Document;

/**
 * A response object sent to the 
 * {@code SAML2Handler} as part of a chain
 * @author Anil.Saldhana@redhat.com
 * @since Sep 25, 2009
 */
public interface SAML2HandlerResponse
{
   /**
    * Set the destination where the response
    * from the current processing node is sent
    * @param destination
    */
   void setDestination(String destination);
   
   /**
    * Get the destination
    * @return
    */
   String getDestination();
   
   /**
    * Set the resulting document from the handler
    * @param doc
    */
   void setResultingDocument(Document doc);
   
   /**
    * Set any relay state that needs to be used 
    * in the workflow
    * @param relayState
    */
   void setRelayState(String relayState);
   
   /**
    * Get the resulting document from the handler invocation
    * @return
    */
   Document getResultingDocument();
   
   /**
    * Get the relay state
    * @return
    */
   String getRelayState();
   
   /**
    * Set an roles that are generated by handlers
    * @param roles
    */
   void setRoles(List<String> roles);
   
   /**
    * Get the roles generated by handlers
    * @return
    */
   List<String> getRoles();
   
   /**
    * Specifies whether the handler chain processing
    * resulted in an error
    * @return
    */
   boolean isInError();
   
   /**
    * Handler can set an error
    * @param errorCode
    * @param errorMessage
    */
   void setError(int errorCode, String errorMessage);
   
   /**
    * Get the error code set in the handler chain
    * @return
    */
   int getErrorCode();
   
   /**
    * Get the error message set in the handler chain
    * @return
    */
   String getErrorMessage();
   
   /**
    * Will the resulting document be a SAMLRequest?
    * @param request
    */
   void setSendRequest(boolean request);
   
   /**
    * @see #setSendRequest(boolean)
    * @return
    */
   boolean getSendRequest();
   
   /**
    * Set whether the response should be using the Post Binding
    * @param postB
    */ 
   void setPostBindingForResponse(boolean postB);
   
   /**
    * Should the response be in post binding?
    * @return
    */
   boolean isPostBindingForResponse();
}