/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.wst;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.ParserController;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.parsers.wst.WSTCancelTargetParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTRenewTargetParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTValidateTargetParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTrustOnBehalfOfParser;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.ws.addressing.AttributedURIType;
import org.picketlink.identity.federation.ws.addressing.EndpointReferenceType;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.trust.BinarySecretType;
import org.picketlink.identity.federation.ws.trust.CancelTargetType;
import org.picketlink.identity.federation.ws.trust.EntropyType;
import org.picketlink.identity.federation.ws.trust.LifetimeType;
import org.picketlink.identity.federation.ws.trust.OnBehalfOfType;
import org.picketlink.identity.federation.ws.trust.RenewTargetType;
import org.picketlink.identity.federation.ws.trust.SimpleAnyType;
import org.picketlink.identity.federation.ws.trust.UseKeyType;
import org.picketlink.identity.federation.ws.trust.ValidateTargetType;
import org.picketlink.identity.federation.ws.wss.utility.AttributedDateTime;
import org.w3c.dom.Element;

public class WSTRequestSecurityTokenParser
implements ParserNamespaceSupport {
    protected Logger log = Logger.getLogger(WSTRequestSecurityTokenParser.class);
    protected boolean trace = this.log.isTraceEnabled();
    public static final String X509CERTIFICATE = "X509Certificate";
    public static final String KEYVALUE = "KeyValue";

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        RequestSecurityToken requestToken = new RequestSecurityToken();
        QName contextQName = new QName("", "Context");
        Attribute contextAttribute = startElement.getAttributeByName(contextQName);
        if (contextAttribute != null) {
            String contextValue = StaxParserUtil.getAttributeValue(contextAttribute);
            requestToken.setContext(contextValue);
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                xmlEvent = StaxParserUtil.getNextEvent(xmlEventReader);
                EndElement endElement = (EndElement)xmlEvent;
                String endElementTag = StaxParserUtil.getEndElementName(endElement);
                if (endElementTag.equals("RequestSecurityToken")) break;
                throw new RuntimeException("PL00061: Parser: Unknown End Element:" + endElementTag);
            }
            try {
                ParserNamespaceSupport parser;
                EndElement validateTargetEndElement;
                SimpleAnyType validateTarget;
                ParserNamespaceSupport wstValidateTargetParser;
                String value;
                StartElement subEvent = StaxParserUtil.peekNextStartElement(xmlEventReader);
                if (subEvent == null) break;
                String tag = StaxParserUtil.getStartElementName(subEvent);
                if (tag.equals("RequestType")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                        throw new ParsingException("PL00071: Parser: Expected text value:request type");
                    }
                    value = StaxParserUtil.getElementText(xmlEventReader);
                    requestToken.setRequestType(new URI(value));
                    continue;
                }
                if (tag.equals("TokenType")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                        throw new ParsingException("PL00071: Parser: Expected text value:token type");
                    }
                    value = StaxParserUtil.getElementText(xmlEventReader);
                    requestToken.setTokenType(new URI(value));
                    continue;
                }
                if (tag.equals("Lifetime")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    StaxParserUtil.validate(subEvent, "Lifetime");
                    LifetimeType lifeTime = new LifetimeType();
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    String subTag = StaxParserUtil.getStartElementName(subEvent);
                    if (subTag.equals("Created")) {
                        AttributedDateTime created = new AttributedDateTime();
                        created.setValue(StaxParserUtil.getElementText(xmlEventReader));
                        lifeTime.setCreated(created);
                    }
                    if (!(subTag = StaxParserUtil.getStartElementName(subEvent = StaxParserUtil.getNextStartElement(xmlEventReader))).equals("Expires")) {
                        throw new RuntimeException("PL00062: Parser : Unknown tag:" + subTag);
                    }
                    AttributedDateTime expires = new AttributedDateTime();
                    expires.setValue(StaxParserUtil.getElementText(xmlEventReader));
                    lifeTime.setExpires(expires);
                    requestToken.setLifetime(new Lifetime(lifeTime));
                    EndElement lifeTimeElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(lifeTimeElement, "Lifetime");
                    continue;
                }
                if (tag.equals("CancelTarget")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    StaxParserUtil.validate(subEvent, "CancelTarget");
                    WSTCancelTargetParser wstCancelTargetParser = new WSTCancelTargetParser();
                    CancelTargetType cancelTarget = (CancelTargetType)wstCancelTargetParser.parse(xmlEventReader);
                    requestToken.setCancelTarget(cancelTarget);
                    EndElement cancelTargetEndElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(cancelTargetEndElement, "CancelTarget");
                    continue;
                }
                if (tag.equals("ValidateTarget")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    wstValidateTargetParser = new WSTValidateTargetParser();
                    validateTarget = (ValidateTargetType)((WSTValidateTargetParser)wstValidateTargetParser).parse(xmlEventReader);
                    requestToken.setValidateTarget((ValidateTargetType)validateTarget);
                    validateTargetEndElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(validateTargetEndElement, "ValidateTarget");
                    continue;
                }
                if (tag.equals("RenewTarget")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    wstValidateTargetParser = new WSTRenewTargetParser();
                    validateTarget = (RenewTargetType)((WSTRenewTargetParser)wstValidateTargetParser).parse(xmlEventReader);
                    requestToken.setRenewTarget((RenewTargetType)validateTarget);
                    validateTargetEndElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(validateTargetEndElement, "RenewTarget");
                    continue;
                }
                if (tag.equals("OnBehalfOf")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    WSTrustOnBehalfOfParser wstOnBehalfOfParser = new WSTrustOnBehalfOfParser();
                    OnBehalfOfType onBehalfOf = (OnBehalfOfType)wstOnBehalfOfParser.parse(xmlEventReader);
                    requestToken.setOnBehalfOf(onBehalfOf);
                    EndElement onBehalfOfEndElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(onBehalfOfEndElement, "OnBehalfOf");
                    continue;
                }
                if (tag.equals("KeyType")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                        throw new ParsingException("PL00071: Parser: Expected text value:key type");
                    }
                    String keyType = StaxParserUtil.getElementText(xmlEventReader);
                    try {
                        URI keyTypeURI = new URI(keyType);
                        requestToken.setKeyType(keyTypeURI);
                        continue;
                    }
                    catch (URISyntaxException e) {
                        throw new ParsingException(e);
                    }
                }
                if (tag.equals("KeySize")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                        throw new ParsingException("PL00071: Parser: Expected text value:key size");
                    }
                    String keySize = StaxParserUtil.getElementText(xmlEventReader);
                    try {
                        requestToken.setKeySize(Long.parseLong(keySize));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ParsingException(e);
                    }
                }
                if (tag.equals("Entropy")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    EntropyType entropy = new EntropyType();
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    if (StaxParserUtil.matches(subEvent, "BinarySecret")) {
                        BinarySecretType binarySecret = new BinarySecretType();
                        Attribute typeAttribute = subEvent.getAttributeByName(new QName("", "Type"));
                        binarySecret.setType(StaxParserUtil.getAttributeValue(typeAttribute));
                        if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                            throw new ParsingException("PL00071: Parser: Expected text value:binary secret value");
                        }
                        binarySecret.setValue(StaxParserUtil.getElementText(xmlEventReader).getBytes());
                        entropy.addAny(binarySecret);
                    }
                    requestToken.setEntropy(entropy);
                    EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(endElement, "Entropy");
                    continue;
                }
                if (tag.equals("Issuer")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    StaxParserUtil.validate(subEvent, "Issuer");
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    StaxParserUtil.validate(subEvent, "Address");
                    String addressValue = StaxParserUtil.getElementText(xmlEventReader);
                    EndpointReferenceType endpointRef = new EndpointReferenceType();
                    AttributedURIType attrURI = new AttributedURIType();
                    attrURI.setValue(addressValue);
                    endpointRef.setAddress(new AttributedURIType());
                    requestToken.setIssuer(endpointRef);
                    EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(endElement, "Issuer");
                    continue;
                }
                if (tag.equals("UseKey")) {
                    Element domElement;
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    UseKeyType useKeyType = new UseKeyType();
                    StaxParserUtil.validate(subEvent, "UseKey");
                    subEvent = StaxParserUtil.peekNextStartElement(xmlEventReader);
                    if (StaxParserUtil.matches(subEvent, X509CERTIFICATE)) {
                        domElement = StaxParserUtil.getDOMElement(xmlEventReader);
                        useKeyType.add(domElement);
                        requestToken.setUseKey(useKeyType);
                        continue;
                    }
                    if (StaxParserUtil.matches(subEvent, KEYVALUE)) {
                        domElement = StaxParserUtil.getDOMElement(xmlEventReader);
                        useKeyType.add(domElement);
                        requestToken.setUseKey(useKeyType);
                        EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                        StaxParserUtil.validate(endElement, "UseKey");
                        continue;
                    }
                    throw new RuntimeException("PL00069: Parser: Type not supported:" + StaxParserUtil.getStartElementName(subEvent));
                }
                QName qname = subEvent.getName();
                if (this.trace) {
                    this.log.trace((Object)("Looking for Parser for :" + qname));
                }
                if ((parser = ParserController.get(qname)) == null) {
                    throw new RuntimeException("PL00062: Parser : Unknown tag:" + qname);
                }
                Object parsedObject = parser.parse(xmlEventReader);
                if (!(parsedObject instanceof AppliesTo)) continue;
                requestToken.setAppliesTo((AppliesTo)parsedObject);
            }
            catch (URISyntaxException e) {
                throw new ParsingException(e);
            }
        }
        return requestToken;
    }

    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(nsURI) && "RequestSecurityToken".equals(localPart);
    }
}

