/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketbox.test.ldap.AbstractLDAPTest;
import org.picketlink.idm.internal.LDAPIdentityStore;
import org.picketlink.idm.internal.config.LDAPConfiguration;
import org.picketlink.idm.internal.config.LDAPConfigurationBuilder;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.Membership;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.spi.IdentityStoreConfigurationBuilder;

public class LDAPIdentityStoreTestCase
extends AbstractLDAPTest {
    @Before
    public void setup() throws Exception {
        super.setup();
        this.importLDIF("ldap/users.ldif");
    }

    private LDAPConfiguration getConfiguration() {
        String fqn = LDAPConfigurationBuilder.class.getName();
        LDAPConfiguration config = (LDAPConfiguration)IdentityStoreConfigurationBuilder.config((String)fqn);
        config.setBindDN(this.adminDN).setBindCredential(this.adminPW).setLdapURL("ldap://localhost:10389");
        config.setUserDNSuffix("ou=People,dc=jboss,dc=org").setRoleDNSuffix("ou=Roles,dc=jboss,dc=org");
        config.setGroupDNSuffix("ou=Groups,dc=jboss,dc=org");
        return config;
    }

    @Test
    public void testLDAPIdentityStore() throws Exception {
        LDAPIdentityStore store = new LDAPIdentityStore();
        store.setConfiguration(this.getConfiguration());
        User user = store.createUser("Anil Saldhana");
        Assert.assertNotNull((Object)user);
        User anil = store.getUser("Anil Saldhana");
        Assert.assertNotNull((Object)anil);
        Assert.assertEquals((Object)"Anil Saldhana", (Object)anil.getFullName());
        Assert.assertEquals((Object)"Anil", (Object)anil.getFirstName());
        Assert.assertEquals((Object)"Saldhana", (Object)anil.getLastName());
        Role role = store.createRole("testRole");
        Assert.assertNotNull((Object)role);
        Assert.assertEquals((Object)"testRole", (Object)role.getName());
        Role ldapRole = store.getRole("testRole");
        Assert.assertNotNull((Object)ldapRole);
        Assert.assertEquals((Object)"testRole", (Object)ldapRole.getName());
        Group ldapGroup = store.createGroup("PicketBox Team", null);
        Assert.assertNotNull((Object)ldapGroup);
        Group retrievedLDAPGroup = store.getGroup("PicketBox Team");
        Assert.assertNotNull((Object)retrievedLDAPGroup);
        Assert.assertNull((Object)retrievedLDAPGroup.getParentGroup());
        Group devGroup = store.createGroup("Dev", ldapGroup);
        Assert.assertNotNull((Object)devGroup);
        Group retrievedDevGroup = store.getGroup("Dev");
        Assert.assertNotNull((Object)retrievedDevGroup);
        Group parentOfDevGroup = retrievedDevGroup.getParentGroup();
        Assert.assertNotNull((Object)parentOfDevGroup);
        Assert.assertEquals((Object)"PicketBox Team", (Object)parentOfDevGroup.getName());
        Membership membership = store.createMembership(ldapRole, anil, ldapGroup);
        Assert.assertNotNull((Object)membership);
        store.removeMembership(ldapRole, anil, ldapGroup);
        store.removeUser(anil);
        store.removeRole(ldapRole);
        store.removeGroup(ldapGroup);
        store.removeGroup(devGroup);
        anil = store.getUser("Anil Saldhana");
        Assert.assertNull((Object)anil);
        ldapRole = store.getRole("testRole");
        Assert.assertNull((Object)ldapRole);
        Assert.assertNull((Object)store.getGroup("Dev"));
        Assert.assertNull((Object)store.getGroup("PicketBox Team"));
    }
}

