/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.picketlink.idm.internal.JPAIdentityStore;
import org.picketlink.idm.internal.jpa.JPATemplate;
import org.picketlink.idm.spi.IdentityStore;

public abstract class AbstractJPAIdentityStoreTestCase {
    protected static EntityManagerFactory emf;
    protected EntityManager entityManager;

    @BeforeClass
    public static void onBeforeTests() throws Exception {
        emf = Persistence.createEntityManagerFactory((String)"jpa-identity-store-tests-pu");
    }

    @AfterClass
    public static void onAfterTests() throws Exception {
        emf.close();
    }

    @Before
    public void onSetupTest() throws Exception {
        this.entityManager = emf.createEntityManager();
        this.entityManager.getTransaction().begin();
    }

    @After
    public void onFinishTest() throws Exception {
        this.entityManager.flush();
        this.entityManager.getTransaction().commit();
        this.entityManager.close();
    }

    protected IdentityStore createIdentityStore() {
        JPAIdentityStore identityStore = new JPAIdentityStore();
        JPATemplate jpaTemplate = new JPATemplate();
        jpaTemplate.setEntityManager(this.entityManager);
        identityStore.setJpaTemplate(jpaTemplate);
        return identityStore;
    }
}

