/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.jpa;

import org.junit.Assert;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.test.idm.internal.jpa.AbstractJPAIdentityStoreTestCase;

public abstract class AbstractJPAIdentityTypeTestCase
extends AbstractJPAIdentityStoreTestCase {
    public void testAddAttributes() throws Exception {
        IdentityStore identityStore = this.createIdentityStore();
        IdentityType identityType = this.getIdentityTypeFromDatabase(identityStore);
        identityType.setAttribute("QuestionTotal", "2");
        identityType.setAttribute("Question1", "What is favorite toy?");
        identityType.setAttribute("Question1Answer", "Gum");
        identityType.setAttribute("MultiValuedAttribute", new String[]{"value1", "value2", "value3"});
        junit.framework.Assert.assertEquals((String)"2", (String)identityType.getAttribute("QuestionTotal"));
        junit.framework.Assert.assertEquals((String)"What is favorite toy?", (String)identityType.getAttribute("Question1"));
        junit.framework.Assert.assertEquals((String)"Gum", (String)identityType.getAttribute("Question1Answer"));
        junit.framework.Assert.assertEquals((String)"value1", (String)identityType.getAttributeValues("MultiValuedAttribute")[0]);
        junit.framework.Assert.assertEquals((String)"value2", (String)identityType.getAttributeValues("MultiValuedAttribute")[1]);
        junit.framework.Assert.assertEquals((String)"value3", (String)identityType.getAttributeValues("MultiValuedAttribute")[2]);
    }

    protected abstract IdentityType getIdentityTypeFromDatabase(IdentityStore var1);

    public void testRemoveAttributes() throws Exception {
        IdentityStore identityStore = this.createIdentityStore();
        IdentityType identityType = this.getIdentityTypeFromDatabase(identityStore);
        junit.framework.Assert.assertNotNull((Object)identityType.getAttributeValues("MultiValuedAttribute"));
        identityType.removeAttribute("MultiValuedAttribute");
        Assert.assertNull((Object)identityType.getAttributeValues("MultiValuedAttribute"));
    }
}

