/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.jpa;

import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketlink.idm.internal.jpa.DefaultGroupQuery;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.GroupQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.test.idm.internal.jpa.AbstractJPAIdentityStoreTestCase;

public class JPAGroupQueryTestCase
extends AbstractJPAIdentityStoreTestCase {
    private static final String GROUP_PARENT_NAME = "parentGroup";
    private static final String USER_NAME = "theuser";
    private static final String GROUP_NAME = "Administrators";
    private Group group;
    private User user;
    private Group parentGroup;

    @Before
    public void onSetupTest() throws Exception {
        super.onSetupTest();
        this.loadGroups();
    }

    @Test
    public void testfindByName() throws Exception {
        DefaultGroupQuery query = new DefaultGroupQuery();
        query.setName(this.group.getName());
        this.assertQueryResult((GroupQuery)query);
    }

    @Test
    public void testfindById() throws Exception {
        DefaultGroupQuery query = new DefaultGroupQuery();
        query.setId(this.group.getId());
        this.assertQueryResult((GroupQuery)query);
    }

    @Test
    public void testfindByRole() throws Exception {
        DefaultGroupQuery query = new DefaultGroupQuery();
        query.setRole("admin1");
        this.assertQueryResult((GroupQuery)query);
    }

    @Test
    public void testfindByUser() throws Exception {
        DefaultGroupQuery query = new DefaultGroupQuery();
        query.setId(this.group.getId());
        query.setRelatedUser(this.user);
        this.assertQueryResult((GroupQuery)query);
    }

    @Test
    public void testfindByParentGroup() throws Exception {
        DefaultGroupQuery query = new DefaultGroupQuery();
        query.setId(this.group.getId());
        query.setParentGroup(this.parentGroup);
        this.assertQueryResult((GroupQuery)query);
    }

    @Test
    public void testfindByAttributes() throws Exception {
        DefaultGroupQuery query = new DefaultGroupQuery();
        query.setId(this.group.getId());
        query.addAttributeFilter("attribute1", new String[]{"attributeValue1", "attributeValue12", "attributeValue123"});
        query.addAttributeFilter("attribute2", new String[]{"attributeValue2"});
        this.assertQueryResult((GroupQuery)query);
    }

    private void loadGroups() {
        IdentityStore identityStore = this.createIdentityStore();
        this.group = identityStore.getGroup("Administrators1");
        this.user = identityStore.getUser(USER_NAME);
        this.parentGroup = identityStore.getGroup(GROUP_PARENT_NAME);
        if (this.group != null) {
            return;
        }
        this.user = identityStore.createUser(USER_NAME);
        this.parentGroup = identityStore.createGroup(GROUP_PARENT_NAME, null);
        for (int i = 0; i < 10; ++i) {
            int index = i + 1;
            Group currentGroup = identityStore.createGroup(GROUP_NAME + index, this.parentGroup);
            if (this.group == null) {
                this.group = currentGroup;
            }
            Role role = identityStore.createRole("admin" + index);
            identityStore.createMembership(role, this.user, currentGroup);
            currentGroup.setAttribute("attribute1", "attributeValue1");
            currentGroup.setAttribute("attribute1", "attributeValue12");
            currentGroup.setAttribute("attribute1", "attributeValue123");
            currentGroup.setAttribute("attribute2", "attributeValue2");
        }
    }

    private void assertQueryResult(GroupQuery query) {
        IdentityStore identityStore = this.createIdentityStore();
        List result = identityStore.executeQuery(query, null);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)this.group.getId(), (String)((Group)result.get(0)).getId());
    }
}

