/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.jpa;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.test.idm.internal.jpa.AbstractJPAIdentityTypeTestCase;

public class JPAGroupTestCase
extends AbstractJPAIdentityTypeTestCase {
    private static final String GROUP_NAME = "Administrators";
    private static final String GROUP_PARENT_NAME = "Company";

    @Test
    public void testGroupStore() throws Exception {
        IdentityStore identityStore = this.createIdentityStore();
        Group parentGroup = identityStore.createGroup(GROUP_PARENT_NAME, null);
        Group group = identityStore.createGroup(GROUP_NAME, parentGroup);
        Assert.assertNotNull((Object)group);
        Assert.assertNotNull((Object)group.getKey());
        Assert.assertEquals((Object)GROUP_NAME, (Object)group.getName());
        this.testAddAttributes();
        this.testGetGroup();
        this.testRemoveGroup();
    }

    public void testGetGroup() throws Exception {
        IdentityStore identityStore = this.createIdentityStore();
        Group group = identityStore.getGroup(GROUP_NAME);
        Assert.assertNotNull((Object)group);
        Assert.assertNotNull((Object)group.getParentGroup());
        Assert.assertNotNull((Object)group.getKey());
        Assert.assertEquals((Object)GROUP_NAME, (Object)group.getName());
        Assert.assertEquals((Object)GROUP_PARENT_NAME, (Object)group.getParentGroup().getName());
        this.testRemoveAttributes();
    }

    public void testRemoveGroup() throws Exception {
        IdentityStore identityStore = this.createIdentityStore();
        Group group = identityStore.getGroup(GROUP_NAME);
        Assert.assertNotNull((Object)group);
        identityStore.removeGroup(group);
        group = identityStore.getGroup(GROUP_NAME);
        Assert.assertNull((Object)group);
    }

    protected IdentityType getIdentityTypeFromDatabase(IdentityStore identityStore) {
        return identityStore.getGroup(GROUP_NAME);
    }
}

