/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.jpa;

import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketlink.idm.internal.jpa.DefaultMembershipQuery;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.Membership;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.MembershipQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.test.idm.internal.jpa.AbstractJPAIdentityStoreTestCase;

public class JPAMembershipQueryTestCase
extends AbstractJPAIdentityStoreTestCase {
    private static final String USER_NAME = "theuser";
    private static final String GROUP_NAME = "Administrators";
    private static final String ROLE_NAME = "admin";
    private Group group;
    private User user;
    private Role role;
    private Membership membership;

    @Before
    public void onSetupTest() throws Exception {
        super.onSetupTest();
        this.loadMemberships();
    }

    @Test
    public void testfindByGroup() throws Exception {
        DefaultMembershipQuery query = this.createMembershipQuery();
        query.setGroup(this.group);
        this.assertQueryResult((MembershipQuery)query);
    }

    @Test
    public void testfindByRole() throws Exception {
        DefaultMembershipQuery query = this.createMembershipQuery();
        query.setRole(this.role);
        this.assertQueryResult((MembershipQuery)query);
    }

    @Test
    public void testfindByUser() throws Exception {
        DefaultMembershipQuery query = this.createMembershipQuery();
        query.setUser(this.user);
        this.assertQueryResult((MembershipQuery)query);
    }

    private void loadMemberships() {
        IdentityStore identityStore = this.createIdentityStore();
        this.group = identityStore.getGroup(GROUP_NAME);
        this.role = identityStore.getRole(ROLE_NAME);
        this.user = identityStore.getUser(USER_NAME);
        this.membership = identityStore.getMembership(this.role, this.user, this.group);
        if (this.membership != null) {
            return;
        }
        this.group = identityStore.createGroup(GROUP_NAME, null);
        this.user = identityStore.createUser(USER_NAME);
        this.role = identityStore.createRole(ROLE_NAME);
        this.membership = identityStore.createMembership(this.role, this.user, this.group);
    }

    private void assertQueryResult(MembershipQuery query) {
        IdentityStore identityStore = this.createIdentityStore();
        List result = identityStore.executeQuery(query, null);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)this.role.getName(), (String)((Membership)result.get(0)).getRole().getName());
        Assert.assertEquals((String)this.group.getId(), (String)((Membership)result.get(0)).getGroup().getId());
        Assert.assertEquals((String)this.user.getId(), (String)((Membership)result.get(0)).getUser().getId());
    }

    private DefaultMembershipQuery createMembershipQuery() {
        return new DefaultMembershipQuery(this.createIdentityStore());
    }
}

