/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.jpa;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.Membership;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.test.idm.internal.jpa.AbstractJPAIdentityStoreTestCase;

public class JPAMembershipTestCase
extends AbstractJPAIdentityStoreTestCase {
    @Test
    public void testMembershipStore() throws Exception {
        IdentityStore identityStore = this.createIdentityStore();
        Role role = identityStore.createRole("admin");
        User user = identityStore.createUser("asaldhan");
        Group group = identityStore.createGroup("Administrators", null);
        Membership membership = identityStore.createMembership(role, user, group);
        Assert.assertNotNull((Object)membership);
        this.testRemoveGroup();
    }

    public void testRemoveGroup() throws Exception {
        IdentityStore identityStore = this.createIdentityStore();
        Role role = identityStore.getRole("admin");
        User user = identityStore.getUser("asaldhan");
        Group group = identityStore.getGroup("Administrators");
        Membership membership = identityStore.getMembership(role, user, group);
        Assert.assertNotNull((Object)membership);
        identityStore.removeMembership(role, user, group);
        membership = identityStore.getMembership(role, user, group);
        Assert.assertNull((Object)membership);
    }
}

