/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.jpa;

import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketlink.idm.internal.jpa.DefaultRoleQuery;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.RoleQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.test.idm.internal.jpa.AbstractJPAIdentityStoreTestCase;

public class JPARoleQueryTestCase
extends AbstractJPAIdentityStoreTestCase {
    private static final String USER_NAME = "theuser";
    private static final String GROUP_NAME = "Administrators";
    private static final String ROLE_NAME = "admin";
    private Group group;
    private User user;
    private Role role;

    @Before
    public void onSetupTest() throws Exception {
        super.onSetupTest();
        this.loadRoles();
    }

    @Test
    public void testfindByName() throws Exception {
        DefaultRoleQuery query = this.createRoleQuery();
        query.setName(this.role.getName());
        this.assertQueryResult((RoleQuery)query);
    }

    private DefaultRoleQuery createRoleQuery() {
        return new DefaultRoleQuery(this.createIdentityStore());
    }

    @Test
    public void testfindByGroup() throws Exception {
        DefaultRoleQuery query = this.createRoleQuery();
        query.setName(this.role.getName());
        query.setGroup(this.group);
        this.assertQueryResult((RoleQuery)query);
    }

    @Test
    public void testfindByAttributes() throws Exception {
        DefaultRoleQuery query = this.createRoleQuery();
        query.setName(this.role.getName());
        query.setAttributeFilter("attribute1", new String[]{"attributeValue1", "attributeValue12", "attributeValue123"});
        query.setAttributeFilter("attribute2", new String[]{"attributeValue2"});
        this.assertQueryResult((RoleQuery)query);
    }

    private void loadRoles() {
        IdentityStore identityStore = this.createIdentityStore();
        this.group = identityStore.getGroup(GROUP_NAME);
        this.role = identityStore.getRole("admin1");
        this.user = identityStore.getUser(USER_NAME);
        if (this.role != null) {
            return;
        }
        this.group = identityStore.createGroup(GROUP_NAME, null);
        this.user = identityStore.createUser(USER_NAME);
        for (int i = 0; i < 10; ++i) {
            int index = i + 1;
            Role currentRole = identityStore.createRole(ROLE_NAME + index);
            if (this.role == null) {
                this.role = currentRole;
            }
            identityStore.createMembership(currentRole, this.user, this.group);
            currentRole.setAttribute("attribute1", "attributeValue1");
            currentRole.setAttribute("attribute1", "attributeValue12");
            currentRole.setAttribute("attribute1", "attributeValue123");
            currentRole.setAttribute("attribute2", "attributeValue2");
        }
    }

    private void assertQueryResult(RoleQuery query) {
        IdentityStore identityStore = this.createIdentityStore();
        List result = identityStore.executeQuery(query, null);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)this.role.getName(), (String)((Role)result.get(0)).getName());
    }
}

