/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.jpa;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.test.idm.internal.jpa.AbstractJPAIdentityTypeTestCase;

public class JPARoleTestCase
extends AbstractJPAIdentityTypeTestCase {
    private static final String ROLE_NAME = "admin";

    @Test
    public void testRoleStore() throws Exception {
        IdentityStore identityStore = this.createIdentityStore();
        Role role = identityStore.createRole(ROLE_NAME);
        Assert.assertNotNull((Object)role);
        Assert.assertNotNull((Object)role.getKey());
        Assert.assertEquals((Object)ROLE_NAME, (Object)role.getName());
        this.testAddAttributes();
        this.testGetGroup();
        this.testRemoveRole();
    }

    public void testGetGroup() throws Exception {
        IdentityStore identityStore = this.createIdentityStore();
        Role group = identityStore.getRole(ROLE_NAME);
        Assert.assertNotNull((Object)group);
        Assert.assertNotNull((Object)group.getKey());
        Assert.assertEquals((Object)ROLE_NAME, (Object)group.getName());
        this.testRemoveAttributes();
    }

    public void testRemoveRole() throws Exception {
        IdentityStore identityStore = this.createIdentityStore();
        Role role = identityStore.getRole(ROLE_NAME);
        Assert.assertNotNull((Object)role);
        identityStore.removeRole(role);
        role = identityStore.getRole(ROLE_NAME);
        Assert.assertNull((Object)role);
    }

    protected IdentityType getIdentityTypeFromDatabase(IdentityStore identityStore) {
        return identityStore.getRole(ROLE_NAME);
    }
}

