/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.jpa;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketlink.idm.internal.DefaultUserQuery;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.UserQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.test.idm.internal.jpa.AbstractJPAIdentityStoreTestCase;

public class JPAUserQueryTestCase
extends AbstractJPAIdentityStoreTestCase {
    private static final String USER_EMAIL = "myemail@company.com";
    private static final String USER_LAST_NAME = "Saldhana";
    private static final String USER_FIRST_NAME = "Anil";
    private static final String USER_USERNAME = "asaldhana";
    private User user;

    @Before
    public void onSetupTest() throws Exception {
        super.onSetupTest();
        this.loadUsers();
    }

    @Test
    public void testfindByUserName() throws Exception {
        DefaultUserQuery query = new DefaultUserQuery();
        query.setName(this.user.getKey());
        this.assertQueryResult((UserQuery)query);
    }

    @Test
    public void testfindByFirstName() throws Exception {
        DefaultUserQuery query = new DefaultUserQuery();
        query.setFirstName(this.user.getFirstName());
        this.assertQueryResult((UserQuery)query);
    }

    @Test
    public void testfindByLastName() throws Exception {
        DefaultUserQuery query = new DefaultUserQuery();
        query.setLastName(this.user.getLastName());
        this.assertQueryResult((UserQuery)query);
    }

    @Test
    public void testfindByEmail() throws Exception {
        DefaultUserQuery query = new DefaultUserQuery();
        query.setEmail(this.user.getEmail());
        this.assertQueryResult((UserQuery)query);
    }

    @Test
    public void testfindByRole() throws Exception {
        DefaultUserQuery query = new DefaultUserQuery();
        query.setRole("admin1");
        this.assertQueryResult((UserQuery)query);
    }

    @Test
    public void testfindByGroup() throws Exception {
        DefaultUserQuery query = new DefaultUserQuery();
        query.setRelatedGroup("Administrators1");
        this.assertQueryResult((UserQuery)query);
    }

    @Test
    public void testfindByAttributes() throws Exception {
        DefaultUserQuery query = new DefaultUserQuery();
        query.setName(this.user.getKey());
        query.setAttributeFilter("attribute1", new String[]{"attributeValue1", "attributeValue12", "attributeValue123"});
        query.setAttributeFilter("attribute2", new String[]{"attributeValue2", "attributeValue21", "attributeValue23"});
        this.assertQueryResult((UserQuery)query);
    }

    private void assertQueryResult(UserQuery query) {
        IdentityStore identityStore = this.createIdentityStore();
        List result = identityStore.executeQuery(query, null);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)this.user.getId(), (Object)((User)result.get(0)).getId());
    }

    private void loadUsers() {
        IdentityStore identityStore = this.createIdentityStore();
        this.user = identityStore.getUser("asaldhana1");
        if (this.user != null) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            int index = i + 1;
            User currentUser = identityStore.createUser(USER_USERNAME + index);
            if (this.user == null) {
                this.user = currentUser;
            }
            currentUser.setEmail(USER_EMAIL + index);
            currentUser.setFirstName(USER_FIRST_NAME + index);
            currentUser.setLastName(USER_LAST_NAME + index);
            Role role = identityStore.createRole("admin" + index);
            Group group = identityStore.createGroup("Administrators" + index, null);
            identityStore.createMembership(role, this.user, group);
            currentUser.setAttribute("attribute1", "attributeValue1");
            currentUser.setAttribute("attribute1", "attributeValue12");
            currentUser.setAttribute("attribute1", "attributeValue123");
            currentUser.setAttribute("attribute2", "attributeValue2");
        }
    }
}

