/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.jpa;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.User;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.test.idm.internal.jpa.AbstractJPAIdentityTypeTestCase;

public class JPAUserTestCase
extends AbstractJPAIdentityTypeTestCase {
    private static final String USER_EMAIL = "myemail@company.com";
    private static final String USER_LAST_NAME = "Saldhana";
    private static final String USER_FIRST_NAME = "Anil";
    private static final String USER_FULL_NAME = "Anil Saldhana";
    private static final String USER_USERNAME = "asaldhana";

    @Test
    public void testUserStore() throws Exception {
        IdentityStore identityStore = this.createIdentityStore();
        User user = identityStore.createUser(USER_USERNAME);
        user.setEmail(USER_EMAIL);
        user.setFirstName(USER_FIRST_NAME);
        user.setLastName(USER_LAST_NAME);
        this.assertUserBasicInformation(user);
        this.testAddAttributes();
        this.testGetUser();
        this.testRemoveUser();
    }

    public void testGetUser() throws Exception {
        IdentityStore identityStore = this.createIdentityStore();
        User user = identityStore.getUser(USER_USERNAME);
        this.assertUserBasicInformation(user);
        this.testRemoveAttributes();
    }

    public void testRemoveUser() throws Exception {
        IdentityStore identityStore = this.createIdentityStore();
        User user = identityStore.getUser(USER_USERNAME);
        junit.framework.Assert.assertNotNull((Object)user);
        identityStore.removeUser(user);
        user = identityStore.getUser(USER_USERNAME);
        Assert.assertNull((Object)user);
    }

    private void assertUserBasicInformation(User user) {
        junit.framework.Assert.assertNotNull((Object)user);
        junit.framework.Assert.assertNotNull((Object)user.getId());
        junit.framework.Assert.assertEquals((String)USER_USERNAME, (String)user.getKey());
        junit.framework.Assert.assertEquals((String)USER_FULL_NAME, (String)user.getFullName());
        junit.framework.Assert.assertEquals((String)USER_FIRST_NAME, (String)user.getFirstName());
        junit.framework.Assert.assertEquals((String)USER_LAST_NAME, (String)user.getLastName());
        junit.framework.Assert.assertEquals((String)USER_EMAIL, (String)user.getEmail());
    }

    protected IdentityType getIdentityTypeFromDatabase(IdentityStore identityStore) {
        return identityStore.getUser(USER_USERNAME);
    }
}

