/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.internal.mgr;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.internal.DefaultIdentityManager;
import org.picketlink.idm.internal.password.SHASaltedPasswordEncoder;
import org.picketlink.idm.internal.util.Base64;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.password.PasswordEncoder;
import org.picketlink.idm.query.UserQuery;
import org.picketlink.test.idm.internal.jpa.AbstractJPAIdentityStoreTestCase;

public class DefaultJPAIdentityManagerTestCase
extends AbstractJPAIdentityStoreTestCase {
    @Test
    public void testDefaultIdentityManager() throws Exception {
        DefaultIdentityManager im = this.createIdentityManager();
        User user = im.createUser("pedroigor");
        user.setFirstName("Pedro");
        user.setLastName("Igor");
        Assert.assertNotNull((Object)user);
        user = im.getUser("pedroigor");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"Pedro Igor", (Object)user.getFullName());
        Assert.assertEquals((Object)"Pedro", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Igor", (Object)user.getLastName());
        user.setAttribute("QuestionTotal", "2");
        user.setAttribute("Question1", "What is favorite toy?");
        user.setAttribute("Question1Answer", "Gum");
        user.setAttribute("Question2", "What is favorite word?");
        user.setAttribute("Question2Answer", "Hi");
        InputStream bis = this.getClass().getClassLoader().getResourceAsStream("cert/servercert.txt");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(bis);
        bis.close();
        String encodedCert = Base64.encodeBytes((byte[])cert.getEncoded());
        user.setAttribute("x509", encodedCert);
        user = im.getUser("pedroigor");
        Map attributes = user.getAttributes();
        Assert.assertNotNull((Object)attributes);
        Assert.assertEquals((Object)"2", (Object)((String[])attributes.get("QuestionTotal"))[0]);
        Assert.assertEquals((Object)"What is favorite toy?", (Object)((String[])attributes.get("Question1"))[0]);
        Assert.assertEquals((Object)"Gum", (Object)((String[])attributes.get("Question1Answer"))[0]);
        Assert.assertEquals((Object)"What is favorite word?", (Object)((String[])attributes.get("Question2"))[0]);
        Assert.assertEquals((Object)"Hi", (Object)((String[])attributes.get("Question2Answer"))[0]);
        String loadedCert = ((String[])attributes.get("x509"))[0];
        byte[] certBytes = Base64.decode((String)loadedCert);
        cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes));
        Assert.assertNotNull((Object)cert);
        String userpass = "testpass";
        im.updatePassword(user, userpass);
        Assert.assertTrue((boolean)im.validatePassword(user, userpass));
        Assert.assertFalse((boolean)im.validatePassword(user, "BAD"));
        UserQuery query = im.createUserQuery().setAttributeFilter("QuestionTotal", new String[]{"2"});
        List returnedUsers = query.executeQuery();
        Assert.assertNotNull((Object)returnedUsers);
        Assert.assertEquals((long)1L, (long)returnedUsers.size());
        Role adminRole = im.createRole("admin");
        Group testGroup = im.createGroup("Test Group");
        im.grantRole(adminRole, (IdentityType)user, testGroup);
        Collection rolesByUser = im.getRoles((IdentityType)user, null);
        Assert.assertNotNull((Object)rolesByUser);
        Assert.assertEquals((long)1L, (long)rolesByUser.size());
        Collection rolesByUserAndGroup = im.getRoles((IdentityType)user, testGroup);
        Assert.assertNotNull((Object)rolesByUserAndGroup);
        Assert.assertEquals((long)1L, (long)rolesByUserAndGroup.size());
        im.removeUser(user);
        user = im.getUser("pedroigor");
        Assert.assertNull((Object)user);
    }

    @Test
    public void testPasswordEncoding() throws Exception {
        DefaultIdentityManager identityManager = this.createIdentityManager();
        identityManager.setPasswordEncoder((PasswordEncoder)new SHASaltedPasswordEncoder(256));
        User user = identityManager.createUser("pedroigor");
        String password = "easypassword";
        identityManager.updatePassword(user, password);
        Assert.assertTrue((boolean)identityManager.validatePassword(user, password));
    }

    private DefaultIdentityManager createIdentityManager() {
        DefaultIdentityManager im = new DefaultIdentityManager();
        im.setIdentityStore(this.createIdentityStore());
        return im;
    }
}

