/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.internal.DefaultUserQuery;
import org.picketlink.idm.internal.jpa.DefaultGroupQuery;
import org.picketlink.idm.internal.jpa.DefaultRoleQuery;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.password.PasswordEncoder;
import org.picketlink.idm.query.GroupQuery;
import org.picketlink.idm.query.MembershipQuery;
import org.picketlink.idm.query.RoleQuery;
import org.picketlink.idm.query.UserQuery;
import org.picketlink.idm.spi.IdentityStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIdentityManager
implements IdentityManager {
    private IdentityStore store = null;
    private PasswordEncoder passwordEncoder;

    public DefaultIdentityManager() {
    }

    public DefaultIdentityManager(IdentityStore theStore) {
        this.store = theStore;
    }

    public void setIdentityStore(IdentityStore theStore) {
        this.store = theStore;
    }

    public User createUser(String name) {
        this.ensureStoreExists();
        return this.store.createUser(name);
    }

    public User createUser(User user) {
        this.ensureStoreExists();
        return this.store.createUser(user);
    }

    public void removeUser(User user) {
        this.ensureStoreExists();
        this.store.removeUser(user);
    }

    public void removeUser(String name) {
        this.ensureStoreExists();
        this.store.removeUser(this.getUser(name));
    }

    public User getUser(String name) {
        this.ensureStoreExists();
        return this.store.getUser(name);
    }

    public Collection<User> getAllUsers() {
        throw new RuntimeException();
    }

    public Group createGroup(String id) {
        return this.store.createGroup(id, null);
    }

    public Group createGroup(String id, Group parent) {
        this.ensureStoreExists();
        return this.store.createGroup(id, parent);
    }

    public Group createGroup(String id, String parent) {
        this.ensureStoreExists();
        Group parentGroup = this.store.getGroup(parent);
        return this.store.createGroup(id, parentGroup);
    }

    public void removeGroup(Group group) {
        this.ensureStoreExists();
        this.store.removeGroup(group);
    }

    public void removeGroup(String groupId) {
        this.ensureStoreExists();
        this.store.removeGroup(this.getGroup(groupId));
    }

    public Group getGroup(String groupId) {
        this.ensureStoreExists();
        return this.store.getGroup(groupId);
    }

    public Group getGroup(String groupId, Group parent) {
        this.ensureStoreExists();
        return this.getGroup(groupId);
    }

    public Collection<Group> getAllGroups() {
        throw new RuntimeException();
    }

    public void addToGroup(IdentityType identityType, Group group) {
        throw new RuntimeException();
    }

    public void removeFromGroup(IdentityType identityType, Group group) {
        throw new RuntimeException();
    }

    public Collection<IdentityType> getGroupMembers(Group group) {
        throw new RuntimeException();
    }

    public Role createRole(String name) {
        this.ensureStoreExists();
        return this.store.createRole(name);
    }

    public void removeRole(Role role) {
        this.ensureStoreExists();
        this.store.removeRole(role);
    }

    public void removeRole(String name) {
        this.ensureStoreExists();
        this.store.removeRole(this.getRole(name));
    }

    public Role getRole(String name) {
        this.ensureStoreExists();
        return this.store.getRole(name);
    }

    public Collection<Role> getAllRoles() {
        throw new RuntimeException();
    }

    public Collection<Role> getRoles(IdentityType identityType, Group group) {
        RoleQuery query = this.createRoleQuery();
        if (query == null) {
            return Collections.EMPTY_LIST;
        }
        query.setGroup(group);
        query.setOwner(identityType);
        return query.executeQuery();
    }

    public boolean hasRole(Role role, IdentityType identityType, Group group) {
        throw new RuntimeException();
    }

    public void grantRole(Role role, IdentityType identityType, Group group) {
        this.store.createMembership(role, (User)identityType, group);
    }

    public void revokeRole(Role role, IdentityType identityType, Group group) {
        throw new RuntimeException();
    }

    public UserQuery createUserQuery() {
        return new DefaultUserQuery(this.store);
    }

    public GroupQuery createGroupQuery() {
        return new DefaultGroupQuery(this.store);
    }

    public MembershipQuery createMembershipQuery() {
        return this.store.createMembershipQuery();
    }

    public boolean validatePassword(User user, String password) {
        if (this.passwordEncoder != null) {
            password = this.passwordEncoder.encodePassword(user, password);
        }
        return this.store.validatePassword(user, password);
    }

    public void updatePassword(User user, String password) {
        if (this.passwordEncoder != null) {
            password = this.passwordEncoder.encodePassword(user, password);
        }
        this.store.updatePassword(user, password);
    }

    public void setPasswordEncoder(PasswordEncoder encoder) {
        this.passwordEncoder = encoder;
    }

    public boolean validateCertificate(User user, X509Certificate certificate) {
        return this.store.validateCertificate(user, certificate);
    }

    public boolean updateCertificate(User user, X509Certificate certificate) {
        return this.store.updateCertificate(user, certificate);
    }

    public void setEnabled(IdentityType identityType, boolean enabled) {
        throw new RuntimeException();
    }

    public void setExpirationDate(IdentityType identityType, Date expirationDate) {
        throw new RuntimeException();
    }

    private void ensureStoreExists() {
        if (this.store == null) {
            throw new RuntimeException("Identity Store has not been set");
        }
    }

    public RoleQuery createRoleQuery() {
        return new DefaultRoleQuery(this.store);
    }

    public IdentityType lookupIdentityByKey(String key) {
        return null;
    }
}

