/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.picketlink.idm.internal.jpa.DatabaseGroup;
import org.picketlink.idm.internal.jpa.DatabaseMembership;
import org.picketlink.idm.internal.jpa.DatabaseRole;
import org.picketlink.idm.internal.jpa.DatabaseUser;
import org.picketlink.idm.internal.jpa.DefaultMembershipQuery;
import org.picketlink.idm.internal.jpa.JPACallback;
import org.picketlink.idm.internal.jpa.JPATemplate;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Membership;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.GroupQuery;
import org.picketlink.idm.query.MembershipQuery;
import org.picketlink.idm.query.Range;
import org.picketlink.idm.query.RoleQuery;
import org.picketlink.idm.query.UserQuery;
import org.picketlink.idm.spi.IdentityStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAIdentityStore
implements IdentityStore {
    private static final String PASSWORD_ATTRIBUTE_NAME = "password";
    private JPATemplate jpaTemplate;

    public User createUser(String name) {
        DatabaseUser newUser = new DatabaseUser(name);
        this.persist(newUser);
        return newUser;
    }

    public User createUser(User newUser) {
        this.persist(newUser);
        return newUser;
    }

    public void removeUser(User user) {
        if (user.getId() == null) {
            throw new IllegalArgumentException("User identifier nor provided.");
        }
        this.remove(user);
    }

    public User getUser(String name) {
        return (User)this.findIdentityTypeByKey(name, "USER.LOAD_BY_KEY");
    }

    public Group createGroup(String name, Group parent) {
        DatabaseGroup newGroup = new DatabaseGroup(name);
        newGroup.setParentGroup((DatabaseGroup)parent);
        this.persist(newGroup);
        return newGroup;
    }

    public void removeGroup(Group group) {
        if (group.getId() == null) {
            throw new IllegalArgumentException("Group identifier not provided.");
        }
        this.remove(group);
    }

    public Group getGroup(String group) {
        return (Group)this.findIdentityTypeByKey(group, "GROUP.LOAD_BY_KEY");
    }

    public Role createRole(String name) {
        DatabaseRole newRole = new DatabaseRole(name);
        this.persist(newRole);
        return newRole;
    }

    public void removeRole(Role role) {
        if (role.getName() == null) {
            throw new IllegalArgumentException("Role name not provided.");
        }
        this.remove(role);
    }

    public Role getRole(String role) {
        return (Role)this.findIdentityTypeByKey(role, "ROLE.LOAD_BY_KEY");
    }

    public Membership createMembership(Role role, User user, Group group) {
        DatabaseMembership newMembership = new DatabaseMembership(role, user, group);
        DatabaseUser dbUser = (DatabaseUser)user;
        dbUser.getMemberships().add(newMembership);
        this.persist(newMembership);
        return newMembership;
    }

    public void removeMembership(Role role, User user, Group group) {
        Membership membership = this.getMembership(role, user, group);
        if (membership != null) {
            this.remove(membership);
        }
    }

    public Membership getMembership(final Role role, final User user, final Group group) {
        return (Membership)this.executeOperation(new JPACallback(){

            public Object execute(EntityManager entityManager) {
                Query query = entityManager.createNamedQuery("MEMBERSHIP.LOAD_BY_KEY");
                query.setParameter("role", (Object)role);
                query.setParameter("user", (Object)user);
                query.setParameter("group", (Object)group);
                Membership loadedMembership = null;
                try {
                    loadedMembership = (Membership)query.getSingleResult();
                }
                catch (NoResultException nre) {
                    // empty catch block
                }
                return loadedMembership;
            }
        });
    }

    public List<User> executeQuery(final UserQuery query, Range range) {
        return (List)this.jpaTemplate.execute(new JPACallback(){

            public Object execute(EntityManager entityManager) {
                CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
                CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DatabaseUser.class);
                Root user = criteriaQuery.from(DatabaseUser.class);
                user.alias("resultClass");
                criteriaQuery.distinct(true);
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (query.getName() != null) {
                    predicates.add(criteriaBuilder.equal((Expression)user.get("key"), (Object)query.getName()));
                }
                if (query.getEmail() != null) {
                    predicates.add(criteriaBuilder.equal((Expression)user.get("email"), (Object)query.getEmail()));
                }
                if (query.getFirstName() != null) {
                    predicates.add(criteriaBuilder.equal((Expression)user.get("firstName"), (Object)query.getFirstName()));
                }
                if (query.getLastName() != null) {
                    predicates.add(criteriaBuilder.equal((Expression)user.get("lastName"), (Object)query.getLastName()));
                }
                predicates.add(criteriaBuilder.equal((Expression)user.get("enabled"), (Object)query.getEnabled()));
                Join join = null;
                if (query.getRole() != null || query.getRelatedGroup() != null) {
                    join = user.join("memberships");
                }
                if (query.getRole() != null) {
                    Join joinRole = join.join("role");
                    predicates.add(criteriaBuilder.equal((Expression)joinRole.get("name"), (Object)query.getRole().getName()));
                }
                if (query.getRelatedGroup() != null) {
                    Join joinGroup = join.join("group");
                    predicates.add(criteriaBuilder.equal((Expression)joinGroup.get("name"), (Object)query.getRelatedGroup().getName()));
                }
                if (query.getAttributeFilters() != null) {
                    Set entrySet = query.getAttributeFilters().entrySet();
                    for (Map.Entry entry : entrySet) {
                        Join joinAttr = user.join("ownerAttributes");
                        Predicate conjunction = criteriaBuilder.conjunction();
                        conjunction.getExpressions().add(criteriaBuilder.equal((Expression)joinAttr.get("name"), entry.getKey()));
                        conjunction.getExpressions().add(joinAttr.get("value").in((Object[])entry.getValue()));
                        predicates.add(conjunction);
                    }
                }
                criteriaQuery.where(predicates.toArray(new Predicate[predicates.size()]));
                TypedQuery resultQuery = entityManager.createQuery(criteriaQuery);
                return resultQuery.getResultList();
            }
        });
    }

    public List<Group> executeQuery(final GroupQuery query, Range range) {
        return (List)this.jpaTemplate.execute(new JPACallback(){

            public Object execute(EntityManager entityManager) {
                CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
                CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DatabaseGroup.class);
                Root group = criteriaQuery.from(DatabaseGroup.class);
                group.alias("resultClass");
                criteriaQuery.distinct(true);
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (query.getName() != null) {
                    predicates.add(criteriaBuilder.equal((Expression)group.get("name"), (Object)query.getName()));
                }
                if (query.getId() != null) {
                    predicates.add(criteriaBuilder.equal((Expression)group.get("id"), (Object)query.getId()));
                }
                if (query.getParentGroup() != null) {
                    Join joinParentGroup = group.join("parentGroup");
                    predicates.add(criteriaBuilder.equal((Expression)joinParentGroup.get("id"), (Object)query.getParentGroup().getId()));
                }
                Join join = null;
                if (query.getRelatedUser() != null || query.getRole() != null) {
                    join = group.join("memberships");
                }
                if (query.getRole() != null) {
                    Join joinRole = join.join("role");
                    predicates.add(criteriaBuilder.equal((Expression)joinRole.get("name"), (Object)query.getRole().getName()));
                }
                if (query.getRelatedUser() != null) {
                    Join joinGroup = join.join("user");
                    predicates.add(criteriaBuilder.equal((Expression)joinGroup.get("id"), (Object)query.getRelatedUser().getId()));
                }
                if (query.getAttributeFilters() != null) {
                    Set entrySet = query.getAttributeFilters().entrySet();
                    for (Map.Entry entry : entrySet) {
                        Join joinAttr = group.join("ownerAttributes");
                        Predicate conjunction = criteriaBuilder.conjunction();
                        conjunction.getExpressions().add(criteriaBuilder.equal((Expression)joinAttr.get("name"), entry.getKey()));
                        conjunction.getExpressions().add(joinAttr.get("value").in((Object[])entry.getValue()));
                        predicates.add(conjunction);
                    }
                }
                criteriaQuery.where(predicates.toArray(new Predicate[predicates.size()]));
                TypedQuery resultQuery = entityManager.createQuery(criteriaQuery);
                return resultQuery.getResultList();
            }
        });
    }

    public List<Role> executeQuery(final RoleQuery query, Range range) {
        return (List)this.jpaTemplate.execute(new JPACallback(){

            public Object execute(EntityManager entityManager) {
                CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
                CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DatabaseRole.class);
                Root role = criteriaQuery.from(DatabaseRole.class);
                role.alias("resultClass");
                criteriaQuery.distinct(true);
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (query.getName() != null) {
                    predicates.add(criteriaBuilder.equal((Expression)role.get("name"), (Object)query.getName()));
                }
                Join join = null;
                if (query.getGroup() != null || query.getOwner() != null) {
                    join = role.join("memberships");
                }
                if (query.getGroup() != null) {
                    Join joinGroup = join.join("group");
                    predicates.add(criteriaBuilder.equal((Expression)joinGroup.get("id"), (Object)query.getGroup().getId()));
                }
                if (query.getOwner() != null) {
                    Join joinUser = join.join("user");
                    predicates.add(criteriaBuilder.equal((Expression)joinUser.get("key"), (Object)query.getOwner().getKey()));
                }
                if (query.getAttributeFilters() != null) {
                    Set entrySet = query.getAttributeFilters().entrySet();
                    for (Map.Entry entry : entrySet) {
                        Join joinAttr = role.join("ownerAttributes");
                        Predicate conjunction = criteriaBuilder.conjunction();
                        conjunction.getExpressions().add(criteriaBuilder.equal((Expression)joinAttr.get("name"), entry.getKey()));
                        conjunction.getExpressions().add(joinAttr.get("value").in((Object[])entry.getValue()));
                        predicates.add(conjunction);
                    }
                }
                criteriaQuery.where(predicates.toArray(new Predicate[predicates.size()]));
                TypedQuery resultQuery = entityManager.createQuery(criteriaQuery);
                return resultQuery.getResultList();
            }
        });
    }

    public List<Membership> executeQuery(final MembershipQuery query, Range range) {
        return (List)this.jpaTemplate.execute(new JPACallback(){

            public Object execute(EntityManager entityManager) {
                CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
                CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DatabaseMembership.class);
                Root membership = criteriaQuery.from(DatabaseMembership.class);
                membership.alias("resultClass");
                criteriaQuery.distinct(true);
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (query.getGroup() != null) {
                    Join joinGroup = membership.join("group");
                    predicates.add(criteriaBuilder.equal((Expression)joinGroup.get("id"), (Object)query.getGroup().getId()));
                }
                if (query.getRole() != null) {
                    Join joinRole = membership.join("role");
                    predicates.add(criteriaBuilder.equal((Expression)joinRole.get("name"), (Object)query.getRole().getName()));
                }
                if (query.getUser() != null) {
                    Join joinUser = membership.join("user");
                    predicates.add(criteriaBuilder.equal((Expression)joinUser.get("id"), (Object)query.getUser().getId()));
                }
                criteriaQuery.where(predicates.toArray(new Predicate[predicates.size()]));
                TypedQuery resultQuery = entityManager.createQuery(criteriaQuery);
                return resultQuery.getResultList();
            }
        });
    }

    public void setAttribute(User user, String name, String[] values) {
        user.setAttribute(name, values);
    }

    public void removeAttribute(User user, String name) {
        user.removeAttribute(name);
    }

    public String[] getAttributeValues(User user, String name) {
        return user.getAttributeValues(name);
    }

    public Map<String, String[]> getAttributes(User user) {
        return user.getAttributes();
    }

    public void setAttribute(Group group, String name, String[] values) {
        group.setAttribute(name, values);
    }

    public void removeAttribute(Group group, String name) {
        group.removeAttribute(name);
    }

    public String[] getAttributeValues(Group group, String name) {
        return group.getAttributeValues(name);
    }

    public Map<String, String[]> getAttributes(Group group) {
        return group.getAttributes();
    }

    public void setAttribute(Role role, String name, String[] values) {
        role.setAttribute(name, values);
    }

    public void removeAttribute(Role role, String name) {
        role.removeAttribute(name);
    }

    public String[] getAttributeValues(Role role, String name) {
        return role.getAttributeValues(name);
    }

    public Map<String, String[]> getAttributes(Role role) {
        return role.getAttributes();
    }

    public MembershipQuery createMembershipQuery() {
        return new DefaultMembershipQuery(this);
    }

    public void setJpaTemplate(JPATemplate jpaTemplate) {
        this.jpaTemplate = jpaTemplate;
    }

    private Object executeOperation(JPACallback callback) {
        return this.jpaTemplate.execute(callback);
    }

    private void persist(final Object entity) {
        JPACallback callback = new JPACallback(){

            public Object execute(EntityManager entityManager) {
                entityManager.persist(entity);
                return null;
            }
        };
        this.executeOperation(callback);
    }

    private void remove(final Object entity) {
        this.executeOperation(new JPACallback(){

            public Object execute(EntityManager entityManager) {
                entityManager.remove(entity);
                return null;
            }
        });
    }

    private IdentityType findIdentityTypeByKey(final String name, final String namedQueryName) {
        return (IdentityType)this.executeOperation(new JPACallback(){

            public Object execute(EntityManager entityManager) {
                Query query = entityManager.createNamedQuery(namedQueryName);
                query.setParameter("key", (Object)name);
                Object loadedUser = null;
                try {
                    loadedUser = query.getSingleResult();
                }
                catch (NoResultException nre) {
                }
                catch (NonUniqueResultException nure) {
                    // empty catch block
                }
                return loadedUser;
            }
        });
    }

    public boolean validatePassword(User user, String password) {
        String userPasswd = user.getAttribute(PASSWORD_ATTRIBUTE_NAME);
        return userPasswd != null && password != null && password.equals(userPasswd);
    }

    public void updatePassword(User user, String password) {
        user.setAttribute(PASSWORD_ATTRIBUTE_NAME, password);
    }

    public boolean validateCertificate(User user, X509Certificate certificate) {
        return false;
    }

    public boolean updateCertificate(User user, X509Certificate certificate) {
        return false;
    }
}

