/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.picketlink.idm.internal.config.LDAPConfiguration;
import org.picketlink.idm.internal.ldap.LDAPChangeNotificationHandler;
import org.picketlink.idm.internal.ldap.LDAPGroup;
import org.picketlink.idm.internal.ldap.LDAPObjectChangedNotification;
import org.picketlink.idm.internal.ldap.LDAPRole;
import org.picketlink.idm.internal.ldap.LDAPUser;
import org.picketlink.idm.internal.ldap.LDAPUserCustomAttributes;
import org.picketlink.idm.internal.ldap.ManagedAttributeLookup;
import org.picketlink.idm.internal.util.Base64;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.model.DefaultMembership;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.Membership;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.GroupQuery;
import org.picketlink.idm.query.MembershipQuery;
import org.picketlink.idm.query.Range;
import org.picketlink.idm.query.RoleQuery;
import org.picketlink.idm.query.UserQuery;
import org.picketlink.idm.spi.IdentityStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPIdentityStore
implements IdentityStore,
LDAPChangeNotificationHandler,
ManagedAttributeLookup {
    public final String COMMA = ",";
    public final String EQUAL = "=";
    protected DirContext ctx = null;
    protected String userDNSuffix;
    protected String roleDNSuffix;
    protected String groupDNSuffix;
    protected boolean isActiveDirectory = false;
    protected List<String> managedAttributes = new ArrayList<String>();
    protected LDAPConfiguration ldapConfiguration = null;

    public void setConfiguration(LDAPConfiguration configuration) {
        this.ldapConfiguration = configuration;
        this.userDNSuffix = configuration.getUserDNSuffix();
        this.roleDNSuffix = configuration.getRoleDNSuffix();
        this.groupDNSuffix = configuration.getGroupDNSuffix();
        this.isActiveDirectory = configuration.isActiveDirectory();
        this.constructContext();
    }

    public User createUser(String name) {
        LDAPUser user = new LDAPUser(name, this);
        user.setLookup(this);
        user.setLDAPChangeNotificationHandler(this);
        user.setUserDNSuffix(this.userDNSuffix);
        try {
            this.ctx.bind(user.getDN(), (Object)user);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return user;
    }

    public User createUser(User user) {
        if (user.getId() == null) {
            throw new RuntimeException("No identifier was provided. You should provide one before storing the user.");
        }
        LDAPUser ldapUser = (LDAPUser)user;
        ldapUser.setLookup(this);
        ldapUser.setLDAPChangeNotificationHandler(this);
        ldapUser.setUserDNSuffix(this.userDNSuffix);
        try {
            this.ctx.bind(ldapUser.getDN(), (Object)ldapUser);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return ldapUser;
    }

    public void removeUser(User user) {
        try {
            LDAPUser ldapUser = (LDAPUser)this.getUser(user.getId());
            String customDN = ldapUser.getCustomAttributes().getDN() + "," + ldapUser.getDN();
            try {
                LDAPUserCustomAttributes lca = (LDAPUserCustomAttributes)this.ctx.lookup(customDN);
                this.ctx.destroySubcontext(customDN);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            this.ctx.destroySubcontext(ldapUser.getDN());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public User getUser(String name) {
        LDAPUser user;
        block5: {
            user = null;
            try {
                BasicAttributes matchAttrs = new BasicAttributes(true);
                matchAttrs.put(new BasicAttribute("uid", name));
                NamingEnumeration<SearchResult> answer = this.ctx.search(this.userDNSuffix, (Attributes)matchAttrs);
                if (!answer.hasMore()) break block5;
                SearchResult sr = answer.next();
                Attributes attributes = sr.getAttributes();
                user = new LDAPUser();
                user.setLookup(this);
                user.setUserDNSuffix(this.userDNSuffix);
                user.addAllLDAPAttributes(attributes);
                user.setLDAPChangeNotificationHandler(this);
                String customDN = user.getCustomAttributes().getDN() + "," + user.getDN();
                try {
                    LDAPUserCustomAttributes lca = (LDAPUserCustomAttributes)this.ctx.lookup(customDN);
                    if (lca != null) {
                        user.setCustomAttributes(lca);
                    }
                }
                catch (Exception ignore) {}
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        return user;
    }

    public Group createGroup(String name, Group parent) {
        this.ensureGroupDNExists();
        LDAPGroup ldapGroup = new LDAPGroup();
        ldapGroup.setLDAPChangeNotificationHandler(this);
        ldapGroup.setName(name);
        ldapGroup.setGroupDNSuffix(this.groupDNSuffix);
        try {
            this.ctx.bind(ldapGroup.getDN(), (Object)ldapGroup);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        if (parent != null) {
            ldapGroup.setParentGroup(parent);
            LDAPGroup parentGroup = (LDAPGroup)this.getGroup(parent.getName());
            ldapGroup.setParentGroup(parentGroup);
            parentGroup.addChildGroup(ldapGroup);
            try {
                this.ctx.rebind(parentGroup.getDN(), (Object)parentGroup);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        return ldapGroup;
    }

    public void removeGroup(Group group) {
        try {
            LDAPGroup ldapGroup = (LDAPGroup)this.getGroup(group.getId());
            this.ctx.destroySubcontext(ldapGroup.getDN());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public Group getGroup(String name) {
        LDAPGroup ldapGroup = null;
        try {
            BasicAttributes matchAttrs = new BasicAttributes(true);
            matchAttrs.put(new BasicAttribute("cn", name));
            NamingEnumeration<SearchResult> answer = this.ctx.search(this.groupDNSuffix, (Attributes)matchAttrs);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attributes = sr.getAttributes();
                ldapGroup = new LDAPGroup();
                ldapGroup.setGroupDNSuffix(this.groupDNSuffix);
                ldapGroup.addAllLDAPAttributes(attributes);
                Group parentGroup = this.getParentGroup(ldapGroup);
                if (parentGroup != null) {
                    ldapGroup.setParentGroup(parentGroup);
                }
                ldapGroup.setLDAPChangeNotificationHandler(this);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return ldapGroup;
    }

    public Role createRole(String name) {
        LDAPRole role = new LDAPRole();
        role.setLDAPChangeNotificationHandler(this);
        role.setName(name);
        role.setRoleDNSuffix(this.roleDNSuffix);
        try {
            this.ctx.bind(role.getDN(), (Object)role);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return role;
    }

    public void removeRole(Role role) {
        try {
            LDAPRole ldapRole = (LDAPRole)this.getRole(role.getName());
            this.ctx.destroySubcontext(ldapRole.getDN());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public Role getRole(String role) {
        try {
            BasicAttributes matchAttrs = new BasicAttributes(true);
            matchAttrs.put(new BasicAttribute("cn", role));
            NamingEnumeration<SearchResult> searchResult = this.ctx.search(this.roleDNSuffix, (Attributes)matchAttrs);
            if (searchResult.hasMore()) {
                SearchResult result = searchResult.next();
                return new LDAPRole(result.getAttributes(), this.roleDNSuffix);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public Membership createMembership(Role role, User user, Group group) {
        LDAPRole ldapRole = (LDAPRole)this.getRole(role.getName());
        LDAPUser ldapUser = (LDAPUser)this.getUser(user.getId());
        LDAPGroup ldapGroup = (LDAPGroup)this.getGroup(group.getName());
        ldapRole.addUser(ldapUser);
        ldapGroup.addRole(ldapRole);
        ldapGroup.addUser(ldapUser);
        try {
            this.ctx.modifyAttributes(ldapRole.getDN(), 2, ldapRole.getAttributes("member"));
        }
        catch (NamingException e) {
            throw new RuntimeException("Error while modifying members of role [" + ldapRole.getName() + "].", e);
        }
        try {
            this.ctx.modifyAttributes(ldapGroup.getDN(), 2, ldapGroup.getAttributes("member"));
        }
        catch (NamingException e) {
            throw new RuntimeException("Error while modifying members of group [" + ldapGroup.getName() + "].", e);
        }
        return new DefaultMembership((User)ldapUser, (Role)ldapRole, (Group)ldapGroup);
    }

    public void removeMembership(Role role, User user, Group group) {
        LDAPRole ldapRole = (LDAPRole)this.getRole(role.getName());
        LDAPUser ldapUser = (LDAPUser)this.getUser(user.getFullName());
        LDAPGroup ldapGroup = (LDAPGroup)this.getGroup(group.getName());
        ldapRole.removeUser(ldapUser);
        ldapGroup.removeRole(ldapRole);
    }

    public Membership getMembership(Role role, User user, Group group) {
        return null;
    }

    public List<User> executeQuery(UserQuery query, Range range) {
        ArrayList<User> users = new ArrayList<User>();
        Map filters = query.getAttributeFilters();
        if (filters != null) {
            Attributes matchAttrs = this.getManagedAttributes(filters);
            if (matchAttrs.size() == 0) {
                List<User> allUsers = this.getAllUsers();
                for (User theUser : allUsers) {
                    if (!this.userHasRequiredAttributes((LDAPUser)theUser, filters)) continue;
                    users.add(theUser);
                }
                return users;
            }
            try {
                NamingEnumeration<SearchResult> answer = this.ctx.search(this.userDNSuffix, matchAttrs);
                while (answer.hasMore()) {
                    SearchResult sr = answer.next();
                    Attributes attributes = sr.getAttributes();
                    LDAPUser user = new LDAPUser();
                    user.setLookup(this);
                    user.setUserDNSuffix(this.userDNSuffix);
                    user.addAllLDAPAttributes(attributes);
                    user.setLDAPChangeNotificationHandler(this);
                    String customDN = user.getCustomAttributes().getDN() + "," + user.getDN();
                    try {
                        LDAPUserCustomAttributes lca = (LDAPUserCustomAttributes)this.ctx.lookup(customDN);
                        if (lca != null) {
                            user.setCustomAttributes(lca);
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    if (!this.userHasRequiredAttributes(user, filters)) continue;
                    users.add(user);
                }
            }
            catch (NamingException e) {
                throw new RuntimeException("Error executing user query.", e);
            }
        }
        return users;
    }

    public List<Group> executeQuery(GroupQuery query, Range range) {
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            BasicAttributes groupAttributeFilter = new BasicAttributes(true);
            if (query.getId() != null) {
                groupAttributeFilter.put("cn", query.getId());
            }
            if (query.getName() != null) {
                groupAttributeFilter.put("cn", query.getName());
            }
            if (query.getRelatedUser() != null) {
                LDAPUser ldapUser = (LDAPUser)this.getUser(query.getRelatedUser().getId());
                groupAttributeFilter.put("member", ldapUser.getDN());
            }
            if (query.getRole() != null) {
                LDAPRole ldapRole = (LDAPRole)this.getRole(query.getRole().getName());
                groupAttributeFilter.put("member", ldapRole.getDN());
            }
            NamingEnumeration<SearchResult> groupSearchResult = this.ctx.search(this.groupDNSuffix, (Attributes)groupAttributeFilter);
            while (groupSearchResult.hasMore()) {
                Group parentGroup;
                boolean isGroupSelected = true;
                SearchResult groupResult = groupSearchResult.next();
                Attributes groupAttributes = groupResult.getAttributes();
                LDAPGroup childGroup = new LDAPGroup(groupAttributes, this.groupDNSuffix);
                if (!(query.getParentGroup() == null || (parentGroup = this.getParentGroup(childGroup)) != null && query.getParentGroup().getId().equals(parentGroup.getId()))) {
                    isGroupSelected = false;
                }
                if (!isGroupSelected) continue;
                groups.add(childGroup);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Error executing group query.", e);
        }
        return groups;
    }

    public List<Role> executeQuery(RoleQuery query, Range range) {
        ArrayList<Role> roles = new ArrayList<Role>();
        try {
            BasicAttributes roleAttributeFilter = new BasicAttributes(true);
            if (query.getName() != null) {
                roleAttributeFilter.put("cn", query.getName());
            }
            NamingEnumeration<SearchResult> roleSearchResult = this.ctx.search(this.roleDNSuffix, (Attributes)roleAttributeFilter);
            while (roleSearchResult.hasMore()) {
                LDAPGroup ldapGroup;
                Attributes groupAttributes;
                Attribute memberAttribute;
                boolean isRoleSelected = true;
                SearchResult roleResult = roleSearchResult.next();
                Attributes roleAttributes = roleResult.getAttributes();
                LDAPRole ldapRole = new LDAPRole(roleAttributes, this.roleDNSuffix);
                if (query.getOwner() != null) {
                    Attribute memberAttribute2 = roleAttributes.get("member");
                    LDAPUser ldapUser = (LDAPUser)query.getOwner();
                    if (memberAttribute2 == null || !memberAttribute2.contains(ldapUser.getDN())) {
                        isRoleSelected = false;
                    }
                }
                if (!(query.getGroup() == null || (memberAttribute = (groupAttributes = (ldapGroup = (LDAPGroup)this.getGroup(query.getGroup().getName())).getLDAPAttributes()).get("member")) != null && memberAttribute.contains(ldapRole.getDN()))) {
                    isRoleSelected = false;
                }
                if (!isRoleSelected) continue;
                roles.add(ldapRole);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Error executing role query.", e);
        }
        return roles;
    }

    public List<Membership> executeQuery(MembershipQuery query, Range range) {
        return null;
    }

    public void setAttribute(User user, String name, String[] values) {
        LDAPUser ldapUser = null;
        ldapUser = user instanceof LDAPUser ? (LDAPUser)user : (LDAPUser)this.getUser(user.getFullName());
        if (this.isManaged(name)) {
            ldapUser.setAttribute(name, values);
        } else {
            ldapUser.setCustomAttribute(name, values);
        }
    }

    public void removeAttribute(User user, String name) {
        if (!(user instanceof LDAPUser)) {
            throw new RuntimeException("Wrong type:" + user);
        }
        LDAPUser ldapUser = (LDAPUser)user;
        ldapUser.removeAttribute(name);
    }

    public String[] getAttributeValues(User user, String name) {
        if (!(user instanceof LDAPUser)) {
            throw new RuntimeException("Wrong type:" + user);
        }
        LDAPUser ldapUser = (LDAPUser)user;
        return ldapUser.getAttributeValues(name);
    }

    public Map<String, String[]> getAttributes(User user) {
        if (!(user instanceof LDAPUser)) {
            throw new RuntimeException("Wrong type:" + user);
        }
        LDAPUser ldapUser = (LDAPUser)user;
        return ldapUser.getAttributes();
    }

    public void setAttribute(Group group, String name, String[] values) {
        LDAPGroup ldapGroup = null;
        ldapGroup = group instanceof LDAPGroup ? (LDAPGroup)group : (LDAPGroup)this.getGroup(group.getName());
        ldapGroup.setAttribute(name, values);
    }

    public void removeAttribute(Group group, String name) {
        LDAPGroup ldapGroup = null;
        ldapGroup = group instanceof LDAPGroup ? (LDAPGroup)group : (LDAPGroup)this.getGroup(group.getName());
        ldapGroup.removeAttribute(name);
    }

    public String[] getAttributeValues(Group group, String name) {
        LDAPGroup ldapGroup = null;
        ldapGroup = group instanceof LDAPGroup ? (LDAPGroup)group : (LDAPGroup)this.getGroup(group.getName());
        return ldapGroup.getAttributeValues(name);
    }

    public Map<String, String[]> getAttributes(Group group) {
        LDAPGroup ldapGroup = null;
        ldapGroup = group instanceof LDAPGroup ? (LDAPGroup)group : (LDAPGroup)this.getGroup(group.getName());
        return ldapGroup.getAttributes();
    }

    public void setAttribute(Role role, String name, String[] values) {
        LDAPRole ldapRole = null;
        ldapRole = role instanceof LDAPGroup ? (LDAPRole)role : (LDAPRole)this.getRole(role.getName());
        ldapRole.setAttribute(name, values);
    }

    public void removeAttribute(Role role, String name) {
        LDAPRole ldapRole = null;
        ldapRole = role instanceof LDAPGroup ? (LDAPRole)role : (LDAPRole)this.getRole(role.getName());
        ldapRole.removeAttribute(name);
    }

    public String[] getAttributeValues(Role role, String name) {
        LDAPRole ldapRole = null;
        ldapRole = role instanceof LDAPGroup ? (LDAPRole)role : (LDAPRole)this.getRole(role.getName());
        return ldapRole.getAttributeValues(name);
    }

    public Map<String, String[]> getAttributes(Role role) {
        LDAPRole ldapRole = null;
        ldapRole = ldapRole instanceof LDAPRole ? (LDAPRole)role : (LDAPRole)this.getRole(role.getName());
        return ldapRole.getAttributes();
    }

    protected void ensureGroupDNExists() {
        try {
            Object obj = this.ctx.lookup(this.groupDNSuffix);
            if (obj == null) {
                this.createGroupDN();
            }
            return;
        }
        catch (NamingException e) {
            if (e instanceof NameNotFoundException) {
                this.createGroupDN();
                return;
            }
            throw new RuntimeException(e);
        }
    }

    protected void createGroupDN() {
        try {
            BasicAttributes attributes = new BasicAttributes(true);
            BasicAttribute oc = new BasicAttribute("objectclass");
            oc.add("top");
            oc.add("organizationalUnit");
            attributes.put(oc);
            this.ctx.createSubcontext(this.groupDNSuffix, (Attributes)attributes);
        }
        catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
    }

    protected Group getParentGroup(LDAPGroup childGroup) {
        BasicAttributes matchAttrs = new BasicAttributes(true);
        matchAttrs.put(new BasicAttribute("member", "cn=" + childGroup.getName() + "," + this.groupDNSuffix));
        try {
            NamingEnumeration<SearchResult> answer = this.ctx.search(this.groupDNSuffix, (Attributes)matchAttrs, new String[]{"cn"});
            if (answer.hasMoreElements()) {
                SearchResult sr = (SearchResult)answer.nextElement();
                Attributes attributes = sr.getAttributes();
                String cn = (String)attributes.get("cn").get();
                return this.getGroup(cn);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Error looking parent group for [" + childGroup.getDN() + "]", e);
        }
        return null;
    }

    @Override
    public void handle(LDAPObjectChangedNotification notification) {
        DirContext object = notification.getLDAPObject();
        if (object instanceof LDAPUser) {
            LDAPUser user = (LDAPUser)object;
            LDAPUserCustomAttributes ldapUserCustomAttributes = user.getCustomAttributes();
            try {
                ModificationItem[] mods;
                Attribute attrib;
                String userDN = user.getDN();
                if (notification.getNtype() == LDAPObjectChangedNotification.NType.ADD_ATTRIBUTE) {
                    attrib = notification.getAttribute();
                    if (attrib == null) {
                        throw new RuntimeException("attrib is null");
                    }
                    mods = new ModificationItem[]{new ModificationItem(1, attrib)};
                    this.ctx.modifyAttributes(user.getDN(), mods);
                }
                if (notification.getNtype() == LDAPObjectChangedNotification.NType.REPLACE_ATTRIBUTE) {
                    attrib = notification.getAttribute();
                    if (attrib == null) {
                        throw new RuntimeException("attrib is null");
                    }
                    mods = new ModificationItem[]{new ModificationItem(2, attrib)};
                    this.ctx.modifyAttributes(user.getDN(), mods);
                }
                if (notification.getNtype() == LDAPObjectChangedNotification.NType.REMOVE_ATTRIBUTE) {
                    attrib = notification.getAttribute();
                    if (attrib == null) {
                        throw new RuntimeException("attrib is null");
                    }
                    mods = new ModificationItem[]{new ModificationItem(3, attrib)};
                    this.ctx.modifyAttributes(user.getDN(), mods);
                }
                this.ctx.rebind(ldapUserCustomAttributes.getDN() + "," + userDN, (Object)ldapUserCustomAttributes);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean isManaged(String attributeName) {
        if (this.managedAttributes.contains(attributeName)) {
            return true;
        }
        if (this.checkDirectoryServerForAttributePresence(attributeName)) {
            this.managedAttributes.add(attributeName);
            return true;
        }
        return false;
    }

    private boolean checkDirectoryServerForAttributePresence(String attributeName) {
        try {
            DirContext schema = this.ctx.getSchema("");
            DirContext cnSchema = (DirContext)schema.lookup("AttributeDefinition/" + attributeName);
            if (cnSchema != null) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private Attributes getManagedAttributes(Map<String, String[]> filters) {
        BasicAttributes attr = new BasicAttributes(true);
        Set<String> keys = filters.keySet();
        for (String key : keys) {
            if (!this.isManaged(key)) continue;
            attr.put(key, filters.get(key));
        }
        return attr;
    }

    private boolean userHasRequiredAttributes(LDAPUser user, Map<String, String[]> filters) {
        Set<String> keys = filters.keySet();
        for (String key : keys) {
            String[] attValues;
            String[] values = filters.get(key);
            if (IDMUtil.arraysEqual(values, attValues = user.getAttributeValues(key))) continue;
            return false;
        }
        return true;
    }

    private List<User> getAllUsers() {
        ArrayList<User> users = new ArrayList<User>();
        try {
            BasicAttributes attr = new BasicAttributes(true);
            NamingEnumeration<SearchResult> answer = this.ctx.search(this.userDNSuffix, (Attributes)attr);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attributes = sr.getAttributes();
                LDAPUser user = new LDAPUser();
                user.setLookup(this);
                user.setUserDNSuffix(this.userDNSuffix);
                user.addAllLDAPAttributes(attributes);
                user.setLDAPChangeNotificationHandler(this);
                String customDN = user.getCustomAttributes().getDN() + "," + user.getDN();
                try {
                    LDAPUserCustomAttributes lca = (LDAPUserCustomAttributes)this.ctx.lookup(customDN);
                    if (lca != null) {
                        user.setCustomAttributes(lca);
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                users.add(user);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return users;
    }

    public MembershipQuery createMembershipQuery() {
        throw new RuntimeException();
    }

    public boolean validatePassword(User user, String password) {
        boolean valid = false;
        try {
            LDAPUser ldapUser = (LDAPUser)user;
            String filter = "(&(objectClass=inetOrgPerson)(uid={0}))";
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(new String[0]);
            ctls.setReturningObjFlag(true);
            NamingEnumeration<SearchResult> enm = this.ctx.search(this.userDNSuffix, filter, (Object[])new String[]{ldapUser.getId()}, ctls);
            String dn = null;
            if (enm.hasMore()) {
                SearchResult result = enm.next();
                dn = result.getNameInNamespace();
                System.out.println("dn: " + dn);
            }
            if (dn == null || enm.hasMore()) {
                throw new NamingException("Authentication failed");
            }
            this.ctx.addToEnvironment("java.naming.security.principal", dn);
            this.ctx.addToEnvironment("java.naming.security.credentials", password);
            this.ctx.lookup(dn);
            valid = true;
        }
        catch (NamingException e) {
            // empty catch block
        }
        this.constructContext();
        return valid;
    }

    public void updatePassword(User user, String password) {
        if (this.isActiveDirectory) {
            this.updateADPassword((LDAPUser)user, password);
        } else {
            LDAPUser ldapuser = (LDAPUser)user;
            ModificationItem[] mods = new ModificationItem[1];
            BasicAttribute mod0 = new BasicAttribute("userpassword", password);
            mods[0] = new ModificationItem(2, mod0);
            try {
                this.ctx.modifyAttributes(ldapuser.getDN(), mods);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean validateCertificate(User user, X509Certificate certificate) {
        return false;
    }

    public boolean updateCertificate(User user, X509Certificate certificate) {
        try {
            LDAPUser ldapUser = (LDAPUser)user;
            ldapUser.setAttribute("usercertificate", new String(Base64.encodeBytes(certificate.getEncoded())));
            ModificationItem[] mods = new ModificationItem[1];
            byte[] certbytes = certificate.getEncoded();
            mods[0] = new ModificationItem(2, new BasicAttribute("usercertificate", certbytes));
            this.ctx.modifyAttributes(ldapUser.getDN(), mods);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void constructContext() {
        String url;
        if (this.ctx != null) {
            try {
                this.ctx.close();
            }
            catch (NamingException ignore) {
                // empty catch block
            }
        }
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", this.ldapConfiguration.getFactoryName());
        env.setProperty("java.naming.security.authentication", this.ldapConfiguration.getAuthType());
        String protocol = this.ldapConfiguration.getProtocol();
        if (protocol != null) {
            env.setProperty("java.naming.security.protocol", protocol);
        }
        String bindDN = this.ldapConfiguration.getBindDN();
        char[] bindCredential = null;
        if (this.ldapConfiguration.getBindCredential() != null) {
            bindCredential = this.ldapConfiguration.getBindCredential().toCharArray();
        }
        if (bindDN != null) {
            env.setProperty("java.naming.security.principal", bindDN);
            env.put("java.naming.security.credentials", bindCredential);
        }
        if ((url = this.ldapConfiguration.getLdapURL()) == null) {
            throw new RuntimeException("url");
        }
        env.setProperty("java.naming.provider.url", url);
        Properties additionalProperties = this.ldapConfiguration.getAdditionalProperties();
        Set<Object> keys = additionalProperties.keySet();
        for (Object key : keys) {
            env.setProperty((String)key, additionalProperties.getProperty((String)key));
        }
        try {
            this.ctx = new InitialLdapContext(env, null);
        }
        catch (NamingException e1) {
            throw new RuntimeException(e1);
        }
    }

    private void updateADPassword(LDAPUser user, String password) {
        try {
            ModificationItem[] mods = new ModificationItem[1];
            String newQuotedPassword = "\"" + password + "\"";
            byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
            mods[0] = new ModificationItem(2, new BasicAttribute("unicodePwd", newUnicodePassword));
            this.ctx.modifyAttributes(user.getDN(), mods);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

