/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.picketlink.idm.internal.jpa.AbstractDatabaseAttribute;
import org.picketlink.idm.model.IdentityType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MappedSuperclass
public abstract class AbstractDatabaseIdentityType<A extends AbstractDatabaseAttribute>
implements IdentityType {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    private String key;
    private boolean enabled = true;
    private Date expirationDate;
    private Date creationDate;
    @Transient
    private Map<String, String[]> userAttributesMap;

    public AbstractDatabaseIdentityType() {
    }

    public AbstractDatabaseIdentityType(String name) {
        this.setKey(name);
    }

    public String getId() {
        return String.valueOf(this.id);
    }

    public void setId(String id) {
        this.id = Long.valueOf(id);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Transient
    public void setAttribute(String name, String value) {
        this.getUserAttributesMap().put(name, new String[]{value});
        A attribute = this.createAttribute(name, value);
        ((AbstractDatabaseAttribute)attribute).setIdentityType((AbstractDatabaseIdentityType)this);
        this.getOwnerAttributes().add(attribute);
    }

    public abstract List<A> getOwnerAttributes();

    protected abstract A createAttribute(String var1, String var2);

    private Map<String, String[]> getUserAttributesMap() {
        if (this.userAttributesMap == null) {
            this.userAttributesMap = new HashMap<String, String[]>();
            for (AbstractDatabaseAttribute attribute : this.getOwnerAttributes()) {
                String[] values = this.userAttributesMap.get(attribute.getName());
                if (values == null) {
                    values = new String[]{attribute.getValue()};
                } else {
                    int len = values.length;
                    values = Arrays.copyOf(values, len + 1);
                    values[len] = attribute.getValue();
                }
                this.userAttributesMap.put(attribute.getName(), values);
            }
        }
        return this.userAttributesMap;
    }

    @Transient
    public void setAttribute(String name, String[] values) {
        this.getUserAttributesMap().put(name, values);
        for (String value : values) {
            A attribute = this.createAttribute(name, value);
            ((AbstractDatabaseAttribute)attribute).setIdentityType((AbstractDatabaseIdentityType)this);
            this.getOwnerAttributes().add(attribute);
        }
    }

    @Transient
    public void removeAttribute(String name) {
        this.getUserAttributesMap().remove(name);
        for (AbstractDatabaseAttribute attribute : new ArrayList<A>(this.getOwnerAttributes())) {
            if (!attribute.getName().equals(name)) continue;
            attribute.setIdentityType(null);
            this.getOwnerAttributes().remove(attribute);
        }
    }

    @Transient
    public String getAttribute(String name) {
        String[] values = this.getUserAttributesMap().get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    @Transient
    public String[] getAttributeValues(String name) {
        return this.getUserAttributesMap().get(name);
    }

    @Transient
    public Map<String, String[]> getAttributes() {
        return this.getUserAttributesMap();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractDatabaseIdentityType)) {
            return false;
        }
        AbstractDatabaseIdentityType other = (AbstractDatabaseIdentityType)obj;
        return new EqualsBuilder().append((Object)this.getId(), (Object)other.getId()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("key", (Object)this.getKey()).append("enabled", this.isEnabled()).append("expirationDate", (Object)this.getExpirationDate()).append("creationDate", (Object)this.getCreationDate()).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getId()).toHashCode();
    }
}

