/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import org.picketlink.idm.internal.jpa.AbstractDatabaseIdentityType;
import org.picketlink.idm.internal.jpa.DatabaseGroupAttribute;
import org.picketlink.idm.internal.jpa.DatabaseMembership;
import org.picketlink.idm.model.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQuery(name="GROUP.LOAD_BY_KEY", query="from DatabaseGroup where key = :key")
public class DatabaseGroup
extends AbstractDatabaseIdentityType<DatabaseGroupAttribute>
implements Group {
    private String name;
    @ManyToOne
    private DatabaseGroup parentGroup;
    @OneToMany(mappedBy="group", cascade={CascadeType.ALL})
    private List<DatabaseGroupAttribute> ownerAttributes = new ArrayList<DatabaseGroupAttribute>();
    @OneToMany(mappedBy="group", cascade={CascadeType.ALL})
    private List<DatabaseMembership> memberships = new ArrayList<DatabaseMembership>();

    public DatabaseGroup() {
    }

    public DatabaseGroup(String name) {
        super(name);
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Group getParentGroup() {
        return this.parentGroup;
    }

    public void setParentGroup(DatabaseGroup parentGroup) {
        this.parentGroup = parentGroup;
    }

    public void setOwnerAttributes(List<DatabaseGroupAttribute> ownerAttributes) {
        this.ownerAttributes = ownerAttributes;
    }

    public List<DatabaseMembership> getMemberships() {
        return this.memberships;
    }

    public void setMemberships(List<DatabaseMembership> memberships) {
        this.memberships = memberships;
    }

    @Override
    public List<DatabaseGroupAttribute> getOwnerAttributes() {
        return this.ownerAttributes;
    }

    @Override
    protected DatabaseGroupAttribute createAttribute(String name, String value) {
        return new DatabaseGroupAttribute(name, value);
    }
}

