/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import org.picketlink.idm.internal.jpa.AbstractDatabaseIdentityType;
import org.picketlink.idm.internal.jpa.DatabaseMembership;
import org.picketlink.idm.internal.jpa.DatabaseRoleAttribute;
import org.picketlink.idm.model.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQuery(name="ROLE.LOAD_BY_KEY", query="from DatabaseRole where key = :key")
public class DatabaseRole
extends AbstractDatabaseIdentityType<DatabaseRoleAttribute>
implements Role {
    private String name;
    @OneToMany(mappedBy="role", cascade={CascadeType.ALL})
    private List<DatabaseRoleAttribute> ownerAttributes = new ArrayList<DatabaseRoleAttribute>();
    @OneToMany(mappedBy="role", cascade={CascadeType.ALL})
    private List<DatabaseMembership> memberships = new ArrayList<DatabaseMembership>();

    public DatabaseRole() {
    }

    public DatabaseRole(String name) {
        super(name);
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<DatabaseRoleAttribute> getOwnerAttributes() {
        return this.ownerAttributes;
    }

    public void setOwnerAttributes(List<DatabaseRoleAttribute> ownerAttributes) {
        this.ownerAttributes = ownerAttributes;
    }

    public List<DatabaseMembership> getMemberships() {
        return this.memberships;
    }

    public void setMemberships(List<DatabaseMembership> memberships) {
        this.memberships = memberships;
    }

    @Override
    protected DatabaseRoleAttribute createAttribute(String name, String value) {
        return new DatabaseRoleAttribute(name, value);
    }
}

