/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.picketlink.idm.internal.jpa.AbstractDatabaseIdentityType;
import org.picketlink.idm.internal.jpa.DatabaseMembership;
import org.picketlink.idm.internal.jpa.DatabaseUserAttribute;
import org.picketlink.idm.model.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQuery(name="USER.LOAD_BY_KEY", query="from DatabaseUser where key = :key")
public class DatabaseUser
extends AbstractDatabaseIdentityType<DatabaseUserAttribute>
implements User {
    private String firstName;
    private String lastName;
    private String email;
    private String fullName;
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL})
    private List<DatabaseUserAttribute> ownerAttributes = new ArrayList<DatabaseUserAttribute>();
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL})
    private List<DatabaseMembership> memberships = new ArrayList<DatabaseMembership>();

    public DatabaseUser() {
    }

    public DatabaseUser(String key) {
        super(key);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Transient
    public String getFullName() {
        if (this.fullName == null) {
            this.fullName = this.getFirstName() + " " + this.getLastName();
        }
        return this.fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public List<DatabaseMembership> getMemberships() {
        return this.memberships;
    }

    public void setMemberships(List<DatabaseMembership> memberships) {
        this.memberships = memberships;
    }

    @Override
    public List<DatabaseUserAttribute> getOwnerAttributes() {
        return this.ownerAttributes;
    }

    public void setOwnerAttributes(List<DatabaseUserAttribute> userAttributes) {
        this.ownerAttributes = userAttributes;
    }

    @Override
    protected DatabaseUserAttribute createAttribute(String name, String value) {
        return new DatabaseUserAttribute(name, value);
    }
}

