/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal.ldap;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.picketlink.idm.internal.ldap.LDAPChangeNotificationHandler;
import org.picketlink.idm.internal.ldap.LDAPObjectChangedNotification;
import org.picketlink.idm.internal.util.Base64;
import org.picketlink.idm.model.IdentityType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirContextAdaptor
implements DirContext,
IdentityType {
    public static final String COMMA = ",";
    public static final String EQUAL = "=";
    public static final String SPACE_STRING = " ";
    protected Attributes attributes = new BasicAttributes(true);
    protected LDAPChangeNotificationHandler handler = null;

    public void addAllLDAPAttributes(Attributes theAttributes) {
        if (theAttributes != null) {
            NamingEnumeration<? extends Attribute> ne = theAttributes.getAll();
            try {
                while (ne.hasMore()) {
                    Attribute att = ne.next();
                    this.attributes.put(att);
                }
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return null;
    }

    public void setLDAPChangeNotificationHandler(LDAPChangeNotificationHandler lh) {
        this.handler = lh;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return null;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
    }

    @Override
    public void unbind(Name name) throws NamingException {
    }

    @Override
    public void unbind(String name) throws NamingException {
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return null;
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return null;
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return null;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return null;
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return null;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return null;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return null;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return null;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return null;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return null;
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return null;
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return null;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return null;
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.attributes;
    }

    public Attributes getLDAPAttributes() {
        return this.attributes;
    }

    @Override
    public Attributes getAttributes(Name name, String[] ids) throws NamingException {
        return this.getAttributes(name.toString(), ids);
    }

    @Override
    public Attributes getAttributes(String name, String[] ids) throws NamingException {
        if (!name.equals("")) {
            throw new NameNotFoundException();
        }
        BasicAttributes answer = new BasicAttributes(true);
        for (int i = 0; i < ids.length; ++i) {
            Attribute target = this.attributes.get(ids[i]);
            if (target == null) continue;
            answer.put(target);
        }
        return answer;
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return null;
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return null;
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        return null;
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        return null;
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return null;
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return null;
    }

    public String getKey() {
        return null;
    }

    public boolean isEnabled() {
        return false;
    }

    public Date getExpirationDate() {
        return null;
    }

    public Date getCreationDate() {
        return null;
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
        Attribute anAttribute = this.attributes.get(name);
        if (this.handler != null) {
            this.handler.handle(new LDAPObjectChangedNotification(this, LDAPObjectChangedNotification.NType.ADD_ATTRIBUTE, anAttribute));
        }
    }

    protected void replaceAttribute(String name, String value) {
        this.attributes.put(name, value);
        Attribute anAttribute = this.attributes.get(name);
        if (this.handler != null) {
            this.handler.handle(new LDAPObjectChangedNotification(this, LDAPObjectChangedNotification.NType.REPLACE_ATTRIBUTE, anAttribute));
        }
    }

    public void setAttribute(String name, String[] values) {
        this.attributes.put(name, values);
        Attribute anAttribute = this.attributes.get(name);
        if (this.handler != null) {
            this.handler.handle(new LDAPObjectChangedNotification(this, LDAPObjectChangedNotification.NType.ADD_ATTRIBUTE, anAttribute));
        }
    }

    public void removeAttribute(String name) {
        Attribute anAttribute = this.attributes.get(name);
        this.attributes.remove(name);
        if (this.handler != null) {
            this.handler.handle(new LDAPObjectChangedNotification(this, LDAPObjectChangedNotification.NType.REMOVE_ATTRIBUTE, anAttribute));
        }
    }

    public String getAttribute(String name) {
        try {
            Attribute theAttribute = this.attributes.get(name);
            Object obj = theAttribute.get();
            String val = null;
            val = obj instanceof byte[] ? new String(Base64.encodeBytes((byte[])obj)) : (String)obj;
            return val;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getAttributeValues(String name) {
        try {
            Attribute theAttribute = this.attributes.get(name);
            if (theAttribute != null) {
                return (String[])theAttribute.get();
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public Map<String, String[]> getAttributes() {
        try {
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            NamingEnumeration<? extends Attribute> theAttributes = this.attributes.getAll();
            while (theAttributes.hasMore()) {
                Attribute anAttribute = theAttributes.next();
                NamingEnumeration<?> ne = anAttribute.getAll();
                ArrayList<String> theList = new ArrayList<String>();
                while (ne.hasMoreElements()) {
                    String val = null;
                    Object obj = ne.next();
                    val = obj instanceof byte[] ? new String(Base64.encodeBytes((byte[])obj)) : (String)obj;
                    theList.add(val);
                }
                String[] valuesArr = new String[theList.size()];
                theList.toArray(valuesArr);
                map.put(anAttribute.getID(), valuesArr);
            }
            return map;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }
}

