/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal.password;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.picketlink.idm.internal.util.Base64;
import org.picketlink.idm.model.User;
import org.picketlink.idm.password.PasswordEncoder;

public class SHASaltedPasswordEncoder
implements PasswordEncoder {
    private static final String PASSWORD_SALT_USER_ATTRIBUTE = "passwordSalt";
    private int strength;

    public SHASaltedPasswordEncoder(int strength) {
        this.strength = strength;
    }

    public String encodePassword(User user, String rawPassword) {
        MessageDigest messageDigest = this.getMessageDigest();
        String salt = user.getAttribute(PASSWORD_SALT_USER_ATTRIBUTE);
        if (salt == null) {
            SecureRandom psuedoRng = null;
            String algorithm = "SHA1PRNG";
            try {
                psuedoRng = SecureRandom.getInstance(algorithm);
                psuedoRng.setSeed(1024L);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Error getting SecureRandom instance: " + algorithm, e);
            }
            salt = String.valueOf(psuedoRng.nextLong());
            user.setAttribute(PASSWORD_SALT_USER_ATTRIBUTE, salt);
        }
        byte[] encodedPassword = null;
        try {
            encodedPassword = messageDigest.digest(this.saltPassword(rawPassword, salt).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error encoding password", e);
        }
        return Base64.encodeBytes(encodedPassword);
    }

    private String saltPassword(String rawPassword, String salt) {
        return rawPassword + salt.toString();
    }

    protected final MessageDigest getMessageDigest() throws IllegalArgumentException {
        String algorithm = "SHA-" + this.strength;
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm: " + algorithm);
        }
    }
}

