/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.CredentialUtils;
import org.picketlink.idm.credential.internal.DigestCredentialHandler;
import org.picketlink.idm.credential.internal.PasswordCredentialHandler;
import org.picketlink.idm.credential.internal.TOTPCredentialHandler;
import org.picketlink.idm.credential.internal.X509CertificateCredentialHandler;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.CredentialHandlers;
import org.picketlink.idm.credential.spi.annotations.Stored;
import org.picketlink.idm.event.AgentCreatedEvent;
import org.picketlink.idm.event.AgentDeletedEvent;
import org.picketlink.idm.event.AgentUpdatedEvent;
import org.picketlink.idm.event.GroupCreatedEvent;
import org.picketlink.idm.event.GroupDeletedEvent;
import org.picketlink.idm.event.GroupUpdatedEvent;
import org.picketlink.idm.event.RelationshipCreatedEvent;
import org.picketlink.idm.event.RelationshipDeletedEvent;
import org.picketlink.idm.event.RelationshipUpdatedEvent;
import org.picketlink.idm.event.RoleCreatedEvent;
import org.picketlink.idm.event.RoleDeletedEvent;
import org.picketlink.idm.event.RoleUpdatedEvent;
import org.picketlink.idm.event.UserCreatedEvent;
import org.picketlink.idm.event.UserDeletedEvent;
import org.picketlink.idm.event.UserUpdatedEvent;
import org.picketlink.idm.file.internal.FileAgent;
import org.picketlink.idm.file.internal.FileCredentialStorage;
import org.picketlink.idm.file.internal.FileDataSource;
import org.picketlink.idm.file.internal.FileGroup;
import org.picketlink.idm.file.internal.FileIdentityQueryHelper;
import org.picketlink.idm.file.internal.FilePartition;
import org.picketlink.idm.file.internal.FileRelationship;
import org.picketlink.idm.file.internal.FileRole;
import org.picketlink.idm.file.internal.FileSortingComparator;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.idm.model.annotation.AttributeProperty;
import org.picketlink.idm.model.annotation.IdentityProperty;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.RelationshipQueryParameter;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.SecurityContext;

@CredentialHandlers(value={PasswordCredentialHandler.class, X509CertificateCredentialHandler.class, DigestCredentialHandler.class, TOTPCredentialHandler.class})
public class FileBasedIdentityStore
implements CredentialStore<FileIdentityStoreConfiguration> {
    private FileIdentityStoreConfiguration config;
    private FileDataSource fileDataSource;

    public void setup(FileIdentityStoreConfiguration config) {
        this.fileDataSource = new FileDataSource();
        this.fileDataSource.init(config);
        this.config = config;
    }

    public FileIdentityStoreConfiguration getConfig() {
        return this.config;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(SecurityContext context, AttributedType attributedType) {
        attributedType.setId(context.getIdGenerator().generate());
        if (IdentityType.class.isInstance(attributedType)) {
            Class<?> identityTypeClass = attributedType.getClass();
            if (IDMUtil.isAgentType(identityTypeClass)) {
                Agent agent = (Agent)attributedType;
                if (IDMUtil.isUserType(identityTypeClass)) {
                    this.addUser(context, (User)agent);
                    return;
                } else {
                    this.addAgent(context, agent);
                }
                return;
            } else if (IDMUtil.isGroupType(identityTypeClass)) {
                this.addGroup(context, (Group)attributedType);
                return;
            } else {
                if (!IDMUtil.isRoleType(identityTypeClass)) throw IDMMessages.MESSAGES.identityTypeUnsupportedType(identityTypeClass);
                this.addRole(context, (Role)attributedType);
            }
            return;
        } else {
            if (!Relationship.class.isInstance(attributedType)) throw IDMMessages.MESSAGES.attributedTypeUnsupportedType(attributedType.getClass());
            Relationship relationship = (Relationship)attributedType;
            this.addRelationship(context, relationship);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(SecurityContext context, AttributedType attributedType) {
        if (IdentityType.class.isInstance(attributedType)) {
            Class<?> identityTypeClass = attributedType.getClass();
            if (IDMUtil.isUserType(identityTypeClass)) {
                this.updateUser(context, (User)attributedType);
                return;
            } else if (IDMUtil.isAgentType(identityTypeClass)) {
                this.updateAgent(context, (Agent)attributedType);
                return;
            } else if (IDMUtil.isGroupType(identityTypeClass)) {
                this.updateGroup(context, (Group)attributedType);
                return;
            } else {
                if (!IDMUtil.isRoleType(identityTypeClass)) throw IDMMessages.MESSAGES.identityTypeUnsupportedType(identityTypeClass);
                this.updateRole(context, (Role)attributedType);
            }
            return;
        } else {
            if (!Relationship.class.isInstance(attributedType)) throw IDMMessages.MESSAGES.attributedTypeUnsupportedType(attributedType.getClass());
            this.updateRelationship(context, (Relationship)attributedType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(SecurityContext context, AttributedType attributedType) {
        Class<?> attributedTypeClass = attributedType.getClass();
        if (IdentityType.class.isInstance(attributedType)) {
            if (IDMUtil.isAgentType(attributedTypeClass)) {
                this.removeAgent(context, (Agent)attributedType);
                return;
            } else if (IDMUtil.isGroupType(attributedTypeClass)) {
                this.removeGroup(context, (Group)attributedType);
                return;
            } else {
                if (!IDMUtil.isRoleType(attributedTypeClass)) throw IDMMessages.MESSAGES.identityTypeUnsupportedType(attributedTypeClass);
                this.removeRole(context, (Role)attributedType);
            }
            return;
        } else {
            if (!Relationship.class.isInstance(attributedType)) throw IDMMessages.MESSAGES.attributedTypeUnsupportedType(attributedTypeClass);
            this.removeRelationship(context, (Relationship)attributedType);
        }
    }

    public Agent getAgent(SecurityContext context, String loginName) {
        if (loginName == null) {
            return null;
        }
        Agent agent = this.getAgentsForCurrentRealm(context).get(loginName);
        if (agent != null) {
            this.configurePartition((IdentityType)agent);
        }
        return agent;
    }

    public User getUser(SecurityContext context, String loginName) {
        if (loginName == null) {
            return null;
        }
        Agent agent = this.getAgent(context, loginName);
        if (!User.class.isInstance(agent)) {
            return null;
        }
        return (User)agent;
    }

    public Role getRole(SecurityContext context, String roleName) {
        return this.lookupRole(roleName, context.getPartition());
    }

    public Group getGroup(SecurityContext context, String groupPath) {
        Group group = null;
        if (groupPath != null) {
            Group parentGroup;
            if (!groupPath.startsWith("/")) {
                groupPath = "/" + groupPath;
            }
            if ((group = this.lookupGroup(groupPath, context.getPartition())) != null && (parentGroup = group.getParentGroup()) != null) {
                group.setParentGroup(this.getGroup(context, parentGroup.getPath()));
            }
        }
        return group;
    }

    public Group getGroup(SecurityContext context, String name, Group parent) {
        String path = "/" + name;
        if (parent != null) {
            Group parentGroup = (Group)this.lookupIdentityTypeById(context, parent.getId());
            path = parentGroup.getPath() + path;
        }
        return this.getGroup(context, path);
    }

    public <T extends IdentityType> int countQueryResults(SecurityContext context, IdentityQuery<T> identityQuery) {
        int limit = identityQuery.getLimit();
        int offset = identityQuery.getOffset();
        identityQuery.setLimit(0);
        identityQuery.setOffset(0);
        int resultCount = identityQuery.getResultList().size();
        identityQuery.setLimit(limit);
        identityQuery.setOffset(offset);
        return resultCount;
    }

    public <T extends Serializable> Attribute<T> getAttribute(SecurityContext context, IdentityType identityType, String attributeName) {
        throw IDMMessages.MESSAGES.notImplentedYet();
    }

    public void setAttribute(SecurityContext context, IdentityType identityType, Attribute<? extends Serializable> attribute) {
        throw IDMMessages.MESSAGES.notImplentedYet();
    }

    public void removeAttribute(SecurityContext context, IdentityType identityType, String attributeName) {
        throw IDMMessages.MESSAGES.notImplentedYet();
    }

    public <T extends Relationship> int countQueryResults(SecurityContext context, RelationshipQuery<T> query) {
        throw IDMMessages.MESSAGES.notImplentedYet();
    }

    public <T extends Relationship> List<T> fetchQueryResults(SecurityContext context, RelationshipQuery<T> query) {
        return this.fetchQueryResults(context, query, false);
    }

    public <T extends IdentityType> List<T> fetchQueryResults(SecurityContext context, IdentityQuery<T> identityQuery) {
        Class identityTypeClass = identityQuery.getIdentityType();
        Collection<Object> entries = new ArrayList<Object>();
        Object[] partitionParameters = identityQuery.getParameter(IdentityType.PARTITION);
        Partition partition = null;
        if (partitionParameters != null && partitionParameters.length > 0) {
            partition = (Partition)partitionParameters[0];
        }
        if (IdentityType.class.equals((Object)identityTypeClass)) {
            if (partition == null) {
                entries.addAll(this.getAgentsForCurrentRealm(context).values());
                entries.addAll(this.getRolesForCurrentPartition(context).values());
                entries.addAll(this.getGroupsForCurrentPartition(context).values());
            } else {
                entries.addAll(this.getAgentsForPartition(partition).values());
                entries.addAll(this.getRolesForPartition(partition).values());
                entries.addAll(this.getGroupsForPartition(partition).values());
            }
        } else if (IDMUtil.isAgentType(identityTypeClass)) {
            entries = partition == null ? this.getAgentsForCurrentRealm(context).values() : this.getAgentsForPartition(partition).values();
        } else if (IDMUtil.isRoleType(identityTypeClass)) {
            entries = partition == null ? this.getRolesForCurrentPartition(context).values() : this.getRolesForPartition(partition).values();
        } else if (IDMUtil.isGroupType(identityTypeClass)) {
            entries = partition == null ? this.getGroupsForCurrentPartition(context).values() : this.getGroupsForPartition(partition).values();
        } else {
            throw IDMMessages.MESSAGES.identityTypeUnsupportedType(identityTypeClass);
        }
        List<IdentityType> result = new ArrayList();
        FileIdentityQueryHelper queryHelper = new FileIdentityQueryHelper(identityQuery, this);
        for (IdentityType identityType : entries) {
            Role role;
            User user;
            Agent agent;
            if (!identityTypeClass.isAssignableFrom(identityType.getClass()) || !FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, IdentityType.ID, (Serializable)((Object)identityType.getId())) || IDMUtil.isAgentType(identityTypeClass) && (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, Agent.LOGIN_NAME, (Serializable)((Object)(agent = (Agent)identityType).getLoginName())) || IDMUtil.isUserType(identityTypeClass) && (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, User.EMAIL, (Serializable)((Object)(user = (User)identityType).getEmail())) || !FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, User.FIRST_NAME, (Serializable)((Object)user.getFirstName())) || !FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, User.LAST_NAME, (Serializable)((Object)user.getLastName())))) || IDMUtil.isRoleType(identityTypeClass) && !FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, Role.NAME, (Serializable)((Object)(role = (Role)identityType).getName()))) continue;
            if (IDMUtil.isGroupType(identityTypeClass)) {
                Group group = (Group)identityType;
                if (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, Group.NAME, (Serializable)((Object)group.getName()))) continue;
                String parentGroupName = null;
                if (group.getParentGroup() != null) {
                    parentGroupName = group.getParentGroup().getName();
                }
                if (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, Group.PARENT, (Serializable)((Object)parentGroupName))) continue;
            }
            if (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, IdentityType.ENABLED, Boolean.valueOf(identityType.isEnabled())) || !queryHelper.matchCreatedDateParameters(identityType) || !queryHelper.matchExpiryDateParameters(identityType) || !queryHelper.matchAttributes(identityType) || !queryHelper.matchHasRole(context, identityType) || !queryHelper.matchMemberOf(context, identityType) || !queryHelper.matchHasGroupRole(context, identityType) || !queryHelper.matchRolesOf(context, identityType) || !queryHelper.matchHasMember(context, identityType)) continue;
            this.configurePartition(identityType);
            result.add(identityType);
        }
        Collections.sort(result, new FileSortingComparator<T>(identityQuery));
        if (identityQuery.getLimit() > 0) {
            int numberOfItems = Math.min(identityQuery.getLimit(), result.size() - identityQuery.getOffset());
            result = result.subList(identityQuery.getOffset(), identityQuery.getOffset() + numberOfItems);
        }
        return result;
    }

    protected <T extends Relationship> T convertToRelationship(SecurityContext context, FileRelationship fileRelationship) {
        Class<?> relationshipType = null;
        try {
            relationshipType = Class.forName(fileRelationship.getType());
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.classNotFound(fileRelationship.getType());
        }
        return this.cloneRelationship(context, fileRelationship, relationshipType);
    }

    protected Map<String, List<FileRelationship>> getRelationshipsForCurrentPartition() {
        return this.getDataSource().getRelationships();
    }

    protected boolean hasParentGroup(Group childGroup, Group parentGroup) {
        if (childGroup.getParentGroup() != null && parentGroup != null) {
            if (childGroup.getParentGroup().getId().equals(parentGroup.getId())) {
                return true;
            }
        } else {
            return false;
        }
        return this.hasParentGroup(childGroup.getParentGroup(), parentGroup);
    }

    private <T extends Relationship> T cloneRelationship(SecurityContext context, FileRelationship fileRelationship, Class<? extends Relationship> relationshipType) {
        Relationship clonedRelationship = null;
        try {
            clonedRelationship = relationshipType.newInstance();
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.instantiationError(relationshipType.getName(), (Throwable)e);
        }
        Relationship storedRelationship = (Relationship)fileRelationship.getEntry();
        clonedRelationship.setId(storedRelationship.getId());
        List relationshipIdentityTypes = PropertyQueries.createQuery(clonedRelationship.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(IdentityProperty.class)).getResultList();
        for (Property annotatedProperty : relationshipIdentityTypes) {
            IdentityType identityType = this.lookupIdentityTypeById(context, fileRelationship.getIdentityTypeId(annotatedProperty.getName()));
            if (identityType == null) {
                return null;
            }
            annotatedProperty.setValue((Object)clonedRelationship, (Object)identityType);
        }
        this.updateAttributedType((AttributedType)storedRelationship, (AttributedType)clonedRelationship);
        return (T)clonedRelationship;
    }

    private void addRole(SecurityContext context, Role role) {
        SimpleRole fileRole = new SimpleRole(role.getName());
        this.updateIdentityType(context, (IdentityType)role, (IdentityType)fileRole);
        this.storeRole((Role)fileRole);
        context.getEventBridge().raiseEvent((Object)new RoleCreatedEvent(role));
    }

    private void storeRole(Role role) {
        FilePartition filePartition = this.getDataSource().getPartition(role.getPartition());
        filePartition.getRoles().put(role.getName(), new FileRole(role));
        this.getDataSource().flushRoles(filePartition);
    }

    private void addGroup(SecurityContext context, Group group) {
        SimpleGroup fileGroup = null;
        if (group.getParentGroup() != null) {
            Group parentGroup = (Group)this.lookupIdentityTypeById(context, group.getParentGroup().getId());
            fileGroup = new SimpleGroup(group.getName(), parentGroup);
        } else {
            fileGroup = new SimpleGroup(group.getName());
        }
        this.updateIdentityType(context, (IdentityType)group, (IdentityType)fileGroup);
        this.storeGroup((Group)fileGroup);
        context.getEventBridge().raiseEvent((Object)new GroupCreatedEvent(group));
    }

    private void storeGroup(Group fileGroup) {
        FilePartition partition = this.getDataSource().getPartition(fileGroup.getPartition());
        partition.getGroups().put(fileGroup.getPath(), new FileGroup(fileGroup));
        this.getDataSource().flushGroups(partition);
    }

    private void addUser(SecurityContext context, User user) {
        SimpleUser storedUser = new SimpleUser(user.getLoginName());
        storedUser.setFirstName(user.getFirstName());
        storedUser.setLastName(user.getLastName());
        storedUser.setEmail(user.getEmail());
        this.updateIdentityType(context, (IdentityType)user, (IdentityType)storedUser);
        this.storeAgent((Agent)storedUser);
        context.getEventBridge().raiseEvent((Object)new UserCreatedEvent((User)storedUser));
    }

    private void addAgent(SecurityContext context, Agent agent) {
        SimpleAgent storedAgent = new SimpleAgent(agent.getLoginName());
        this.updateIdentityType(context, (IdentityType)agent, (IdentityType)storedAgent);
        this.storeAgent((Agent)storedAgent);
        context.getEventBridge().raiseEvent((Object)new AgentCreatedEvent((Agent)storedAgent));
    }

    private void storeAgent(Agent storedAgent) {
        FilePartition filePartition = this.getDataSource().getPartition(storedAgent.getPartition());
        filePartition.getAgents().put(storedAgent.getLoginName(), new FileAgent(storedAgent));
        this.getDataSource().flushAgents(filePartition);
    }

    private void addRelationship(SecurityContext context, Relationship relationship) {
        if (relationship.getId() == null) {
            relationship.setId(context.getIdGenerator().generate());
        }
        Relationship newRelationship = null;
        try {
            newRelationship = (Relationship)relationship.getClass().newInstance();
        }
        catch (Exception e) {
            IDMMessages.MESSAGES.instantiationError(relationship.getClass().getName(), (Throwable)e);
        }
        newRelationship.setId(relationship.getId());
        List relationshipIdentityTypes = PropertyQueries.createQuery(newRelationship.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(IdentityProperty.class)).getResultList();
        for (Property annotatedProperty : relationshipIdentityTypes) {
            annotatedProperty.setValue((Object)newRelationship, annotatedProperty.getValue((Object)relationship));
        }
        this.updateAttributedType((AttributedType)relationship, (AttributedType)newRelationship);
        FileRelationship fileRelationship = new FileRelationship(newRelationship);
        Map<String, List<FileRelationship>> relationshipsMap = this.getDataSource().getRelationships();
        List<FileRelationship> relationships = relationshipsMap.get(newRelationship.getClass().getName());
        if (relationships == null) {
            relationships = new ArrayList<FileRelationship>();
            relationshipsMap.put(newRelationship.getClass().getName(), relationships);
        }
        relationships.add(fileRelationship);
        this.getDataSource().flushRelationships();
        context.getEventBridge().raiseEvent((Object)new RelationshipCreatedEvent(relationship));
    }

    private void updateRole(SecurityContext context, Role updatedRole) {
        Role storedRole = (Role)this.lookupIdentityTypeById(context, updatedRole.getId());
        if (storedRole != updatedRole) {
            this.updateIdentityType(context, (IdentityType)updatedRole, (IdentityType)storedRole);
        }
        this.storeRole(storedRole);
        context.getEventBridge().raiseEvent((Object)new RoleUpdatedEvent(updatedRole));
    }

    private void updateGroup(SecurityContext context, Group updatedGroup) {
        Group storedGroup = (Group)this.lookupIdentityTypeById(context, updatedGroup.getId());
        if (storedGroup != updatedGroup) {
            this.updateIdentityType(context, (IdentityType)updatedGroup, (IdentityType)storedGroup);
        }
        this.storeGroup(storedGroup);
        context.getEventBridge().raiseEvent((Object)new GroupUpdatedEvent(updatedGroup));
    }

    private void updateUser(SecurityContext context, User updatedUser) {
        User storedUser = (User)this.lookupIdentityTypeById(context, updatedUser.getId());
        if (storedUser != updatedUser) {
            storedUser.setFirstName(updatedUser.getFirstName());
            storedUser.setLastName(updatedUser.getLastName());
            storedUser.setEmail(updatedUser.getEmail());
            this.updateIdentityType(context, (IdentityType)updatedUser, (IdentityType)storedUser);
        }
        this.storeAgent((Agent)storedUser);
        context.getEventBridge().raiseEvent((Object)new UserUpdatedEvent(updatedUser));
    }

    private void updateAgent(SecurityContext context, Agent updatedAgent) {
        Agent storedAgent = (Agent)this.lookupIdentityTypeById(context, updatedAgent.getId());
        if (storedAgent != updatedAgent) {
            this.updateIdentityType(context, (IdentityType)updatedAgent, (IdentityType)storedAgent);
        }
        this.storeAgent(storedAgent);
        context.getEventBridge().raiseEvent((Object)new AgentUpdatedEvent(updatedAgent));
    }

    private void updateRelationship(SecurityContext context, Relationship relationship) {
        List<FileRelationship> relationships = this.getDataSource().getRelationships().get(relationship.getClass().getName());
        for (FileRelationship fileRelationship : new ArrayList<FileRelationship>(relationships)) {
            Relationship storedRelationship = (Relationship)fileRelationship.getEntry();
            if (!storedRelationship.getId().equals(relationship.getId())) continue;
            for (Object object : storedRelationship.getAttributes().toArray()) {
                Attribute attribute = (Attribute)object;
                storedRelationship.removeAttribute(attribute.getName());
            }
            for (Attribute attrib : relationship.getAttributes()) {
                storedRelationship.setAttribute(attrib);
            }
        }
        context.getEventBridge().raiseEvent((Object)new RelationshipUpdatedEvent(relationship));
    }

    private void updateIdentityType(SecurityContext context, IdentityType fromIdentityType, IdentityType toIdentityType) {
        toIdentityType.setEnabled(fromIdentityType.isEnabled());
        toIdentityType.setCreatedDate(fromIdentityType.getCreatedDate());
        toIdentityType.setExpirationDate(fromIdentityType.getExpirationDate());
        toIdentityType.setPartition(context.getPartition());
        fromIdentityType.setPartition(context.getPartition());
        this.updateAttributedType((AttributedType)fromIdentityType, (AttributedType)toIdentityType);
    }

    private void updateAttributedType(AttributedType fromIdentityType, AttributedType toIdentityType) {
        toIdentityType.setId(fromIdentityType.getId());
        for (Object object : toIdentityType.getAttributes().toArray()) {
            Attribute attribute = (Attribute)object;
            toIdentityType.removeAttribute(attribute.getName());
        }
        List attributeProperties = PropertyQueries.createQuery(fromIdentityType.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(AttributeProperty.class)).getResultList();
        for (Property attributeProperty : attributeProperties) {
            attributeProperty.setValue((Object)toIdentityType, attributeProperty.getValue((Object)fromIdentityType));
        }
        for (Attribute attrib : fromIdentityType.getAttributes()) {
            toIdentityType.setAttribute(attrib);
        }
    }

    private Role lookupRole(String roleName, Partition partition) {
        if (roleName == null) {
            return null;
        }
        Role role = this.getRolesForPartition(partition).get(roleName);
        if (role != null) {
            this.configurePartition((IdentityType)role);
        }
        return role;
    }

    private Group lookupGroup(String groupPath, Partition partition) {
        if (groupPath == null) {
            return null;
        }
        Group group = this.getGroupsForPartition(partition).get(groupPath);
        if (group != null) {
            this.configurePartition((IdentityType)group);
        }
        return group;
    }

    private void removeRelationship(SecurityContext context, Relationship relationship) {
        if (relationship.getId() == null) {
            DefaultRelationshipQuery<GroupRole> query = null;
            if (GroupRole.class.isInstance(relationship)) {
                GroupRole groupRole = (GroupRole)relationship;
                query = new DefaultRelationshipQuery<GroupRole>(context, GroupRole.class, (IdentityStore<?>)this);
                query.setParameter((QueryParameter)GroupRole.ASSIGNEE, groupRole.getAssignee());
                query.setParameter((QueryParameter)GroupRole.GROUP, groupRole.getGroup());
                query.setParameter((QueryParameter)GroupRole.ROLE, groupRole.getRole());
            } else if (Grant.class.isInstance(relationship)) {
                Grant grant = (Grant)relationship;
                query = new DefaultRelationshipQuery<Grant>(context, Grant.class, (IdentityStore<?>)this);
                query.setParameter((QueryParameter)Grant.ASSIGNEE, grant.getAssignee());
                query.setParameter((QueryParameter)Grant.ROLE, grant.getRole());
            } else if (GroupMembership.class.isInstance(relationship)) {
                GroupMembership groupMembership = (GroupMembership)relationship;
                query = new DefaultRelationshipQuery<GroupMembership>(context, GroupMembership.class, (IdentityStore<?>)this);
                query.setParameter((QueryParameter)GroupMembership.MEMBER, groupMembership.getMember());
                query.setParameter((QueryParameter)GroupMembership.GROUP, groupMembership.getGroup());
            }
            List<GroupRole> result = this.fetchQueryResults(context, query, true);
            if (!result.isEmpty()) {
                if (result.size() > 1) {
                    throw IDMMessages.MESSAGES.relationshipAmbiguosFound(relationship);
                }
                relationship = (Relationship)result.get(0);
            } else {
                return;
            }
        }
        List<FileRelationship> relationships = this.getDataSource().getRelationships().get(relationship.getClass().getName());
        for (FileRelationship fileRelationship : new ArrayList<FileRelationship>(relationships)) {
            Relationship storedRelationship = (Relationship)fileRelationship.getEntry();
            if (!storedRelationship.getId().equals(relationship.getId())) continue;
            relationships.remove(fileRelationship);
        }
        this.getDataSource().flushRelationships();
        context.getEventBridge().raiseEvent((Object)new RelationshipDeletedEvent(relationship));
    }

    private void removeRole(SecurityContext context, Role role) {
        Role storedRole = (Role)this.lookupIdentityTypeById(context, role.getId());
        FilePartition partition = this.getDataSource().getPartition(storedRole.getPartition());
        this.removeRelationships((IdentityType)storedRole);
        partition.getRoles().remove(storedRole.getName());
        this.getDataSource().flushRoles(partition);
        context.getEventBridge().raiseEvent((Object)new RoleDeletedEvent(role));
    }

    private void removeGroup(SecurityContext context, Group group) {
        Group storedGroup = (Group)this.lookupIdentityTypeById(context, group.getId());
        FilePartition partition = this.getDataSource().getPartition(storedGroup.getPartition());
        this.removeRelationships((IdentityType)storedGroup);
        partition.getGroups().remove(storedGroup.getPath());
        this.getDataSource().flushGroups(partition);
        context.getEventBridge().raiseEvent((Object)new GroupDeletedEvent(group));
    }

    private void removeAgent(SecurityContext context, Agent agent) {
        Agent storedAgent = (Agent)this.lookupIdentityTypeById(context, agent.getId());
        FilePartition partition = this.getDataSource().getPartition(storedAgent.getPartition());
        this.removeRelationships((IdentityType)storedAgent);
        partition.getAgents().remove(storedAgent.getLoginName());
        this.getDataSource().flushAgents(partition);
        this.removeCredentials(context, storedAgent);
        if (IDMUtil.isUserType(agent.getClass())) {
            context.getEventBridge().raiseEvent((Object)new UserDeletedEvent((User)agent));
        }
        context.getEventBridge().raiseEvent((Object)new AgentDeletedEvent(agent));
    }

    private void removeRelationships(IdentityType identityType) {
        Set<Map.Entry<String, List<FileRelationship>>> allRelationships = this.getDataSource().getRelationships().entrySet();
        for (Map.Entry<String, List<FileRelationship>> entry : allRelationships) {
            List<FileRelationship> relationships = entry.getValue();
            for (FileRelationship fileRelationship : new ArrayList<FileRelationship>(relationships)) {
                if (!fileRelationship.hasIdentityType(identityType.getId())) continue;
                relationships.remove(fileRelationship);
            }
        }
        this.getDataSource().flushRelationships();
    }

    private Map<String, Group> getGroupsForPartition(Partition partition) {
        return this.getDataSource().getGroups(partition);
    }

    private Map<String, Role> getRolesForPartition(Partition partition) {
        return this.getDataSource().getRoles(partition);
    }

    private Map<String, Agent> getAgentsForPartition(Partition partition) {
        return this.getDataSource().getAgents(partition);
    }

    private Map<String, Role> getRolesForCurrentPartition(SecurityContext context) {
        return this.getDataSource().getRoles(context.getPartition());
    }

    private Map<String, Group> getGroupsForCurrentPartition(SecurityContext context) {
        return this.getDataSource().getGroups(context.getPartition());
    }

    private Map<String, Agent> getAgentsForCurrentRealm(SecurityContext context) {
        Realm realm = (Realm)context.getPartition();
        return this.getDataSource().getAgents((Partition)realm);
    }

    protected FileDataSource getDataSource() {
        return this.fileDataSource;
    }

    private void configurePartition(IdentityType identityType) {
        if (identityType == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (identityType.getPartition() == null) {
            throw new IdentityManagementException("IdentityType [" + identityType + "] does not belong to any Partition.");
        }
        identityType.setPartition(identityType.getPartition());
    }

    private <T extends Relationship> List<T> fetchQueryResults(SecurityContext context, RelationshipQuery<T> query, boolean matchExactGroup) {
        ArrayList<T> result = new ArrayList<T>();
        Class relationshipType = query.getRelationshipType();
        ArrayList<FileRelationship> relationships = new ArrayList<FileRelationship>();
        if (Relationship.class.equals((Object)query.getRelationshipType())) {
            Collection<List<FileRelationship>> allRelationships = this.getRelationshipsForCurrentPartition().values();
            for (List<FileRelationship> partitionRelationships : allRelationships) {
                relationships.addAll(partitionRelationships);
            }
        } else {
            List<FileRelationship> currentRealmRelationships = this.getRelationshipsForCurrentPartition().get(relationshipType.getName());
            if (currentRealmRelationships != null) {
                relationships.addAll(currentRealmRelationships);
            }
        }
        if (relationships.isEmpty()) {
            return result;
        }
        for (FileRelationship storedRelationship : relationships) {
            boolean match = false;
            Object[] identityParameterValues = query.getParameter(Relationship.IDENTITY);
            if (identityParameterValues != null && identityParameterValues.length > 0) {
                for (Object parameterValue : identityParameterValues) {
                    String identityId = null;
                    if (String.class.isInstance(parameterValue)) {
                        identityId = (String)parameterValue;
                    } else if (IdentityType.class.isInstance(parameterValue)) {
                        IdentityType identityType = (IdentityType)parameterValue;
                        identityId = identityType.getId();
                    } else {
                        throw IDMMessages.MESSAGES.queryUnsupportedParameterValue("Relationship.IDENTITY", parameterValue);
                    }
                    match = storedRelationship.hasIdentityType(identityId);
                }
            } else if (query.getRelationshipType().getName().equals(storedRelationship.getType())) {
                for (Map.Entry entry : query.getParameters().entrySet()) {
                    QueryParameter queryParameter = (QueryParameter)entry.getKey();
                    Object[] values = (Object[])entry.getValue();
                    if (queryParameter instanceof RelationshipQueryParameter) {
                        RelationshipQueryParameter identityTypeParameter = (RelationshipQueryParameter)queryParameter;
                        match = this.matchIdentityType(context, storedRelationship, query, identityTypeParameter, matchExactGroup);
                    }
                    if (AttributedType.AttributeParameter.class.isInstance(queryParameter) && values != null) {
                        AttributedType.AttributeParameter customParameter = (AttributedType.AttributeParameter)queryParameter;
                        Attribute userAttribute = ((Relationship)storedRelationship.getEntry()).getAttribute(customParameter.getName());
                        Serializable userAttributeValue = null;
                        if (userAttribute != null) {
                            userAttributeValue = userAttribute.getValue();
                        }
                        if (userAttributeValue != null) {
                            int count = values.length;
                            for (Object value : values) {
                                if (userAttributeValue.getClass().isArray()) {
                                    Object[] userValues;
                                    for (Object object : userValues = (Object[])userAttributeValue) {
                                        if (!object.equals(value)) continue;
                                        --count;
                                    }
                                    continue;
                                }
                                if (!value.equals(userAttributeValue)) continue;
                                --count;
                            }
                            boolean bl = match = count <= 0;
                        }
                    }
                    if (match) continue;
                    break;
                }
            }
            if (!match) continue;
            result.add(this.convertToRelationship(context, storedRelationship));
        }
        return result;
    }

    private boolean matchIdentityType(SecurityContext context, FileRelationship storedRelationship, RelationshipQuery<?> query, RelationshipQueryParameter identityTypeParameter, boolean matchExactGroup) {
        Object[] values = query.getParameter((QueryParameter)identityTypeParameter);
        int valuesMathCount = values.length;
        boolean match = false;
        try {
            IdentityType identityTypeRel = this.lookupIdentityTypeById(context, storedRelationship.getIdentityTypeId(identityTypeParameter.getName()));
            for (Object object : values) {
                IdentityType identityType = (IdentityType)object;
                if (!identityTypeRel.getClass().isInstance(identityType)) continue;
                if (identityTypeRel.getId().equals(identityType.getId())) {
                    --valuesMathCount;
                    continue;
                }
                if (!GroupMembership.class.isInstance(storedRelationship.getEntry()) && !GroupRole.class.isInstance(storedRelationship.getEntry()) || matchExactGroup || !Group.class.isInstance(identityTypeRel)) continue;
                Group groupParameter = (Group)identityType;
                Group groupFromRel = (Group)identityTypeRel;
                if (!groupParameter.getPath().contains(groupFromRel.getPath()) || !this.hasParentGroup(groupParameter, (Group)identityTypeRel)) continue;
                --valuesMathCount;
            }
            match = valuesMathCount <= 0;
        }
        catch (IdentityManagementException ignore) {
            // empty catch block
        }
        return match;
    }

    private IdentityType lookupIdentityTypeById(SecurityContext context, String identityTypeId) {
        if (identityTypeId == null) {
            throw IDMMessages.MESSAGES.nullArgument("AttributedType identifier");
        }
        IdentityType identityType = null;
        DefaultIdentityQuery<IdentityType> query = new DefaultIdentityQuery<IdentityType>(context, IdentityType.class, (IdentityStore<?>)this);
        query.setParameter(IdentityType.ID, new Object[]{identityTypeId});
        List results = query.getResultList();
        identityType = !results.isEmpty() ? (IdentityType)results.get(0) : context.getIdentityManager().lookupIdentityById(IdentityType.class, identityTypeId);
        if (identityType == null) {
            throw IDMMessages.MESSAGES.attributedTypeNotFoundWithId(IdentityType.class, identityTypeId, context.getPartition());
        }
        return identityType;
    }

    public void validateCredentials(SecurityContext context, Credentials credentials) {
        CredentialHandler handler = context.getCredentialValidator(credentials.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw IDMMessages.MESSAGES.credentialHandlerNotFoundForCredentialType(credentials.getClass());
        }
        handler.validate(context, credentials, (IdentityStore)this);
    }

    public void updateCredential(SecurityContext context, Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        CredentialHandler handler = context.getCredentialUpdater(credential.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw IDMMessages.MESSAGES.credentialHandlerNotFoundForCredentialType(credential.getClass());
        }
        handler.update(context, agent, credential, (IdentityStore)this, effectiveDate, expiryDate);
    }

    public void storeCredential(SecurityContext context, Agent agent, CredentialStorage storage) {
        List<FileCredentialStorage> credentials = this.getCredentials(context, agent, storage.getClass());
        FileCredentialStorage credential = new FileCredentialStorage();
        List annotatedTypes = PropertyQueries.createQuery(storage.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(Stored.class)).getResultList();
        for (Property property : annotatedTypes) {
            credential.getStoredFields().put(property.getName(), (Serializable)property.getValue((Object)storage));
        }
        if (credential.getEffectiveDate() == null) {
            credential.setEffectiveDate(new Date());
        }
        credentials.add(credential);
        this.flushCredentials(context);
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(SecurityContext context, Agent agent, Class<T> storageClass) {
        return CredentialUtils.getCurrentCredential(context, agent, this, storageClass);
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(SecurityContext context, Agent agent, Class<T> storageTyper) {
        ArrayList<T> storedCredentials = new ArrayList<T>();
        List<FileCredentialStorage> credentials = this.getCredentials(context, agent, storageTyper);
        for (FileCredentialStorage fileCredentialStorage : credentials) {
            storedCredentials.add(this.convertToCredentialStorage(storageTyper, fileCredentialStorage));
        }
        return storedCredentials;
    }

    public void removeCredentials(SecurityContext context, Agent agent) {
        this.getCredentialsForCurrentPartition(context).remove(agent.getLoginName());
        this.flushCredentials(context);
    }

    private <T extends CredentialStorage> T convertToCredentialStorage(Class<T> storageClass, FileCredentialStorage fileCredentialStorage) {
        CredentialStorage storage = null;
        try {
            storage = (CredentialStorage)storageClass.newInstance();
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.instantiationError(storageClass.getName(), (Throwable)e);
        }
        Set<Map.Entry<String, Serializable>> storedFields = fileCredentialStorage.getStoredFields().entrySet();
        for (Map.Entry<String, Serializable> storedField : storedFields) {
            List annotatedTypes = PropertyQueries.createQuery(storageClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{storedField.getKey()})).getResultList();
            if (annotatedTypes.isEmpty()) {
                throw new IdentityManagementException("Could not find property [" + storedField.getKey() + "] on CredentialStorage [" + storageClass.getName() + "].");
            }
            if (annotatedTypes.size() > 1) {
                throw new IdentityManagementException("Ambiguos property [" + storedField.getKey() + "] on CredentialStorage [" + storageClass.getName() + "].");
            }
            ((Property)annotatedTypes.get(0)).setValue((Object)storage, (Object)storedField.getValue());
        }
        return (T)storage;
    }

    private List<FileCredentialStorage> getCredentials(SecurityContext context, Agent agent, Class<? extends CredentialStorage> storageType) {
        List<FileCredentialStorage> credentials;
        Map<String, List<FileCredentialStorage>> agentCredentials = this.getCredentialsForCurrentPartition(context).get(agent.getLoginName());
        if (agentCredentials == null) {
            agentCredentials = new HashMap<String, List<FileCredentialStorage>>();
        }
        if ((credentials = agentCredentials.get(storageType.getName())) == null) {
            credentials = new ArrayList<FileCredentialStorage>();
        }
        agentCredentials.put(storageType.getName(), credentials);
        this.getCredentialsForCurrentPartition(context).put(agent.getLoginName(), agentCredentials);
        return credentials;
    }

    private Map<String, Map<String, List<FileCredentialStorage>>> getCredentialsForCurrentPartition(SecurityContext context) {
        Realm realm = (Realm)context.getPartition();
        return this.getDataSource().getCredentials(realm);
    }

    private void flushCredentials(SecurityContext context) {
        Realm realm = (Realm)context.getPartition();
        this.getDataSource().flushCredentials(realm);
    }
}

