/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.event.AgentCreatedEvent;
import org.picketlink.idm.event.AgentDeletedEvent;
import org.picketlink.idm.event.AgentUpdatedEvent;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.idm.spi.SecurityContext;

public class AgentHandler
extends IdentityTypeHandler<Agent> {
    public AgentHandler() {
        this.getSortParametersMapping().put(Agent.LOGIN_NAME, JPAIdentityStoreConfiguration.PropertyType.AGENT_LOGIN_NAME);
    }

    @Override
    protected void doPopulateIdentityInstance(SecurityContext context, Object toIdentity, Agent fromUser, JPAIdentityStore store) {
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        jpaConfig.setModelPropertyValue(toIdentity, JPAIdentityStoreConfiguration.PropertyType.AGENT_LOGIN_NAME, (Object)fromUser.getLoginName(), true);
        jpaConfig.setModelPropertyValue(toIdentity, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_PARTITION, store.lookupAndCreatePartitionObject(context, context.getPartition()), true);
    }

    @Override
    protected AbstractBaseEvent raiseCreatedEvent(Agent fromIdentityType) {
        return new AgentCreatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseUpdatedEvent(Agent fromIdentityType) {
        return new AgentUpdatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseDeletedEvent(Agent fromIdentityType) {
        return new AgentDeletedEvent(fromIdentityType);
    }

    @Override
    protected Agent doCreateIdentityType(SecurityContext context, Object identity, JPAIdentityStore store) {
        String loginName = store.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.AGENT_LOGIN_NAME).getValue(identity).toString();
        SimpleAgent agent = new SimpleAgent(loginName);
        return agent;
    }

    @Override
    public List<Predicate> getPredicate(SecurityContext context, JPACriteriaQueryBuilder criteria, JPAIdentityStore store) {
        List<Predicate> predicates = super.getPredicate(context, criteria, store);
        CriteriaBuilder builder = criteria.getBuilder();
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(Agent.LOGIN_NAME);
        if (parameterValues != null) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(store.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.AGENT_LOGIN_NAME).getName()), parameterValues[0]));
        }
        return predicates;
    }
}

