/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.util.Base64;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.DigestCredentialHandler;
import org.picketlink.idm.credential.internal.PasswordCredentialHandler;
import org.picketlink.idm.credential.internal.TOTPCredentialHandler;
import org.picketlink.idm.credential.internal.X509CertificateCredentialHandler;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.CredentialHandlers;
import org.picketlink.idm.credential.spi.annotations.Stored;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.jpa.annotations.IDMAttribute;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.IdentityTypeHandlerFactory;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.model.User;
import org.picketlink.idm.model.annotation.AttributeProperty;
import org.picketlink.idm.model.annotation.IdentityProperty;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.RelationshipQueryParameter;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.SecurityContext;

@CredentialHandlers(value={PasswordCredentialHandler.class, X509CertificateCredentialHandler.class, DigestCredentialHandler.class, TOTPCredentialHandler.class})
public class JPAIdentityStore
implements CredentialStore<JPAIdentityStoreConfiguration> {
    public static final String INVOCATION_CTX_ENTITY_MANAGER = "CTX_ENTITY_MANAGER";
    public static final String EVENT_CONTEXT_USER_ENTITY = "USER_ENTITY";
    public static final String EVENT_CONTEXT_GROUP_ENTITY = "GROUP_ENTITY";
    public static final String EVENT_CONTEXT_ROLE_ENTITY = "ROLE_ENTITY";
    private JPAIdentityStoreConfiguration config;

    public void setup(JPAIdentityStoreConfiguration config) {
        this.config = config;
    }

    public JPAIdentityStoreConfiguration getConfig() {
        return this.config;
    }

    public void add(SecurityContext context, AttributedType value) {
        if (value instanceof IdentityType) {
            this.checkIdentityTypeClassProvided();
            IdentityType identityType = (IdentityType)value;
            IdentityTypeHandler<IdentityType> handler = IdentityTypeHandlerFactory.getHandler(identityType.getClass());
            Object entity = handler.createEntity(context, identityType, this);
            EntityManager em = this.getEntityManager(context);
            em.persist(entity);
            em.flush();
            this.updateIdentityTypeAttributes(context, identityType, entity);
            AbstractBaseEvent event = handler.raiseCreatedEvent(identityType);
            event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, entity);
            context.getEventBridge().raiseEvent((Object)event);
        } else if (value instanceof Relationship) {
            this.checkRelationshipClassProvided();
            this.addRelationship(context, (Relationship)value);
        }
    }

    public void update(SecurityContext context, AttributedType attributedType) {
        if (attributedType instanceof IdentityType) {
            this.checkIdentityTypeClassProvided();
            IdentityType identityType = (IdentityType)attributedType;
            Object entity = this.lookupIdentityObjectById(context, identityType.getId());
            IdentityTypeHandler<IdentityType> handler = IdentityTypeHandlerFactory.getHandler(identityType.getClass());
            handler.populateEntity(context, entity, identityType, this);
            this.updateIdentityTypeAttributes(context, identityType, entity);
            EntityManager em = this.getEntityManager(context);
            em.merge(entity);
            em.flush();
            AbstractBaseEvent event = handler.raiseUpdatedEvent(identityType);
            event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, (Object)identityType);
            context.getEventBridge().raiseEvent((Object)event);
        } else if (attributedType instanceof Relationship) {
            this.checkRelationshipClassProvided();
            Relationship relationship = (Relationship)attributedType;
            Object entity = this.lookupRelationshipObjectById(context, relationship.getId());
            this.updateRelationshipAttributes(context, relationship, entity);
            EntityManager em = this.getEntityManager(context);
            em.merge(entity);
            em.flush();
        }
    }

    public void remove(SecurityContext context, AttributedType attributedType) {
        if (attributedType instanceof IdentityType) {
            this.checkIdentityTypeClassProvided();
            this.removeIdentityType(context, attributedType);
        } else if (attributedType instanceof Relationship) {
            this.checkRelationshipClassProvided();
            Relationship relationship = (Relationship)attributedType;
            this.removeRelationship(context, relationship);
        }
    }

    public User getUser(SecurityContext context, String loginName) {
        if (loginName == null) {
            return null;
        }
        DefaultIdentityQuery<User> defaultIdentityQuery = new DefaultIdentityQuery<User>(context, User.class, (IdentityStore<?>)this);
        defaultIdentityQuery.setParameter(User.LOGIN_NAME, loginName);
        List<User> resultList = defaultIdentityQuery.getResultList();
        User user = null;
        if (!resultList.isEmpty()) {
            user = resultList.get(0);
        }
        return user;
    }

    public Group getGroup(SecurityContext context, String groupPath) {
        if (groupPath == null) {
            return null;
        }
        if (!groupPath.startsWith("/")) {
            groupPath = "/" + groupPath;
        }
        DefaultIdentityQuery<Group> defaultIdentityQuery = new DefaultIdentityQuery<Group>(context, Group.class, (IdentityStore<?>)this);
        defaultIdentityQuery.setParameter(Group.PATH, groupPath);
        List<Group> resultList = defaultIdentityQuery.getResultList();
        Group group = null;
        if (!resultList.isEmpty()) {
            group = resultList.get(0);
        }
        return group;
    }

    public Group getGroup(SecurityContext context, String name, Group parent) {
        if (name == null || parent == null) {
            return null;
        }
        String path = "/" + name;
        if (parent != null) {
            Object storedParent = this.lookupIdentityObjectById(context, parent.getId());
            path = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.GROUP_PATH).getValue(storedParent) + path;
        }
        return this.getGroup(context, path);
    }

    public Role getRole(SecurityContext context, String name) {
        if (name == null) {
            return null;
        }
        DefaultIdentityQuery<Role> defaultIdentityQuery = new DefaultIdentityQuery<Role>(context, Role.class, (IdentityStore<?>)this);
        defaultIdentityQuery.setParameter(Role.NAME, name);
        List<Role> resultList = defaultIdentityQuery.getResultList();
        Role role = null;
        if (!resultList.isEmpty()) {
            role = resultList.get(0);
        }
        return role;
    }

    public Agent getAgent(SecurityContext context, String loginName) {
        if (loginName == null) {
            return null;
        }
        DefaultIdentityQuery<Agent> defaultIdentityQuery = new DefaultIdentityQuery<Agent>(context, Agent.class, (IdentityStore<?>)this);
        defaultIdentityQuery.setParameter(Agent.LOGIN_NAME, loginName);
        List<Agent> resultList = defaultIdentityQuery.getResultList();
        Object agent = null;
        agent = !resultList.isEmpty() ? resultList.get(0) : this.getUser(context, loginName);
        return agent;
    }

    public <T extends Relationship> List<T> fetchQueryResults(SecurityContext context, RelationshipQuery<T> query) {
        return this.fetchQueryResults(context, query, false);
    }

    public <T extends IdentityType> List<T> fetchQueryResults(SecurityContext context, IdentityQuery<T> identityQuery) {
        ArrayList<T> result = new ArrayList<T>();
        EntityManager em = this.getEntityManager(context);
        JPACriteriaQueryBuilder criteriaBuilder = new JPACriteriaQueryBuilder(context, this, identityQuery);
        List<Predicate> predicates = criteriaBuilder.getPredicates(context);
        CriteriaQuery<?> criteria = criteriaBuilder.getCriteria();
        List<Order> orders = criteriaBuilder.getOrders();
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        criteria.orderBy(orders);
        TypedQuery query = em.createQuery(criteria);
        if (identityQuery.getLimit() > 0) {
            query.setMaxResults(identityQuery.getLimit());
            if (identityQuery.getOffset() > 0) {
                query.setFirstResult(identityQuery.getOffset());
            }
        }
        List queryResult = query.getResultList();
        for (Object identity : queryResult) {
            T identityType = this.convertToIdentityType(context, identity);
            result.add(identityType);
        }
        return result;
    }

    public <T extends IdentityType> int countQueryResults(SecurityContext context, IdentityQuery<T> identityQuery) {
        int limit = identityQuery.getLimit();
        int offset = identityQuery.getOffset();
        identityQuery.setLimit(0);
        identityQuery.setOffset(0);
        int resultCount = identityQuery.getResultList().size();
        identityQuery.setLimit(limit);
        identityQuery.setOffset(offset);
        return resultCount;
    }

    public <T extends Relationship> int countQueryResults(SecurityContext context, RelationshipQuery<T> query) {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(SecurityContext context, IdentityType identity, Attribute<? extends Serializable> attribute) {
        Serializable value = attribute.getValue();
        if (value != null) {
            Property attributeNameProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.ATTRIBUTE_NAME);
            Property attributeIdentityProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.ATTRIBUTE_IDENTITY);
            Property attributeValueProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.ATTRIBUTE_VALUE);
            List<?> storedAttributes = this.findIdentityTypeAttributes(context, identity, attribute.getName());
            if (storedAttributes.isEmpty()) {
                Serializable[] values = null;
                values = value.getClass().isArray() ? (Serializable[])value : new Serializable[]{value};
                Object entity = this.lookupIdentityObjectById(context, identity.getId());
                for (Serializable attribValue : values) {
                    Object newAttribute = null;
                    try {
                        newAttribute = this.getConfig().getAttributeClass().newInstance();
                    }
                    catch (Exception e) {
                        throw IDMMessages.MESSAGES.instantiationError(this.getConfig().getAttributeClass().getName(), (Throwable)e);
                    }
                    attributeNameProperty.setValue(newAttribute, (Object)attribute.getName());
                    attributeValueProperty.setValue(newAttribute, (Object)Base64.encodeObject((Serializable)attribValue));
                    attributeIdentityProperty.setValue(newAttribute, entity);
                    this.getEntityManager(context).persist(newAttribute);
                }
            } else {
                this.removeAttribute(context, identity, attribute.getName());
                this.setAttribute(context, identity, attribute);
            }
        }
    }

    public void removeAttribute(SecurityContext context, IdentityType identity, String name) {
        List<?> storedAttributes = this.findIdentityTypeAttributes(context, identity, name);
        for (Object storedAttribute : storedAttributes) {
            this.getEntityManager(context).remove(storedAttribute);
        }
    }

    public <T extends Serializable> Attribute<T> getAttribute(SecurityContext context, IdentityType identityType, String attributeName) {
        List<?> attributes = this.findIdentityTypeAttributes(context, identityType, attributeName);
        this.populateAttributes(identityType, attributes);
        return identityType.getAttribute(attributeName);
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(SecurityContext context, Agent agent, Class<T> storageClass) {
        this.checkCredentialClassProvided();
        Property identityTypeProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_IDENTITY);
        Property typeProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_TYPE);
        EntityManager em = this.getEntityManager(context);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getCredentialClass());
        Root root = criteria.from(this.getConfig().getCredentialClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Object agentInstance = this.lookupIdentityObjectById(context, agent.getId());
        predicates.add(builder.equal((Expression)root.get(identityTypeProperty.getName()), agentInstance));
        predicates.add(builder.equal((Expression)root.get(typeProperty.getName()), (Object)storageClass.getName()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List result = em.createQuery(criteria).getResultList();
        ArrayList<T> storages = new ArrayList<T>();
        for (Object object : result) {
            storages.add(this.convertToCredentialStorage(context, object, storageClass));
        }
        return storages;
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(SecurityContext context, Agent agent, Class<T> storageClass) {
        this.checkCredentialClassProvided();
        return this.convertToCredentialStorage(context, this.retrieveLastCredentialEntity(context, agent, storageClass), storageClass);
    }

    public void storeCredential(SecurityContext context, Agent agent, CredentialStorage storage) {
        this.checkCredentialClassProvided();
        Property expiryProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_EXPIRY_DATE);
        Object newCredential = null;
        try {
            newCredential = this.getConfig().getCredentialClass().newInstance();
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.instantiationError(this.getConfig().getCredentialClass().getName(), (Throwable)e);
        }
        Date effectiveDate = storage.getEffectiveDate();
        if (effectiveDate == null) {
            effectiveDate = new Date();
        }
        Object agentInstance = this.lookupIdentityObjectById(context, agent.getId());
        Property identityTypeProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_IDENTITY);
        Property typeProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_TYPE);
        Property effectiveProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_EFFECTIVE_DATE);
        identityTypeProperty.setValue(newCredential, agentInstance);
        typeProperty.setValue(newCredential, (Object)storage.getClass().getName());
        effectiveProperty.setValue(newCredential, (Object)effectiveDate);
        expiryProperty.setValue(newCredential, (Object)storage.getExpiryDate());
        EntityManager em = this.getEntityManager(context);
        em.persist(newCredential);
        List annotatedTypes = PropertyQueries.createQuery(storage.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(Stored.class)).getResultList();
        Property attributeName = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_ATTRIBUTE_NAME);
        Property attributeValue = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_ATTRIBUTE_VALUE);
        Property attributeCredential = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_ATTRIBUTE_CREDENTIAL);
        for (Property property : annotatedTypes) {
            Object newCredentialAttribute = null;
            try {
                newCredentialAttribute = this.getConfig().getCredentialAttributeClass().newInstance();
            }
            catch (Exception e) {
                throw IDMMessages.MESSAGES.instantiationError(this.getConfig().getCredentialAttributeClass().getName(), (Throwable)e);
            }
            attributeName.setValue(newCredentialAttribute, (Object)property.getName());
            attributeValue.setValue(newCredentialAttribute, (Object)Base64.encodeObject((Serializable)((Serializable)property.getValue((Object)storage))));
            attributeCredential.setValue(newCredentialAttribute, newCredential);
            em.persist(newCredentialAttribute);
        }
        em.flush();
    }

    public void updateCredential(SecurityContext context, Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        CredentialHandler handler = context.getCredentialUpdater(credential.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw IDMMessages.MESSAGES.credentialHandlerNotFoundForCredentialType(credential.getClass());
        }
        handler.update(context, agent, credential, (IdentityStore)this, effectiveDate, expiryDate);
    }

    public void validateCredentials(SecurityContext context, Credentials credentials) {
        CredentialHandler handler = context.getCredentialValidator(credentials.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw IDMMessages.MESSAGES.credentialHandlerNotFoundForCredentialType(credentials.getClass());
        }
        handler.validate(context, credentials, (IdentityStore)this);
    }

    protected Partition convertPartitionEntityToPartition(Object partitionObject) {
        this.checkPartitionClassProvided();
        Property typeProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.PARTITION_TYPE);
        String type = typeProperty.getValue(partitionObject).toString();
        Realm partition = null;
        if (Realm.class.getName().equals(type)) {
            partition = this.convertPartitionEntityToRealm(partitionObject);
        } else if (Tier.class.getName().equals(type)) {
            partition = this.convertPartitionEntityToTier(partitionObject);
        } else {
            throw IDMMessages.MESSAGES.partitionUnsupportedType(type);
        }
        return partition;
    }

    protected EntityManager getEntityManager(SecurityContext context) {
        if (!context.isParameterSet(INVOCATION_CTX_ENTITY_MANAGER)) {
            throw IDMMessages.MESSAGES.jpaStoreCouldNotGetEntityManagerFromStoreContext();
        }
        return (EntityManager)context.getParameter(INVOCATION_CTX_ENTITY_MANAGER);
    }

    protected Object lookupIdentityObjectById(SecurityContext context, String id) {
        if (id == null) {
            return null;
        }
        EntityManager em = this.getEntityManager(context);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getIdentityClass());
        Root root = criteria.from(this.getConfig().getIdentityClass());
        ArrayList<Object> predicates = new ArrayList<Object>();
        Join join = root.join(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_PARTITION).getName());
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ID).getName()), (Object)id));
        List<String> partitionIds = this.getAllowedPartitionIds(context, context.getPartition());
        predicates.add(builder.in((Expression)join.get(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.PARTITION_ID).getName())).value(partitionIds));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(criteria).getResultList();
        if (results.isEmpty()) {
            throw IDMMessages.MESSAGES.attributedTypeNotFoundWithId(IdentityType.class, id, context.getPartition());
        }
        return results.get(0);
    }

    protected Object lookupAndCreatePartitionObject(SecurityContext context, Partition partition) {
        this.checkPartitionClassProvided();
        EntityManager entityManager = this.getEntityManager(context);
        Object partitionObject = entityManager.find(this.getConfig().getPartitionClass(), (Object)partition.getId());
        if (partitionObject == null) {
            try {
                partitionObject = this.getConfig().getPartitionClass().newInstance();
                this.getConfig().setModelPropertyValue(partitionObject, JPAIdentityStoreConfiguration.PropertyType.PARTITION_ID, (Object)partition.getId(), true);
                this.getConfig().setModelPropertyValue(partitionObject, JPAIdentityStoreConfiguration.PropertyType.PARTITION_TYPE, (Object)partition.getClass().getName(), true);
                entityManager.persist(partitionObject);
                entityManager.flush();
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error creating Partition [" + partition + "].", (Throwable)e);
            }
        }
        return partitionObject;
    }

    protected List<String> getAllowedPartitionIds(SecurityContext context, Partition currentPartition) {
        ArrayList<String> partitionIds = new ArrayList<String>();
        partitionIds.add(context.getPartition().getId());
        if (currentPartition != null) {
            partitionIds.add(currentPartition.getId());
        }
        return partitionIds;
    }

    private <T extends Relationship> T convertToRelationshipType(SecurityContext context, Object relationshipObject) {
        Relationship relationshipType;
        Class<?> relationshipClass;
        Property identityProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_IDENTITY);
        Property idProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ID);
        Property descriptorProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_DESCRIPTOR);
        Property typeProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_CLASS);
        String typeName = typeProperty.getValue(relationshipObject).toString();
        try {
            relationshipClass = Class.forName(typeName);
            relationshipType = (Relationship)relationshipClass.newInstance();
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.instantiationError(typeName, (Throwable)e);
        }
        List identityTypeIdProperty = PropertyQueries.createQuery(relationshipClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{"id"})).getResultList();
        ((Property)identityTypeIdProperty.get(0)).setValue((Object)relationshipType, idProperty.getValue(relationshipObject));
        List<?> identities = this.findChildRelationships(context, relationshipType);
        for (Object object : identities) {
            String descriptor = descriptorProperty.getValue(object).toString();
            List identityTypeProperty = PropertyQueries.createQuery(relationshipClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{descriptor})).getResultList();
            IdentityType identityType = null;
            identityType = identityProperty.getJavaClass().equals(String.class) ? context.getIdentityManager().lookupIdentityById(IdentityType.class, identityProperty.getValue(object).toString()) : (IdentityType)this.convertToIdentityType(context, identityProperty.getValue(object));
            ((Property)identityTypeProperty.get(0)).setValue((Object)relationshipType, (Object)identityType);
        }
        this.populateRelationshipAttributes(context, relationshipType, relationshipObject);
        return (T)relationshipType;
    }

    private <T extends IdentityType> T convertToIdentityType(SecurityContext context, Object entity) {
        String discriminator = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_DISCRIMINATOR).getValue(entity).toString();
        IdentityTypeHandler<IdentityType> identityTypeManager = IdentityTypeHandlerFactory.getHandler(this.getConfig().getIdentityTypeFromDiscriminator(discriminator));
        IdentityType identityType = identityTypeManager.createIdentityType(context, entity, this);
        this.populateIdentityTypeAttributes(context, identityType, entity);
        return (T)identityType;
    }

    private void storeRelationshipAttribute(SecurityContext context, Object identity, Attribute<? extends Serializable> userAttribute) {
        Serializable value = userAttribute.getValue();
        Serializable[] values = null;
        values = value.getClass().isArray() ? (Serializable[])value : new Serializable[]{value};
        Property attributeNameProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ATTRIBUTE_NAME);
        Property attributeIdentityProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ATTRIBUTE_RELATIONSHIP);
        Property attributeValueProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ATTRIBUTE_VALUE);
        for (Serializable attribValue : values) {
            Object newInstance = null;
            try {
                newInstance = this.getConfig().getRelationshipAttributeClass().newInstance();
            }
            catch (Exception e) {
                throw IDMMessages.MESSAGES.instantiationError(this.getConfig().getRelationshipAttributeClass().getName(), (Throwable)e);
            }
            attributeNameProperty.setValue(newInstance, (Object)userAttribute.getName());
            attributeValueProperty.setValue(newInstance, (Object)Base64.encodeObject((Serializable)attribValue));
            attributeIdentityProperty.setValue(newInstance, identity);
            this.getEntityManager(context).persist(newInstance);
        }
    }

    private void removeAttributes(SecurityContext context, Relationship relationship, Object identity) {
        List<?> storedAttributes = this.findRelationshipAttributes(context, identity);
        for (Object attribute : storedAttributes) {
            String attributeName = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ATTRIBUTE_NAME).getValue(attribute).toString();
            if (relationship.getAttribute(attributeName) != null) continue;
            this.getEntityManager(context).remove(attribute);
        }
    }

    private void removeAttributes(SecurityContext context, IdentityType identityType, Object identity) {
        List<?> storedAttributes = this.findAllIdentityTypeAttributes(context, identity);
        for (Object attribute : storedAttributes) {
            String attributeName = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.ATTRIBUTE_NAME).getValue(attribute).toString();
            if (identityType.getAttribute(attributeName) != null) continue;
            this.getEntityManager(context).remove(attribute);
        }
    }

    private List<?> findIdentityTypeAttributes(SecurityContext context, IdentityType identityType, String name) {
        if (identityType.getId() == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType identifier");
        }
        EntityManager em = this.getEntityManager(context);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getAttributeClass());
        Root root = criteria.from(this.getConfig().getAttributeClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Property attributeIdentityProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.ATTRIBUTE_IDENTITY);
        Join join = root.join(attributeIdentityProperty.getName());
        predicates.add(builder.equal((Expression)join.get(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ID).getName()), (Object)identityType.getId()));
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.ATTRIBUTE_NAME).getName()), (Object)name));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private List<?> findRelationshipAttributes(SecurityContext context, Relationship relationship, Attribute<? extends Serializable> attribute) {
        Property attributeIdentityProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP);
        EntityManager em = this.getEntityManager(context);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getRelationshipAttributeClass());
        Root root = criteria.from(this.getConfig().getRelationshipAttributeClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Join join = root.join(attributeIdentityProperty.getName());
        predicates.add(builder.equal((Expression)join.get(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ID).getName()), (Object)relationship.getId()));
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ATTRIBUTE_NAME).getName()), (Object)attribute.getName()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private List<?> findAllIdentityTypeAttributes(SecurityContext context, Object object) {
        Class attributeClass = this.getConfig().getAttributeClass();
        String identityProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.ATTRIBUTE_IDENTITY).getName();
        EntityManager em = this.getEntityManager(context);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(attributeClass);
        Root root = criteria.from(attributeClass);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(identityProperty), object));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private List<?> findRelationshipAttributes(SecurityContext context, Object object) {
        Class attributeClass = this.getConfig().getRelationshipAttributeClass();
        String identityProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ATTRIBUTE_RELATIONSHIP).getName();
        EntityManager em = this.getEntityManager(context);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(attributeClass);
        Root root = criteria.from(attributeClass);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(identityProperty), object));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private Object lookupRelationshipObjectById(SecurityContext context, String id) {
        if (id == null) {
            return null;
        }
        EntityManager em = this.getEntityManager(context);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getRelationshipClass());
        Root root = criteria.from(this.getConfig().getRelationshipClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ID).getName()), (Object)id));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(criteria).getResultList();
        if (results.isEmpty()) {
            throw IDMMessages.MESSAGES.attributedTypeNotFoundWithId(Relationship.class, id, context.getPartition());
        }
        return results.get(0);
    }

    private void removeIdentityTypeRelationships(SecurityContext context, Object entity) {
        if (this.getConfig().getRelationshipClass() != null) {
            List<?> relationshipsToRemove = this.findIdentityTypeRelationships(context, (String)this.getConfig().getModelPropertyValue(String.class, entity, JPAIdentityStoreConfiguration.PropertyType.IDENTITY_ID));
            for (Object relationship : relationshipsToRemove) {
                this.remove(context, (AttributedType)this.convertToRelationshipType(context, relationship));
            }
        }
    }

    private List<?> findIdentityTypeRelationships(SecurityContext context, String identityTypeId) {
        EntityManager em = this.getEntityManager(context);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getRelationshipIdentityClass());
        Root root = criteria.from(this.getConfig().getRelationshipIdentityClass());
        Property identityTypeProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_IDENTITY);
        if (identityTypeProperty.getJavaClass().equals(String.class)) {
            criteria.where((Expression)builder.equal((Expression)root.get(identityTypeProperty.getName()), (Object)identityTypeId));
        } else {
            criteria.where((Expression)builder.equal((Expression)root.get(identityTypeProperty.getName()), this.lookupIdentityObjectById(context, identityTypeId)));
        }
        ArrayList<Object> relationships = new ArrayList<Object>();
        List result = em.createQuery(criteria).getResultList();
        for (Object object : result) {
            relationships.add(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP).getValue(object));
        }
        return relationships;
    }

    private void removeIdentityTypeAttributes(SecurityContext context, Object object) {
        EntityManager em = this.getEntityManager(context);
        if (this.getConfig().getAttributeClass() != null) {
            List<?> results = this.findAllIdentityTypeAttributes(context, object);
            for (Object result : results) {
                em.remove(result);
            }
        }
    }

    private void updateIdentityTypeAttributes(SecurityContext context, IdentityType identityType, Object entity) {
        if (this.getConfig().supportsFeature(FeatureSet.FeatureGroup.attribute, null)) {
            Collection attributes = identityType.getAttributes();
            if (attributes != null) {
                for (Attribute attribute : attributes) {
                    this.setAttribute(context, identityType, (Attribute<? extends Serializable>)attribute);
                }
            }
            this.removeAttributes(context, identityType, entity);
        }
    }

    private void updateRelationshipAttributes(SecurityContext context, Relationship relationship, Object identity) {
        List attributeProperties = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(AttributeProperty.class)).getResultList();
        for (Property attributeProperty : attributeProperties) {
            relationship.setAttribute(new Attribute(attributeProperty.getName(), (Serializable)attributeProperty.getValue((Object)relationship)));
        }
        Collection attributes = relationship.getAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            EntityManager em = this.getEntityManager(context);
            for (Attribute attribute : attributes) {
                List<?> results = this.findRelationshipAttributes(context, relationship, (Attribute<? extends Serializable>)attribute);
                for (Object object : results) {
                    em.remove(object);
                }
                this.storeRelationshipAttribute(context, identity, (Attribute<? extends Serializable>)attribute);
            }
            this.removeAttributes(context, relationship, identity);
        }
    }

    private void populateIdentityTypeAttributes(SecurityContext context, IdentityType identityType, Object entity) {
        for (JPAIdentityStoreConfiguration.MappedAttribute attrib : this.getConfig().getAttributeProperties().values()) {
            Member member = attrib.getAttributeProperty().getMember();
            String mappedName = null;
            Object value = null;
            if (member instanceof Field) {
                Field field = (Field)member;
                IDMAttribute annotation = field.getAnnotation(IDMAttribute.class);
                field.setAccessible(true);
                mappedName = annotation.name();
                try {
                    value = field.get(entity);
                }
                catch (IllegalAccessException e) {
                    throw new IdentityManagementException("Could not get value from field [" + field + "].", (Throwable)e);
                }
            }
            identityType.setAttribute(new Attribute(mappedName, (Serializable)value));
        }
        if (this.getConfig().getAttributeClass() != null) {
            List<?> attributes = this.findAllIdentityTypeAttributes(context, entity);
            this.populateAttributes(identityType, attributes);
        }
    }

    private void populateAttributes(IdentityType identityType, List<?> attributes) {
        for (Object object : attributes) {
            Property attributeNameProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.ATTRIBUTE_NAME);
            Property attributeValueProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.ATTRIBUTE_VALUE);
            String attributeName = attributeNameProperty.getValue(object).toString();
            Attribute attribute = identityType.getAttribute(attributeName);
            Serializable attribValue = (Serializable)Base64.decodeToObject((String)attributeValueProperty.getValue(object).toString());
            if (attribute == null) {
                attribute = new Attribute(attributeName, attribValue);
            } else if (attribute != null) {
                Serializable[] values = null;
                if (attribute.getValue().getClass().isArray()) {
                    values = (Serializable[])attribute.getValue();
                } else {
                    values = (Serializable[])Array.newInstance(attribute.getValue().getClass(), 1);
                    values[0] = attribute.getValue();
                }
                Serializable[] newValues = Arrays.copyOf(values, values.length + 1);
                newValues[newValues.length - 1] = attribValue;
                attribute.setValue((Serializable)newValues);
            }
            identityType.setAttribute(attribute);
        }
    }

    private void populateRelationshipAttributes(SecurityContext context, Relationship relationshipType, Object relationship) {
        List<?> results;
        if (this.getConfig().getRelationshipAttributeClass() != null && !(results = this.findRelationshipAttributes(context, relationship)).isEmpty()) {
            for (Object object : results) {
                Property attributeNameProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ATTRIBUTE_NAME);
                Property attributeValueProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ATTRIBUTE_VALUE);
                String attribName = (String)attributeNameProperty.getValue(object);
                Serializable attribValue = (Serializable)Base64.decodeToObject((String)attributeValueProperty.getValue(object).toString());
                List attributeProperties = PropertyQueries.createQuery(relationshipType.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(AttributeProperty.class)).getResultList();
                Property relationshipAttributeProperty = null;
                for (Property attributeProperty : attributeProperties) {
                    String propertyName = attributeProperty.getName();
                    if (!propertyName.equals(attribName)) continue;
                    relationshipAttributeProperty = attributeProperty;
                    break;
                }
                if (relationshipAttributeProperty != null) {
                    relationshipAttributeProperty.setValue((Object)relationshipType, (Object)attribValue);
                    continue;
                }
                Attribute identityTypeAttribute = relationshipType.getAttribute(attribName);
                if (identityTypeAttribute == null) {
                    identityTypeAttribute = new Attribute(attribName, attribValue);
                    relationshipType.setAttribute(identityTypeAttribute);
                    continue;
                }
                if (identityTypeAttribute.getValue() == null) continue;
                Serializable[] values = null;
                if (identityTypeAttribute.getValue().getClass().isArray()) {
                    values = (Serializable[])identityTypeAttribute.getValue();
                } else {
                    values = (Serializable[])Array.newInstance(attribValue.getClass(), 1);
                    values[0] = identityTypeAttribute.getValue();
                }
                Serializable[] newValues = Arrays.copyOf(values, values.length + 1);
                newValues[newValues.length - 1] = attribValue;
                identityTypeAttribute.setValue((Serializable)newValues);
                relationshipType.setAttribute(identityTypeAttribute);
            }
        }
    }

    private void addRelationship(SecurityContext context, Relationship relationship) {
        relationship.setId(context.getIdGenerator().generate());
        Object entity = null;
        try {
            entity = this.getConfig().getRelationshipClass().newInstance();
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.instantiationError(this.getConfig().getRelationshipClass().getName(), (Throwable)e);
        }
        this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ID).setValue(entity, (Object)relationship.getId());
        this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_CLASS).setValue(entity, (Object)relationship.getClass().getName());
        List props = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(IdentityProperty.class)).getResultList();
        EntityManager em = this.getEntityManager(context);
        em.persist(entity);
        for (Property prop : props) {
            Object relationshipIdentity = null;
            try {
                relationshipIdentity = this.getConfig().getRelationshipIdentityClass().newInstance();
            }
            catch (Exception e) {
                throw IDMMessages.MESSAGES.instantiationError(this.getConfig().getRelationshipIdentityClass().getName(), (Throwable)e);
            }
            IdentityType identityType = (IdentityType)prop.getValue((Object)relationship);
            if (identityType != null) {
                Object identityObject = null;
                try {
                    identityObject = this.lookupIdentityObjectById(context, identityType.getId());
                }
                catch (IdentityManagementException ignore) {
                    // empty catch block
                }
                Property identityTypeProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_IDENTITY);
                if (identityTypeProperty.getJavaClass().equals(String.class)) {
                    this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_IDENTITY).setValue(relationshipIdentity, (Object)identityType.getId());
                } else {
                    this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_IDENTITY).setValue(relationshipIdentity, identityObject);
                }
                this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_DESCRIPTOR).setValue(relationshipIdentity, (Object)prop.getName());
                this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP).setValue(relationshipIdentity, entity);
            }
            em.persist(relationshipIdentity);
        }
        this.updateRelationshipAttributes(context, relationship, entity);
        em.flush();
    }

    private void removeIdentityType(SecurityContext context, AttributedType value) {
        IdentityType identityType = (IdentityType)value;
        Object entity = this.lookupIdentityObjectById(context, identityType.getId());
        EntityManager em = this.getEntityManager(context);
        IdentityTypeHandler<IdentityType> handler = IdentityTypeHandlerFactory.getHandler(identityType.getClass());
        handler.remove(context, entity, identityType, this);
        this.removeCredentials(context, entity);
        this.removeIdentityTypeAttributes(context, entity);
        this.removeIdentityTypeRelationships(context, entity);
        em.remove(entity);
        em.flush();
        AbstractBaseEvent event = handler.raiseDeletedEvent(identityType);
        event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, entity);
        context.getEventBridge().raiseEvent((Object)event);
    }

    private void removeRelationship(SecurityContext context, Relationship relationship) {
        Object[] attributes;
        if (relationship.getId() == null) {
            DefaultRelationshipQuery<GroupRole> query = null;
            if (GroupRole.class.isInstance(relationship)) {
                GroupRole groupRole = (GroupRole)relationship;
                query = new DefaultRelationshipQuery<GroupRole>(context, GroupRole.class, (IdentityStore<?>)this);
                query.setParameter((QueryParameter)GroupRole.ASSIGNEE, groupRole.getAssignee());
                query.setParameter((QueryParameter)GroupRole.GROUP, groupRole.getGroup());
                query.setParameter((QueryParameter)GroupRole.ROLE, groupRole.getRole());
            } else if (Grant.class.isInstance(relationship)) {
                Grant grant = (Grant)relationship;
                query = new DefaultRelationshipQuery<Grant>(context, Grant.class, (IdentityStore<?>)this);
                query.setParameter((QueryParameter)Grant.ASSIGNEE, grant.getAssignee());
                query.setParameter((QueryParameter)Grant.ROLE, grant.getRole());
            } else if (GroupMembership.class.isInstance(relationship)) {
                GroupMembership groupMembership = (GroupMembership)relationship;
                query = new DefaultRelationshipQuery<GroupMembership>(context, GroupMembership.class, (IdentityStore<?>)this);
                query.setParameter((QueryParameter)GroupMembership.MEMBER, groupMembership.getMember());
                query.setParameter((QueryParameter)GroupMembership.GROUP, groupMembership.getGroup());
            }
            List<GroupRole> result = this.fetchQueryResults(context, query, true);
            if (result.size() == 1) {
                relationship = (Relationship)result.get(0);
            } else if (result.size() > 1) {
                throw IDMMessages.MESSAGES.relationshipAmbiguosFound(relationship);
            }
        }
        Object entity = this.lookupRelationshipObjectById(context, relationship.getId());
        List<?> childRelationships = this.findChildRelationships(context, relationship);
        EntityManager em = this.getEntityManager(context);
        for (Object object : childRelationships) {
            em.remove(object);
        }
        for (Object object : attributes = relationship.getAttributes().toArray()) {
            Attribute attribute = (Attribute)object;
            relationship.removeAttribute(attribute.getName());
        }
        this.removeAttributes(context, relationship, entity);
        em.remove(entity);
        em.flush();
    }

    private List<?> findChildRelationships(SecurityContext context, Relationship relationship) {
        EntityManager em = this.getEntityManager(context);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getRelationshipIdentityClass());
        Root root = criteria.from(this.getConfig().getRelationshipIdentityClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Join join = root.join(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP).getName());
        predicates.add(builder.equal((Expression)join.get(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ID).getName()), (Object)relationship.getId()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private <T extends Relationship> List<T> fetchQueryResults(SecurityContext context, RelationshipQuery<T> query, boolean matchExactGroup) {
        ArrayList<T> result = new ArrayList<T>();
        EntityManager em = this.getEntityManager(context);
        List<Object> queryResult = new ArrayList();
        Object[] identityParameterValues = query.getParameter(Relationship.IDENTITY);
        if (identityParameterValues != null) {
            for (Object parameterValue : identityParameterValues) {
                String identityId = null;
                if (String.class.isInstance(parameterValue)) {
                    identityId = (String)parameterValue;
                } else if (IdentityType.class.isInstance(parameterValue)) {
                    IdentityType identityType = (IdentityType)parameterValue;
                    identityId = identityType.getId();
                } else {
                    throw IDMMessages.MESSAGES.queryUnsupportedParameterValue("Relationship.IDENTITY", parameterValue);
                }
                queryResult = this.findIdentityTypeRelationships(context, identityId);
            }
        } else {
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(this.getConfig().getRelationshipClass());
            Root root = criteria.from(this.getConfig().getRelationshipClass());
            ArrayList<Object> predicates = new ArrayList<Object>();
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_CLASS).getName()), (Object)query.getRelationshipType().getName()));
            Property identityProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_IDENTITY);
            Property descriptorProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_DESCRIPTOR);
            Property relationshipProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP);
            Set parameters = query.getParameters().entrySet();
            for (Map.Entry entry : parameters) {
                QueryParameter queryParameter = (QueryParameter)entry.getKey();
                Object[] values = (Object[])entry.getValue();
                if (entry.getKey() instanceof RelationshipQueryParameter) {
                    RelationshipQueryParameter identityTypeParameter = (RelationshipQueryParameter)entry.getKey();
                    for (Object object : values) {
                        Predicate conjunction;
                        Subquery subquery;
                        IdentityType identityType = (IdentityType)object;
                        identityType = context.getIdentityManager().lookupIdentityById(identityType.getClass(), identityType.getId());
                        if (identityType != null) {
                            ArrayList<String> objects = new ArrayList<String>();
                            objects.add(identityType.getId());
                            if (Group.class.isInstance(identityType) && !matchExactGroup) {
                                List<Group> groupParents = this.getParentGroups(context, (Group)identityType);
                                for (Group group : groupParents) {
                                    objects.add(group.getId());
                                }
                            }
                            subquery = criteria.subquery(this.getConfig().getRelationshipIdentityClass());
                            Root fromProject = subquery.from(this.getConfig().getRelationshipIdentityClass());
                            subquery.select((Expression)fromProject.get(relationshipProperty.getName()));
                            conjunction = builder.conjunction();
                            conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(descriptorProperty.getName()), (Object)identityTypeParameter.getName()));
                            if (identityProperty.getJavaClass().equals(String.class)) {
                                conjunction.getExpressions().add(builder.in((Expression)fromProject.get(identityProperty.getName())).value(objects));
                            } else {
                                ArrayList<Object> identityObjects = new ArrayList<Object>();
                                for (String id : objects) {
                                    identityObjects.add(this.lookupIdentityObjectById(context, id));
                                }
                                conjunction.getExpressions().add(builder.in((Expression)fromProject.get(identityProperty.getName())).value(identityObjects));
                            }
                        } else {
                            return result;
                        }
                        subquery.where((Expression)conjunction);
                        predicates.add(builder.in((Expression)root).value((Expression)subquery));
                    }
                }
                if (!(queryParameter instanceof AttributedType.AttributeParameter)) continue;
                AttributedType.AttributeParameter customParameter = (AttributedType.AttributeParameter)queryParameter;
                Subquery subquery = criteria.subquery(this.getConfig().getRelationshipAttributeClass());
                Root fromProject = subquery.from(this.getConfig().getRelationshipAttributeClass());
                subquery.select((Expression)fromProject.get(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ATTRIBUTE_RELATIONSHIP).getName()));
                Predicate conjunction = builder.conjunction();
                Serializable[] valuesToSearch = new Serializable[values.length];
                for (int i = 0; i < values.length; ++i) {
                    valuesToSearch[i] = Base64.encodeObject((Serializable)((Serializable)values[i]));
                }
                conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ATTRIBUTE_NAME).getName()), (Object)customParameter.getName()));
                conjunction.getExpressions().add(fromProject.get(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.RELATIONSHIP_ATTRIBUTE_VALUE).getName()).in((Object[])valuesToSearch));
                subquery.where((Expression)conjunction);
                subquery.groupBy(new Expression[]{subquery.getSelection()}).having((Expression)builder.equal(builder.count(subquery.getSelection()), (Object)valuesToSearch.length));
                predicates.add(builder.in((Expression)root).value((Expression)subquery));
            }
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            queryResult = em.createQuery(criteria).getResultList();
        }
        for (Object relationshipObject : queryResult) {
            result.add(this.convertToRelationshipType(context, relationshipObject));
        }
        return result;
    }

    private List<Group> getParentGroups(SecurityContext context, Group identityType) {
        IdentityQuery query = context.getIdentityManager().createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{identityType});
        return query.getResultList();
    }

    private Realm convertPartitionEntityToRealm(Object partitionObject) {
        Realm realm = null;
        if (partitionObject != null) {
            Property typeProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.PARTITION_TYPE);
            if (Realm.class.getName().equals(typeProperty.getValue(partitionObject).toString())) {
                Property idProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.PARTITION_ID);
                realm = new Realm(idProperty.getValue(partitionObject).toString());
            }
        }
        return realm;
    }

    private Tier convertPartitionEntityToTier(Object partitionObject) {
        Tier tier = null;
        if (partitionObject != null) {
            Property typeProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.PARTITION_TYPE);
            if (Tier.class.getName().equals(typeProperty.getValue(partitionObject).toString())) {
                Property idProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.PARTITION_ID);
                tier = new Tier(idProperty.getValue(partitionObject).toString());
            }
        }
        return tier;
    }

    private <T extends CredentialStorage> T convertToCredentialStorage(SecurityContext context, Object instance, Class<T> storageClass) {
        CredentialStorage storage = null;
        if (instance != null) {
            try {
                storage = (CredentialStorage)storageClass.newInstance();
            }
            catch (Exception e) {
                throw IDMMessages.MESSAGES.instantiationError(storageClass.getName(), (Throwable)e);
            }
            Property effectiveProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_EFFECTIVE_DATE);
            Property expiryProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_EXPIRY_DATE);
            List effectiveDateProperty = PropertyQueries.createQuery(storageClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{"effectiveDate"})).getResultList();
            ((Property)effectiveDateProperty.get(0)).setValue((Object)storage, effectiveProperty.getValue(instance));
            List expiryDateProperty = PropertyQueries.createQuery(storageClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{"expiryDate"})).getResultList();
            ((Property)expiryDateProperty.get(0)).setValue((Object)storage, expiryProperty.getValue(instance));
            EntityManager em = this.getEntityManager(context);
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery attributeCriteria = builder.createQuery(this.getConfig().getCredentialAttributeClass());
            Root attributeRoot = attributeCriteria.from(this.getConfig().getCredentialAttributeClass());
            ArrayList<Predicate> attributePredicates = new ArrayList<Predicate>();
            Property attributeCredential = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_ATTRIBUTE_CREDENTIAL);
            attributePredicates.add(builder.equal((Expression)attributeRoot.get(attributeCredential.getName()), instance));
            attributeCriteria.where(attributePredicates.toArray(new Predicate[attributePredicates.size()]));
            List attributes = em.createQuery(attributeCriteria).getResultList();
            Property attributeName = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_ATTRIBUTE_NAME);
            Property attributeValue = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_ATTRIBUTE_VALUE);
            for (Object attribute : attributes) {
                String name = attributeName.getValue(attribute).toString();
                String value = attributeValue.getValue(attribute).toString();
                List annotatedTypes = PropertyQueries.createQuery(storageClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{name})).getResultList();
                if (annotatedTypes.isEmpty()) {
                    throw new IdentityManagementException("Could not find property [" + attributeName.getName() + "] on CredentialStorage [" + storageClass.getName() + "].");
                }
                if (annotatedTypes.size() > 1) {
                    throw new IdentityManagementException("Ambiguos property [" + attributeName.getName() + "] on CredentialStorage [" + storageClass.getName() + "].");
                }
                Property property = (Property)annotatedTypes.get(0);
                property.setValue((Object)storage, Base64.decodeToObject((String)value));
            }
        }
        return (T)storage;
    }

    private <T> Object retrieveLastCredentialEntity(SecurityContext context, Agent agent, Class<T> storageClass) {
        Property identityTypeProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_IDENTITY);
        Property typeProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_TYPE);
        Property effectiveProperty = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_EFFECTIVE_DATE);
        EntityManager em = this.getEntityManager(context);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getCredentialClass());
        Root root = criteria.from(this.getConfig().getCredentialClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Object agentInstance = this.lookupIdentityObjectById(context, agent.getId());
        predicates.add(builder.equal((Expression)root.get(identityTypeProperty.getName()), agentInstance));
        predicates.add(builder.equal((Expression)root.get(typeProperty.getName()), (Object)storageClass.getName()));
        Predicate conjunction = builder.conjunction();
        conjunction.getExpressions().add(builder.lessThanOrEqualTo((Expression)root.get(effectiveProperty.getName()), (Comparable)new Date()));
        predicates.add(conjunction);
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        criteria.orderBy(new Order[]{builder.desc((Expression)root.get(effectiveProperty.getName()))});
        Object lastCredential = null;
        List result = em.createQuery(criteria).getResultList();
        if (!result.isEmpty()) {
            lastCredential = result.get(0);
        }
        return lastCredential;
    }

    private void checkCredentialClassProvided() {
        if (this.getConfig().getCredentialClass() == null) {
            throw new IdentityManagementException("No class Entity class provided to store credentials.");
        }
    }

    private void checkIdentityTypeClassProvided() {
        if (this.getConfig().getIdentityClass() == null) {
            throw new IdentityManagementException("No class Entity class provided to store identity types.");
        }
    }

    private void checkPartitionClassProvided() {
        if (this.getConfig().getPartitionClass() == null) {
            throw new IdentityManagementException("No class Entity class provided to store partitions.");
        }
    }

    private void checkRelationshipClassProvided() {
        if (this.getConfig().getRelationshipClass() == null) {
            throw new IdentityManagementException("No class Entity class provided to store relationships.");
        }
        if (this.getConfig().getRelationshipIdentityClass() == null) {
            throw new IdentityManagementException("No class Entity class provided to store relationships identity types.");
        }
        if (this.getConfig().getRelationshipAttributeClass() == null) {
            throw new IdentityManagementException("No class Entity class provided to store relationships attributes.");
        }
    }

    private void removeCredentials(SecurityContext context, Object object) {
        if (this.getConfig().getCredentialClass() != null) {
            EntityManager em = this.getEntityManager(context);
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(this.getConfig().getCredentialClass());
            Root root = criteria.from(this.getConfig().getCredentialClass());
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_IDENTITY).getName()), object));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            List results = em.createQuery(criteria).getResultList();
            for (Object credential : results) {
                CriteriaQuery attributeCriteria = builder.createQuery(this.getConfig().getCredentialAttributeClass());
                Root attributeRoot = attributeCriteria.from(this.getConfig().getCredentialAttributeClass());
                ArrayList<Predicate> attributePredicates = new ArrayList<Predicate>();
                Property attributeCredential = this.getConfig().getModelProperty(JPAIdentityStoreConfiguration.PropertyType.CREDENTIAL_ATTRIBUTE_CREDENTIAL);
                attributePredicates.add(builder.equal((Expression)attributeRoot.get(attributeCredential.getName()), credential));
                attributeCriteria.where(attributePredicates.toArray(new Predicate[attributePredicates.size()]));
                List attributes = em.createQuery(attributeCriteria).getResultList();
                for (Object attribute : attributes) {
                    em.remove(attribute);
                }
                em.remove(credential);
            }
        }
    }
}

