/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.util.Date;
import java.util.List;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.TOTPCredential;
import org.picketlink.idm.credential.TOTPCredentials;
import org.picketlink.idm.credential.internal.CredentialUtils;
import org.picketlink.idm.credential.internal.OTPCredentialStorage;
import org.picketlink.idm.credential.internal.PasswordCredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.credential.totp.TimeBasedOTP;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.SecurityContext;

@SupportsCredentials(value={TOTPCredentials.class, TOTPCredential.class})
public class TOTPCredentialHandler
extends PasswordCredentialHandler<CredentialStore<?>, TOTPCredentials, TOTPCredential> {
    public static final String ALGORITHM = "ALGORITHM";
    public static final String INTERVAL_SECONDS = "INTERVAL_SECONDS";
    public static final String NUMBER_DIGITS = "NUMBER_DIGITS";
    public static final String DELAY_WINDOW = "DELAY_WINDOW";
    public static final String DEFAULT_DEVICE = "DEFAULT_DEVICE";
    private TimeBasedOTP totp;

    @Override
    public void setup(CredentialStore<?> store) {
        super.setup(store);
        String algorithm = this.getConfigurationProperty(store, ALGORITHM, "HmacSHA1");
        String intervalSeconds = this.getConfigurationProperty(store, INTERVAL_SECONDS, "30");
        String numberDigits = this.getConfigurationProperty(store, NUMBER_DIGITS, "6");
        String delayWindow = this.getConfigurationProperty(store, DELAY_WINDOW, "1");
        this.totp = new TimeBasedOTP(algorithm, Integer.parseInt(numberDigits), Integer.valueOf(intervalSeconds).intValue(), Integer.valueOf(delayWindow).intValue());
    }

    @Override
    public void validate(SecurityContext context, TOTPCredentials credentials, CredentialStore<?> store) {
        super.validate(context, credentials, store);
        boolean isValid = false;
        if (Credentials.Status.VALID.equals((Object)credentials.getStatus())) {
            OTPCredentialStorage storage = null;
            String device = this.getDevice(credentials.getDevice());
            List storedCredentials = store.retrieveCredentials(context, credentials.getValidatedAgent(), OTPCredentialStorage.class);
            for (OTPCredentialStorage storedCredential : storedCredentials) {
                if (!storedCredential.getDevice().equals(device) || !CredentialUtils.isCurrentCredential(storedCredential) || storage != null && storage.getEffectiveDate().compareTo(storedCredential.getEffectiveDate()) > 0) continue;
                storage = storedCredential;
            }
            if (storage != null) {
                String secretKey = storage.getSecretKey();
                String token = credentials.getToken();
                isValid = this.totp.validate(token, secretKey.getBytes());
            }
        }
        if (!isValid) {
            credentials.setStatus(Credentials.Status.INVALID);
            credentials.setValidatedAgent(null);
        }
    }

    @Override
    public void update(SecurityContext context, Agent agent, TOTPCredential credential, CredentialStore<?> store, Date effectiveDate, Date expiryDate) {
        if (credential.getValue() != null && credential.getValue().length > 0) {
            super.update(context, agent, credential, store, effectiveDate, expiryDate);
        }
        OTPCredentialStorage storage = new OTPCredentialStorage();
        storage.setEffectiveDate(effectiveDate);
        storage.setExpiryDate(expiryDate);
        storage.setSecretKey(credential.getSecret());
        storage.setDevice(this.getDevice(credential.getDevice()));
        store.storeCredential(context, agent, (CredentialStorage)storage);
    }

    private String getDevice(String device) {
        if (StringUtil.isNullOrEmpty((String)device)) {
            device = DEFAULT_DEVICE;
        }
        return device;
    }

    private String getConfigurationProperty(CredentialStore<?> store, String key, String defaultValue) {
        Object algorithm = store.getConfig().getCredentialHandlerProperties().get(key);
        if (algorithm != null) {
            return String.valueOf(algorithm);
        }
        return defaultValue;
    }
}

