/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.picketlink.idm.IDMLogger;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.file.internal.FileAgent;
import org.picketlink.idm.file.internal.FileCredentialStorage;
import org.picketlink.idm.file.internal.FileGroup;
import org.picketlink.idm.file.internal.FilePartition;
import org.picketlink.idm.file.internal.FileRelationship;
import org.picketlink.idm.file.internal.FileRole;
import org.picketlink.idm.file.internal.FileUtils;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Role;

public class FileDataSource {
    private static final int ASYNC_FLUSH_THREAD_POOL = 5;
    private static final int FLUSH_BYTE_BUFFER = 1024;
    private static final String DEFAULT_WORKING_DIR = System.getProperty("java.io.tmpdir", File.separator + "tmp") + File.separator + "pl-idm";
    private static final String GROUPS_FILE_NAME = "pl-idm-groups.db";
    private static final String CREDENTIALS_FILE_NAME = "pl-idm-credentials.db";
    private static final String RELATIONSHIPS_FILE_NAME = "pl-idm-relationships.db";
    private static final String PARTITIONS_FILE_NAME = "pl-idm-partitions.db";
    private static final String ROLES_FILE_NAME = "pl-idm-roles.db";
    private static final String AGENTS_FILE_NAME = "pl-idm-agents.db";
    private String workingDir = DEFAULT_WORKING_DIR;
    private boolean alwaysCreateFiles = true;
    private boolean asyncWrite;
    private int asyncThreadPool = 5;
    private Map<String, FilePartition> partitions = new ConcurrentHashMap<String, FilePartition>();
    private Map<String, List<FileRelationship>> relationships = new ConcurrentHashMap<String, List<FileRelationship>>();
    private ExecutorService executorService;

    public void init(FileIdentityStoreConfiguration config) {
        this.alwaysCreateFiles = config.isAlwaysCreateFiles();
        this.asyncThreadPool = config.getAsyncThreadPool();
        this.asyncWrite = config.isAsyncWrite();
        this.workingDir = config.getWorkingDir();
        this.init();
    }

    private void initWorkingDirectory() {
        String workingDir = this.getWorkingDir();
        File workingDirectoryFile = new File(workingDir);
        if (workingDirectoryFile.exists() && this.isAlwaysCreateFiles()) {
            IDMLogger.LOGGER.fileConfigAlwaysCreateWorkingDir(workingDirectoryFile.getPath());
            FileUtils.delete(workingDirectoryFile);
        }
        workingDirectoryFile.mkdirs();
        IDMLogger.LOGGER.fileConfigUsingWorkingDir(workingDirectoryFile.getPath());
    }

    private void init() {
        this.initWorkingDirectory();
        File partitionsFile = FileUtils.createFileIfNotExists(new File(this.getWorkingDir() + File.separator + PARTITIONS_FILE_NAME));
        this.loadPartitions(partitionsFile);
        File relationshipsFile = FileUtils.createFileIfNotExists(new File(this.getWorkingDir() + File.separator + RELATIONSHIPS_FILE_NAME));
        this.relationships = (Map)FileUtils.readObject(relationshipsFile);
        if (this.relationships == null) {
            this.relationships = new HashMap<String, List<FileRelationship>>();
        }
        IDMLogger.LOGGER.debug((Object)"Loaded Relationships");
        if (this.asyncWrite) {
            IDMLogger.LOGGER.debugf("Async write enabled. Using thread pool of size %s", (Object)this.asyncThreadPool);
            this.executorService = Executors.newFixedThreadPool(this.asyncThreadPool);
        }
    }

    private void loadPartitions(File partitionsFile) {
        this.partitions = (Map)FileUtils.readObject(partitionsFile);
        if (this.partitions == null) {
            IDMLogger.LOGGER.debugf("No partitions to load from %s", (Object)partitionsFile.getPath());
            this.partitions = new ConcurrentHashMap<String, FilePartition>();
        } else {
            IDMLogger.LOGGER.infof("Loading %s Partitions from %s", (Object)this.partitions.size(), (Object)partitionsFile.getPath());
            Set<Map.Entry<String, FilePartition>> entrySet = this.partitions.entrySet();
            for (Map.Entry<String, FilePartition> entry : entrySet) {
                this.initPartition(entry.getKey());
            }
        }
    }

    protected void initPartition(String partitionId) {
        FilePartition filePartition = this.partitions.get(partitionId);
        IDMLogger.LOGGER.debugf("Initializing Partition [%s] with id [%s].", (Object)filePartition.getId(), (Object)partitionId);
        String agentsPath = this.getWorkingDir() + File.separator + partitionId + File.separator + AGENTS_FILE_NAME;
        File agentsFile = FileUtils.createFileIfNotExists(new File(agentsPath));
        ConcurrentHashMap agents = (ConcurrentHashMap)FileUtils.readObject(agentsFile);
        if (agents == null) {
            agents = new ConcurrentHashMap();
        }
        filePartition.setAgents(agents);
        IDMLogger.LOGGER.debugf("Loaded Agents for Partition [%s].", (Object)filePartition.getId());
        String rolesPath = this.getWorkingDir() + File.separator + partitionId + File.separator + ROLES_FILE_NAME;
        File rolesFile = FileUtils.createFileIfNotExists(new File(rolesPath));
        HashMap roles = (HashMap)FileUtils.readObject(rolesFile);
        if (roles == null) {
            roles = new HashMap();
        }
        filePartition.setRoles(roles);
        IDMLogger.LOGGER.debugf("Loaded Roles for Partition [%s].", (Object)filePartition.getId());
        String groupsPath = this.getWorkingDir() + File.separator + partitionId + File.separator + GROUPS_FILE_NAME;
        File groupsFile = FileUtils.createFileIfNotExists(new File(groupsPath));
        HashMap groups = (HashMap)FileUtils.readObject(groupsFile);
        if (groups == null) {
            groups = new HashMap();
        }
        filePartition.setGroups(groups);
        IDMLogger.LOGGER.debugf("Loaded Groups for Partition [%s].", (Object)filePartition.getId());
        String credentialsPath = this.getWorkingDir() + File.separator + partitionId + File.separator + CREDENTIALS_FILE_NAME;
        File credentialsFile = FileUtils.createFileIfNotExists(new File(credentialsPath));
        HashMap credentials = (HashMap)FileUtils.readObject(credentialsFile);
        if (credentials == null) {
            credentials = new HashMap();
        }
        filePartition.setCredentials(credentials);
        IDMLogger.LOGGER.debugf("Loaded Credentials for Partition [%s].", (Object)filePartition.getId());
    }

    protected void flushAgents(FilePartition partition) {
        this.flush(partition, AGENTS_FILE_NAME, partition.getAgents());
    }

    protected void flushRoles(FilePartition partition) {
        this.flush(partition, ROLES_FILE_NAME, partition.getRoles());
    }

    protected void flushGroups(FilePartition partition) {
        this.flush(partition, GROUPS_FILE_NAME, partition.getGroups());
    }

    protected void flushPartitions() {
        this.flush(PARTITIONS_FILE_NAME, this.getPartitions());
    }

    protected void flushCredentials(Realm realm) {
        FilePartition filePartition = this.getPartitions().get(realm.getId());
        this.flush(filePartition, CREDENTIALS_FILE_NAME, filePartition.getCredentials());
    }

    protected void flushRelationships() {
        this.flush(RELATIONSHIPS_FILE_NAME, this.getRelationships());
    }

    private void flush(FilePartition partition, String fileName, Object object) {
        this.flush(partition.getId() + File.separator + fileName, object);
    }

    private void flush(final String fileName, final Object object) {
        if (this.asyncWrite) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    FileDataSource.this.performFlush(fileName, object);
                }
            });
        } else {
            this.performFlush(fileName, object);
        }
    }

    private void performFlush(String fileName, Object object) {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        ByteArrayOutputStream bos = null;
        try {
            String filePath = this.getWorkingDir() + File.separator + fileName;
            fos = new FileOutputStream(filePath);
            FileChannel channel = fos.getChannel();
            bos = new ByteArrayOutputStream(1024);
            oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            channel.write(ByteBuffer.wrap(bos.toByteArray()));
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error flushing changes to file system.", (Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {}
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {}
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e) {}
        }
    }

    protected Map<String, Agent> getAgents(Partition partition) {
        Map<String, FileAgent> fileAgents = this.getPartition(partition).getAgents();
        ConcurrentHashMap<String, Agent> agents = new ConcurrentHashMap<String, Agent>();
        for (Map.Entry<String, FileAgent> fileAgent : fileAgents.entrySet()) {
            agents.put(fileAgent.getKey(), (Agent)fileAgent.getValue().getEntry());
        }
        return agents;
    }

    protected FilePartition getPartition(Partition partition) {
        if (!this.partitions.containsKey(partition.getId())) {
            this.partitions.put(partition.getId(), new FilePartition(partition));
            this.initPartition(partition.getId());
            this.flushPartitions();
        }
        return this.partitions.get(partition.getId());
    }

    protected Map<String, Role> getRoles(Partition partition) {
        Map<String, FileRole> fileRoles = this.getPartition(partition).getRoles();
        HashMap<String, Role> roles = new HashMap<String, Role>();
        for (Map.Entry<String, FileRole> fileRole : fileRoles.entrySet()) {
            roles.put(fileRole.getKey(), (Role)fileRole.getValue().getEntry());
        }
        return roles;
    }

    protected Map<String, List<FileRelationship>> getRelationships() {
        return this.relationships;
    }

    protected Map<String, Map<String, List<FileCredentialStorage>>> getCredentials(Realm realm) {
        return this.getPartition((Partition)realm).getCredentials();
    }

    protected Map<String, Group> getGroups(Partition partition) {
        Map<String, FileGroup> fileGroups = this.getPartition(partition).getGroups();
        HashMap<String, Group> groups = new HashMap<String, Group>();
        for (Map.Entry<String, FileGroup> fileRole : fileGroups.entrySet()) {
            groups.put(fileRole.getKey(), (Group)fileRole.getValue().getEntry());
        }
        return groups;
    }

    public Map<String, FilePartition> getPartitions() {
        return this.partitions;
    }

    public String getWorkingDir() {
        if (this.workingDir == null) {
            this.workingDir = DEFAULT_WORKING_DIR;
        }
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public boolean isAlwaysCreateFiles() {
        return this.alwaysCreateFiles;
    }

    public void setAlwaysCreateFiles(boolean alwaysCreateFiles) {
        this.alwaysCreateFiles = alwaysCreateFiles;
    }

    public void setAsyncWrite(boolean asyncWrite) {
        this.asyncWrite = asyncWrite;
    }

    public boolean isAsyncWrite() {
        return this.asyncWrite;
    }

    public void setAsyncThreadPool(int asyncThreadPool) {
        this.asyncThreadPool = asyncThreadPool;
    }

    public int getAsyncThreadPool() {
        return this.asyncThreadPool;
    }
}

