/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IDMLogger;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.file.internal.FileBasedIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.SecurityContext;
import org.picketlink.idm.spi.StoreFactory;

public class DefaultStoreFactory
implements StoreFactory {
    private Map<Class<? extends IdentityStoreConfiguration>, Class<? extends IdentityStore<?>>> identityConfigMap = new HashMap();
    private Map<Class<? extends IdentityStoreConfiguration>, IdentityStore<?>> storesCache = new HashMap();
    private Map<String, Set<IdentityStoreConfiguration>> realmStores = new HashMap<String, Set<IdentityStoreConfiguration>>();
    private Map<String, Realm> configuredRealms = new HashMap<String, Realm>();
    private Map<String, Set<IdentityStoreConfiguration>> tierStores = new HashMap<String, Set<IdentityStoreConfiguration>>();
    private Map<String, Tier> configuredTiers = new HashMap<String, Tier>();

    public DefaultStoreFactory(IdentityConfiguration identityConfig) {
        this.identityConfigMap.put(JPAIdentityStoreConfiguration.class, JPAIdentityStore.class);
        this.identityConfigMap.put(LDAPIdentityStoreConfiguration.class, LDAPIdentityStore.class);
        this.identityConfigMap.put(FileIdentityStoreConfiguration.class, FileBasedIdentityStore.class);
        HashMap<FeatureSet.FeatureGroup, IdentityStoreConfiguration> supportedFeatures = new HashMap<FeatureSet.FeatureGroup, IdentityStoreConfiguration>();
        for (IdentityStoreConfiguration config : identityConfig.getConfiguredStores()) {
            IDMLogger.LOGGER.identityManagerInitConfigForRealms(config, config.getRealms());
            Map storeFeatures = config.getSupportedFeatures();
            for (Map.Entry entry : storeFeatures.entrySet()) {
                FeatureSet.FeatureGroup feature = (FeatureSet.FeatureGroup)entry.getKey();
                if (FeatureSet.FeatureGroup.attribute.equals((Object)feature)) continue;
                IdentityStoreConfiguration storeConfigForFeature = (IdentityStoreConfiguration)supportedFeatures.get(feature);
                if (storeConfigForFeature == null) {
                    supportedFeatures.put(feature, config);
                    continue;
                }
                throw IDMMessages.MESSAGES.configurationAmbiguousFeatureForStore(feature, storeConfigForFeature, config);
            }
            config.init();
            for (String realm : config.getRealms()) {
                this.getConfigs(this.realmStores, realm).add(config);
            }
            for (String tier : config.getTiers()) {
                this.getConfigs(this.tierStores, tier).add(config);
            }
            if (config.getRealms().isEmpty() && config.getTiers().isEmpty()) {
                this.getConfigs(this.realmStores, "default").add(config);
            }
            if (identityConfig.getAdditionalIdentityStores() == null) continue;
            Set entrySet = identityConfig.getAdditionalIdentityStores().entrySet();
            for (Map.Entry entry : entrySet) {
                this.identityConfigMap.put((Class<IdentityStoreConfiguration>)entry.getKey(), (Class)entry.getValue());
            }
        }
    }

    public Realm getRealm(String id) {
        if (this.configuredRealms.containsKey(id)) {
            return this.configuredRealms.get(id);
        }
        if (this.realmStores.containsKey(id)) {
            Realm realm = new Realm(id);
            this.configuredRealms.put(id, realm);
            return realm;
        }
        return null;
    }

    public Tier getTier(String id) {
        if (this.configuredTiers.containsKey(id)) {
            return this.configuredTiers.get(id);
        }
        if (this.tierStores.containsKey(id)) {
            Tier tier = new Tier(id);
            this.configuredTiers.put(id, tier);
            return tier;
        }
        return null;
    }

    public <T extends IdentityStoreConfiguration> IdentityStore<T> createIdentityStore(T config, SecurityContext context) {
        for (Class<? extends IdentityStoreConfiguration> cc : this.identityConfigMap.keySet()) {
            if (!cc.isInstance(config)) continue;
            IdentityStore<?> identityStore = this.storesCache.get(cc);
            if (identityStore == null) {
                Class<IdentityStore<?>> identityStoreClass = this.identityConfigMap.get(cc);
                try {
                    identityStore = identityStoreClass.newInstance();
                    identityStore.setup(config);
                }
                catch (Exception e) {
                    throw IDMMessages.MESSAGES.instantiationError(identityStoreClass.getName(), (Throwable)e);
                }
                this.storesCache.put(cc, identityStore);
            }
            return identityStore;
        }
        throw IDMMessages.MESSAGES.storeConfigUnsupportedConfiguration(config);
    }

    public boolean isFeatureSupported(Partition partition, FeatureSet.FeatureGroup feature, FeatureSet.FeatureOperation operation, Class<? extends Relationship> relationshipClass) {
        return this.lookupConfigForFeature(partition, feature, operation, relationshipClass) != null;
    }

    public IdentityStore<?> getStoreForFeature(SecurityContext context, FeatureSet.FeatureGroup feature, FeatureSet.FeatureOperation operation) {
        return this.getStoreForFeature(context, feature, operation, null);
    }

    public IdentityStore<?> getStoreForFeature(SecurityContext context, FeatureSet.FeatureGroup feature, FeatureSet.FeatureOperation operation, Class<? extends Relationship> relationshipClass) {
        Tier tier;
        if (Realm.class.isInstance(context.getPartition())) {
            Realm realm = (Realm)context.getPartition();
            if (!this.realmStores.containsKey(realm.getId())) {
                IDMLogger.LOGGER.identityManagerRealmNotConfigured(realm.getId());
                throw IDMMessages.MESSAGES.storeConfigRealmNotConfigured(realm.getId());
            }
        } else if (Tier.class.isInstance(context.getPartition()) && !this.tierStores.containsKey((tier = (Tier)context.getPartition()).getId())) {
            IDMLogger.LOGGER.identityManagerTierNotConfigured(tier.getId());
            throw IDMMessages.MESSAGES.storeConfigTierNotConfigured(tier.getId());
        }
        IdentityStoreConfiguration config = this.lookupConfigForFeature(context.getPartition(), feature, operation, relationshipClass);
        IdentityStore<IdentityStoreConfiguration> store = this.createIdentityStore(config, context);
        for (ContextInitializer initializer : config.getContextInitializers()) {
            initializer.initContextForStore(context, store);
        }
        IDMLogger.LOGGER.debugf("Performing operation [%s.%s] on IdentityStore [%s] using Partition [%s]", new Object[]{feature, operation, store, context.getPartition()});
        return store;
    }

    private IdentityStoreConfiguration lookupConfigForFeature(Partition partition, FeatureSet.FeatureGroup feature, FeatureSet.FeatureOperation operation, Class<? extends Relationship> relationshipClass) {
        Set<IdentityStoreConfiguration> configs = null;
        if (Realm.class.isInstance(partition)) {
            configs = this.realmStores.get(partition.getId());
        } else if (Tier.class.isInstance(partition)) {
            configs = this.tierStores.get(partition.getId());
        }
        IdentityStoreConfiguration config = null;
        if (configs != null) {
            boolean isUnsupportedRelationship = false;
            for (IdentityStoreConfiguration cfg : configs) {
                if (relationshipClass != null) {
                    if (cfg.supportsRelationship(relationshipClass, null)) {
                        if (!cfg.supportsRelationship(relationshipClass, operation)) continue;
                        config = cfg;
                        break;
                    }
                    isUnsupportedRelationship = true;
                    continue;
                }
                if (!cfg.supportsFeature(feature, operation)) continue;
                config = cfg;
                break;
            }
            if (config == null) {
                IDMLogger.LOGGER.identityManagerUnsupportedOperation(feature, operation);
                if (isUnsupportedRelationship) {
                    throw IDMMessages.MESSAGES.storeConfigUnsupportedRelationshipType(relationshipClass);
                }
                throw IDMMessages.MESSAGES.storeConfigUnsupportedOperation(feature, operation, feature, operation);
            }
        }
        return config;
    }

    private Set<IdentityStoreConfiguration> getConfigs(Map<String, Set<IdentityStoreConfiguration>> stores, String key) {
        if (stores.containsKey(key)) {
            return stores.get(key);
        }
        HashSet<IdentityStoreConfiguration> configs = new HashSet<IdentityStoreConfiguration>();
        stores.put(key, configs);
        return configs;
    }
}

