/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.io.Serializable;
import org.picketlink.idm.IDMLogger;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.internal.DefaultIdentityManager;
import org.picketlink.idm.internal.DefaultSecurityContextFactory;
import org.picketlink.idm.internal.DefaultStoreFactory;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.spi.SecurityContext;
import org.picketlink.idm.spi.SecurityContextFactory;
import org.picketlink.idm.spi.StoreFactory;

public class IdentityManagerFactory
implements Serializable {
    private static final long serialVersionUID = 666601082732493295L;
    private SecurityContextFactory contextFactory;
    private StoreFactory storeFactory;

    public IdentityManagerFactory(IdentityConfiguration identityConfig) {
        IDMLogger.LOGGER.identityManagerBootstrapping();
        if (identityConfig == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityConfiguration");
        }
        this.contextFactory = this.contextFactory == null ? new DefaultSecurityContextFactory() : identityConfig.getSecurityContextFactory();
        this.storeFactory = this.storeFactory == null ? new DefaultStoreFactory(identityConfig) : identityConfig.getStoreFactory();
    }

    public IdentityManager createIdentityManager() throws SecurityConfigurationException {
        Realm defaultRealm = this.getRealm("default");
        if (defaultRealm == null) {
            throw IDMMessages.MESSAGES.configurationDefaultRealmNotDefined();
        }
        return this.createIdentityManager((Partition)defaultRealm);
    }

    public IdentityManager createIdentityManager(Partition partition) throws SecurityConfigurationException, IdentityManagementException {
        if (partition == null) {
            throw IDMMessages.MESSAGES.nullArgument("Partition");
        }
        try {
            SecurityContext context = this.contextFactory.createContext(partition);
            return new DefaultIdentityManager(context, this.storeFactory);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.couldNotCreateContextualIdentityManager(partition);
        }
    }

    public Realm getRealm(String name) {
        return this.storeFactory.getRealm(name);
    }

    public Tier getTier(String name) {
        return this.storeFactory.getTier(name);
    }
}

