/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.Date;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPUser;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.spi.SecurityContext;

@SupportsCredentials(value={UsernamePasswordCredentials.class, Password.class})
public class LDAPPlainTextPasswordCredentialHandler<S, V, U>
implements CredentialHandler<LDAPIdentityStore, UsernamePasswordCredentials, Password> {
    private static final String USER_PASSWORD_ATTRIBUTE = "userpassword";

    public void setup(LDAPIdentityStore store) {
    }

    public void validate(SecurityContext context, UsernamePasswordCredentials usernamePassword, LDAPIdentityStore identityStore) {
        usernamePassword.setStatus(Credentials.Status.INVALID);
        usernamePassword.setValidatedAgent(null);
        Agent agent = identityStore.getAgent(context, usernamePassword.getUsername());
        if (agent != null) {
            if (agent.isEnabled()) {
                LDAPIdentityStore ldapIdentityStore = identityStore;
                LDAPUser ldapUser = ldapIdentityStore.lookupEntryById(context, LDAPUser.class, agent.getId());
                char[] password = usernamePassword.getPassword().getValue();
                boolean isValid = ldapIdentityStore.getLDAPManager().authenticate(ldapUser.getDN(), new String(password));
                if (isValid) {
                    usernamePassword.setValidatedAgent(agent);
                    usernamePassword.setStatus(Credentials.Status.VALID);
                }
            } else {
                usernamePassword.setStatus(Credentials.Status.AGENT_DISABLED);
            }
        }
    }

    public void update(SecurityContext context, Agent agent, Password password, LDAPIdentityStore store, Date effectiveDate, Date expiryDate) {
        LDAPUser ldapuser = store.lookupEntryById(context, LDAPUser.class, agent.getId());
        if (store.getConfig().isActiveDirectory()) {
            this.updateADPassword(ldapuser, new String(password.getValue()), store);
        } else {
            ModificationItem[] mods = new ModificationItem[1];
            try {
                BasicAttribute mod0 = new BasicAttribute(USER_PASSWORD_ATTRIBUTE, new String(password.getValue()));
                mods[0] = new ModificationItem(2, mod0);
                store.getLDAPManager().modifyAttribute(ldapuser.getDN(), mod0);
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error updating password.", (Throwable)e);
            }
        }
    }

    private void updateADPassword(LDAPUser user, String password, LDAPIdentityStore store) {
        try {
            String newQuotedPassword = "\"" + password + "\"";
            byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
            BasicAttribute unicodePwd = new BasicAttribute("unicodePwd", newUnicodePassword);
            store.getLDAPManager().modifyAttribute(user.getDN(), unicodePwd);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

