/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.password.internal;

import org.picketlink.idm.password.PasswordEncoder;
import org.picketlink.idm.password.internal.BCrypt;

public class BCryptPasswordEncoder
implements PasswordEncoder {
    int logRounds = 12;

    public BCryptPasswordEncoder(int logRounds) {
        this.logRounds = logRounds;
    }

    public String encode(String rawPassword) {
        return BCrypt.hashpw(rawPassword, BCrypt.gensalt(this.logRounds));
    }

    public boolean verify(String rawPassword, String encodedPassword) {
        return BCrypt.checkpw(rawPassword, encodedPassword);
    }
}

