/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.query.internal;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.SecurityContext;

public class DefaultIdentityQuery<T extends IdentityType>
implements IdentityQuery<T> {
    private Map<QueryParameter, Object[]> parameters = new LinkedHashMap<QueryParameter, Object[]>();
    private SecurityContext context;
    private IdentityStore<?> identityStore;
    private Class<T> identityType;
    private int offset;
    private int limit;
    private QueryParameter[] sortParameters;
    private boolean sortAscending = true;

    public DefaultIdentityQuery(SecurityContext context, Class<T> identityType, IdentityStore<?> identityStore) {
        this.context = context;
        this.identityStore = identityStore;
        this.identityType = identityType;
    }

    public IdentityQuery<T> setParameter(QueryParameter param, Object ... value) {
        this.parameters.put(param, value);
        return this;
    }

    public Class<T> getIdentityType() {
        return this.identityType;
    }

    public Map<QueryParameter, Object[]> getParameters() {
        return this.parameters;
    }

    public Object[] getParameter(QueryParameter queryParameter) {
        return this.parameters.get(queryParameter);
    }

    public Map<QueryParameter, Object[]> getParameters(Class<?> type) {
        HashMap<QueryParameter, Object[]> typedParameters = new HashMap<QueryParameter, Object[]>();
        Set<Map.Entry<QueryParameter, Object[]>> entrySet = this.parameters.entrySet();
        for (Map.Entry<QueryParameter, Object[]> entry : entrySet) {
            if (!type.isInstance(entry.getKey())) continue;
            typedParameters.put(entry.getKey(), entry.getValue());
        }
        return typedParameters;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public QueryParameter[] getSortParameters() {
        return this.sortParameters;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public List<T> getResultList() {
        List result = null;
        try {
            result = this.identityStore.fetchQueryResults(this.context, (IdentityQuery)this);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.identityTypeQueryFailed((IdentityQuery)this, (Throwable)e);
        }
        return result;
    }

    public int getResultCount() {
        return this.identityStore.countQueryResults(this.context, (IdentityQuery)this);
    }

    public IdentityQuery<T> setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public IdentityQuery<T> setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public IdentityQuery<T> setSortParameters(QueryParameter ... sortParameters) {
        this.sortParameters = sortParameters;
        return this;
    }

    public IdentityQuery<T> setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
        return this;
    }
}

