/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;

public abstract class AbstractIdentityStore<C extends IdentityStoreConfiguration>
implements IdentityStore<C> {
    private C configuration;
    private Map<Class<? extends CredentialHandler>, CredentialHandler> credentialHandlers = new HashMap<Class<? extends CredentialHandler>, CredentialHandler>();

    public void setup(C config) {
        this.configuration = config;
        this.initializeCredentialHandlers();
    }

    public C getConfig() {
        return this.configuration;
    }

    public void add(IdentityContext context, AttributedType attributedType) {
        attributedType.setId(context.getIdGenerator().generate());
        if (IdentityType.class.isInstance(attributedType)) {
            IdentityType identityType = (IdentityType)attributedType;
            identityType.setPartition(context.getPartition());
        }
        this.addAttributedType(context, attributedType);
    }

    public void update(IdentityContext context, AttributedType attributedType) {
        if (IdentityType.class.isInstance(attributedType)) {
            IdentityType identityType = (IdentityType)attributedType;
            identityType.setPartition(context.getPartition());
        }
        this.updateAttributedType(context, attributedType);
    }

    public void remove(IdentityContext context, AttributedType attributedType) {
        if (IdentityType.class.isInstance(attributedType)) {
            IdentityType identityType = (IdentityType)attributedType;
            identityType.setPartition(context.getPartition());
        }
        this.removeAttributedType(context, attributedType);
    }

    public void validateCredentials(IdentityContext context, Credentials credentials) {
        Class<CredentialHandler> credentialHandler = this.getCredentialHandler(credentials);
        this.credentialHandlers.get(credentialHandler).validate(context, credentials, (IdentityStore)this);
    }

    public void updateCredential(IdentityContext context, Account account, Object credential, Date effectiveDate, Date expiryDate) {
        Class<CredentialHandler> credentialHandler = this.getCredentialHandler(credential);
        this.credentialHandlers.get(credentialHandler).update(context, account, credential, (IdentityStore)this, effectiveDate, expiryDate);
    }

    protected abstract void addAttributedType(IdentityContext var1, AttributedType var2);

    protected abstract void updateAttributedType(IdentityContext var1, AttributedType var2);

    protected abstract void removeAttributedType(IdentityContext var1, AttributedType var2);

    private Class<? extends CredentialHandler> getCredentialHandler(Object credentials) {
        Class credentialHandler = null;
        if (credentialHandler == null) {
            for (Class handlerClass : this.getConfig().getCredentialHandlers()) {
                if (!handlerClass.isAnnotationPresent(SupportsCredentials.class)) continue;
                for (Class cls : handlerClass.getAnnotation(SupportsCredentials.class).value()) {
                    if (!cls.isAssignableFrom(credentials.getClass())) continue;
                    credentialHandler = handlerClass;
                    if (!cls.equals(credentials.getClass())) continue;
                    return handlerClass;
                }
            }
        }
        if (credentialHandler == null) {
            throw IDMMessages.MESSAGES.credentialHandlerNotFoundForCredentialType(credentials.getClass());
        }
        return credentialHandler;
    }

    private void initializeCredentialHandlers() {
        for (Class handlerType : this.configuration.getCredentialHandlers()) {
            CredentialHandler credentialHandler = null;
            try {
                credentialHandler = (CredentialHandler)handlerType.newInstance();
                credentialHandler.setup((IdentityStore)this);
            }
            catch (Exception e) {
                throw IDMMessages.MESSAGES.instantiationError(handlerType, (Throwable)e);
            }
            this.credentialHandlers.put(handlerType, credentialHandler);
        }
    }
}

