/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.DefaultIdGenerator;
import org.picketlink.idm.IDMLogger;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.config.AbstractIdentityStoreConfiguration;
import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.config.OperationNotSupportedException;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.file.internal.FileIdentityStore;
import org.picketlink.idm.internal.AbstractIdentityContext;
import org.picketlink.idm.internal.ContextualIdentityManager;
import org.picketlink.idm.internal.ContextualRelationshipManager;
import org.picketlink.idm.internal.util.RelationshipMetadata;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.IdentityPartition;
import org.picketlink.idm.model.basic.Realm;
import org.picketlink.idm.spi.AttributeStore;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.PartitionStore;
import org.picketlink.idm.spi.StoreSelector;
import org.picketlink.idm.util.IDMUtil;

public class DefaultPartitionManager
implements PartitionManager,
StoreSelector {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_CONFIGURATION_NAME = "default";
    private final Collection<IdentityConfiguration> configurations;
    private final Map<Partition, IdentityConfiguration> partitionConfigurations = new ConcurrentHashMap<Partition, IdentityConfiguration>();
    private final Map<IdentityConfiguration, Map<IdentityStoreConfiguration, IdentityStore<?>>> stores;
    private final IdentityConfiguration partitionManagementConfig;
    private final IdentityConfiguration attributeManagementConfig;
    private EventBridge eventBridge;
    private IdGenerator idGenerator;
    private RelationshipMetadata relationshipMetadata = new RelationshipMetadata();

    public DefaultPartitionManager(IdentityConfiguration configuration) {
        this(Arrays.asList(configuration));
    }

    public DefaultPartitionManager(Collection<IdentityConfiguration> configurations) {
        this(configurations, null, null);
    }

    public DefaultPartitionManager(Collection<IdentityConfiguration> configurations, EventBridge eventBridge) {
        this(configurations, eventBridge, null);
    }

    public DefaultPartitionManager(Collection<IdentityConfiguration> configurations, EventBridge eventBridge, IdGenerator idGenerator) {
        IDMLogger.LOGGER.identityManagerBootstrapping();
        if (configurations == null || configurations.isEmpty()) {
            throw IDMMessages.MESSAGES.configNoIdentityConfigurationProvided();
        }
        this.configurations = Collections.unmodifiableCollection(configurations);
        this.eventBridge = eventBridge != null ? eventBridge : new EventBridge(){

            public void raiseEvent(Object event) {
            }
        };
        this.idGenerator = idGenerator != null ? idGenerator : new DefaultIdGenerator();
        IdentityConfiguration partitionCfg = null;
        IdentityConfiguration attributeCfg = null;
        for (IdentityConfiguration config : configurations) {
            for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                if (storeConfig.supportsPartition()) {
                    partitionCfg = config;
                }
                if (!storeConfig.supportsAttribute()) continue;
                attributeCfg = config;
            }
        }
        this.partitionManagementConfig = partitionCfg;
        this.attributeManagementConfig = attributeCfg;
        HashMap configuredStores = new HashMap();
        for (IdentityConfiguration config : configurations) {
            HashMap storeMap = new HashMap();
            for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                storeMap.put(storeConfig, this.createIdentityStore(storeConfig));
            }
            configuredStores.put(config, Collections.unmodifiableMap(storeMap));
        }
        this.stores = Collections.unmodifiableMap(configuredStores);
    }

    private <T extends IdentityStore> T createIdentityStore(IdentityStoreConfiguration storeConfiguration) {
        Class storeClass = storeConfiguration.getIdentityStoreType();
        if (storeClass == null) {
            if (FileIdentityStoreConfiguration.class.isInstance(storeConfiguration)) {
                storeClass = FileIdentityStore.class;
            } else if (JPAIdentityStoreConfiguration.class.isInstance(storeConfiguration)) {
                storeClass = JPAIdentityStore.class;
            } else if (LDAPIdentityStoreConfiguration.class.isInstance(storeConfiguration)) {
                storeClass = LDAPIdentityStore.class;
            }
        }
        if (storeClass == null) {
            throw IDMMessages.MESSAGES.configUnknownStoreForConfiguration(storeConfiguration);
        }
        IdentityStore store = null;
        try {
            if (storeConfiguration instanceof AbstractIdentityStoreConfiguration) {
                ((AbstractIdentityStoreConfiguration)storeConfiguration).setIdentityStoreType(storeClass);
            }
            store = (IdentityStore)storeClass.newInstance();
        }
        catch (Exception ex) {
            throw IDMMessages.MESSAGES.configCouldNotCreateStore(storeClass, storeConfiguration, ex);
        }
        store.setup(storeConfiguration);
        return (T)store;
    }

    private IdentityConfiguration getConfigurationByName(String name) {
        for (IdentityConfiguration config : this.configurations) {
            if (!name.equals(config.getName())) continue;
            return config;
        }
        throw IDMMessages.MESSAGES.partitionNoConfigurationFound(name);
    }

    private IdentityConfiguration getConfigurationForPartition(Partition partition) {
        IdentityConfiguration identityConfiguration = this.lookupPartitionConfiguration(partition);
        if (identityConfiguration == null) {
            throw IDMMessages.MESSAGES.partitionReferencesInvalidConfiguration(partition);
        }
        return identityConfiguration;
    }

    private IdentityConfiguration lookupPartitionConfiguration(Partition partition) {
        if (!this.partitionConfigurations.containsKey(partition)) {
            IdentityContext context = this.createIdentityContext();
            Object store = this.getStoreForPartitionOperation(context);
            this.partitionConfigurations.put(partition, this.getConfigurationByName(store.getConfigurationName(context, partition)));
        }
        return this.partitionConfigurations.get(partition);
    }

    private IdentityContext createIdentityContext() {
        return new AbstractIdentityContext(null, this.eventBridge, this.idGenerator){

            @Override
            public EventBridge getEventBridge() {
                return DefaultPartitionManager.this.eventBridge;
            }

            @Override
            public IdGenerator getIdGenerator() {
                return DefaultPartitionManager.this.idGenerator;
            }

            @Override
            public Partition getPartition() {
                return null;
            }
        };
    }

    public IdentityManager createIdentityManager() throws IdentityManagementException {
        return this.createIdentityManager((Partition)new Realm(DEFAULT_CONFIGURATION_NAME));
    }

    public IdentityManager createIdentityManager(Partition partition) throws IdentityManagementException {
        if (partition == null) {
            throw IDMMessages.MESSAGES.nullArgument("Partition");
        }
        Object storedPartition = null;
        storedPartition = this.partitionManagementConfig != null ? this.getPartition(partition.getClass(), partition.getName()) : this.createDefaultPartition();
        if (storedPartition == null) {
            throw IDMMessages.MESSAGES.partitionNotFoundWithName(partition.getClass(), partition.getName());
        }
        try {
            return new ContextualIdentityManager((Partition)storedPartition, this.eventBridge, this.idGenerator, this, this.createRelationshipManager());
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.partitionCouldNotCreateIdentityManager(storedPartition);
        }
    }

    public RelationshipManager createRelationshipManager() {
        return new ContextualRelationshipManager(this.eventBridge, this.idGenerator, this);
    }

    public <T extends Partition> T getPartition(Class<T> partitionClass, String name) {
        if (partitionClass == null) {
            throw IDMMessages.MESSAGES.nullArgument("Partition class");
        }
        if (StringUtil.isNullOrEmpty((String)name)) {
            throw IDMMessages.MESSAGES.nullArgument("Partition name");
        }
        if (this.partitionManagementConfig == null) {
            return (T)this.createDefaultPartition();
        }
        try {
            T attributeStore;
            IdentityContext context = this.createIdentityContext();
            Partition partition = this.getStoreForPartitionOperation(context).get(context, partitionClass, name);
            if (partition != null && (attributeStore = this.getStoreForAttributeOperation(context)) != null) {
                attributeStore.loadAttributes(context, (AttributedType)partition);
            }
            return (T)partition;
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.partitionGetFailed(partitionClass, name, e);
        }
    }

    public <T extends Partition> List<T> getPartitions(Class<T> partitionClass) {
        if (partitionClass == null) {
            throw IDMMessages.MESSAGES.nullArgument("Partition class");
        }
        List partitions = null;
        if (this.partitionManagementConfig == null) {
            partitions = new ArrayList<Partition>();
            partitions.add(this.createDefaultPartition());
            return partitions;
        }
        try {
            IdentityContext context = this.createIdentityContext();
            partitions = this.getStoreForPartitionOperation(context).get(context, partitionClass);
            for (Partition partition : partitions) {
                T attributeStore = this.getStoreForAttributeOperation(context);
                if (attributeStore == null) continue;
                attributeStore.loadAttributes(context, (AttributedType)partition);
            }
            return partitions;
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.partitionGetFailed(partitionClass, "not specified", e);
        }
    }

    public <T extends Partition> T lookupById(Class<T> partitionClass, String id) {
        if (partitionClass == null) {
            throw IDMMessages.MESSAGES.nullArgument("Partition class");
        }
        if (StringUtil.isNullOrEmpty((String)id)) {
            throw IDMMessages.MESSAGES.nullArgument("Partition identifier");
        }
        if (this.partitionManagementConfig == null) {
            return (T)this.createDefaultPartition();
        }
        try {
            T attributeStore;
            IdentityContext context = this.createIdentityContext();
            Partition partition = this.getStoreForPartitionOperation(context).lookupById(context, partitionClass, id);
            if (partition != null && (attributeStore = this.getStoreForAttributeOperation(context)) != null) {
                attributeStore.loadAttributes(context, (AttributedType)partition);
            }
            return (T)partition;
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.partitionGetFailed(partitionClass, id, e);
        }
    }

    public void add(Partition partition) throws IdentityManagementException, OperationNotSupportedException {
        this.add(partition, null);
    }

    public void add(Partition partition, String configurationName) throws IdentityManagementException, OperationNotSupportedException {
        this.checkPartitionManagementSupported();
        if (partition == null) {
            throw IDMMessages.MESSAGES.nullArgument("Partition");
        }
        if (StringUtil.isNullOrEmpty((String)configurationName)) {
            configurationName = this.getDefaultConfigurationName();
        }
        if (this.getConfigurationByName(configurationName) != null) {
            if (this.getPartition(partition.getClass(), partition.getName()) != null) {
                throw IDMMessages.MESSAGES.partitionAlreadyExistsWithName(partition.getClass(), partition.getName());
            }
            try {
                IdentityContext context = this.createIdentityContext();
                this.getStoreForPartitionOperation(context).add(context, partition, configurationName);
                Object attributeStore = this.getStoreForAttributeOperation(context);
                if (attributeStore != null) {
                    for (Attribute attribute : partition.getAttributes()) {
                        attributeStore.setAttribute(context, (AttributedType)partition, attribute);
                    }
                }
            }
            catch (Exception e) {
                throw IDMMessages.MESSAGES.partitionAddFailed(partition, configurationName, e);
            }
        }
    }

    public void update(Partition partition) throws IdentityManagementException, OperationNotSupportedException {
        this.checkPartitionManagementSupported();
        this.checkIfPartitionExists(partition);
        try {
            IdentityContext context = this.createIdentityContext();
            this.getStoreForPartitionOperation(context).update(context, partition);
            Object attributeStore = this.getStoreForAttributeOperation(context);
            if (attributeStore != null) {
                Object storedType = this.lookupById(partition.getClass(), partition.getId());
                for (Attribute attribute : storedType.getAttributes()) {
                    if (partition.getAttribute(attribute.getName()) != null) continue;
                    attributeStore.removeAttribute(context, (AttributedType)partition, attribute.getName());
                }
                for (Attribute attribute : partition.getAttributes()) {
                    attributeStore.setAttribute(context, (AttributedType)partition, attribute);
                }
            }
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.partitionUpdateFailed(partition, e);
        }
    }

    public void remove(Partition partition) {
        this.checkPartitionManagementSupported();
        this.checkIfPartitionExists(partition);
        try {
            IdentityContext context = this.createIdentityContext();
            Object attributeStore = this.getStoreForAttributeOperation(context);
            if (attributeStore != null) {
                Object storedType = this.lookupById(partition.getClass(), partition.getId());
                for (Attribute attribute : storedType.getAttributes()) {
                    attributeStore.removeAttribute(context, storedType, attribute.getName());
                }
            }
            this.getStoreForPartitionOperation(context).remove(context, partition);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.partitionRemoveFailed(partition, e);
        }
    }

    public <T extends IdentityStore<?>> T getStoreForIdentityOperation(IdentityContext context, Class<T> storeType, Class<? extends AttributedType> type, IdentityStoreConfiguration.IdentityOperation operation) {
        this.checkSupportedTypes(context.getPartition(), type);
        IdentityConfiguration identityConfiguration = null;
        if (this.partitionManagementConfig != null) {
            identityConfiguration = this.getConfigurationForPartition(context.getPartition());
        } else if (this.configurations.size() == 1) {
            identityConfiguration = this.configurations.iterator().next();
        }
        T identityStore = null;
        if (identityConfiguration == null) {
            IdentityConfiguration configuration;
            Iterator<IdentityConfiguration> i$ = this.configurations.iterator();
            while (i$.hasNext() && (identityStore = (T)this.lookupStore(context, configuration = i$.next(), type, operation)) == null) {
            }
        } else {
            identityStore = this.lookupStore(context, identityConfiguration, type, operation);
        }
        if (identityStore == null) {
            throw IDMMessages.MESSAGES.attributedTypeUnsupportedOperation(type, operation, type, operation);
        }
        return identityStore;
    }

    public <T extends IdentityStore<?>> T lookupStore(IdentityContext context, IdentityConfiguration configuration, Class<? extends AttributedType> type, IdentityStoreConfiguration.IdentityOperation operation) {
        for (IdentityStoreConfiguration storeConfig : configuration.getStoreConfiguration()) {
            if (!storeConfig.supportsType(type, operation)) continue;
            IdentityStore<?> store = this.stores.get(configuration).get(storeConfig);
            storeConfig.initializeContext(context, store);
            return (T)store;
        }
        return null;
    }

    public <T extends CredentialStore<?>> T getStoreForCredentialOperation(IdentityContext context, Class<?> credentialClass) {
        CredentialStore store = null;
        IdentityConfiguration identityConfiguration = null;
        identityConfiguration = this.partitionManagementConfig != null ? this.getConfigurationForPartition(context.getPartition()) : this.configurations.iterator().next();
        for (IdentityStoreConfiguration storeConfig : identityConfiguration.getStoreConfiguration()) {
            for (Class handlerClass : storeConfig.getCredentialHandlers()) {
                if (!handlerClass.isAnnotationPresent(SupportsCredentials.class)) continue;
                for (Class cls : handlerClass.getAnnotation(SupportsCredentials.class).value()) {
                    if (!cls.isAssignableFrom(credentialClass)) continue;
                    IdentityStore<?> identityStore = null;
                    try {
                        identityStore = this.stores.get(identityConfiguration).get(storeConfig);
                        store = (CredentialStore)identityStore;
                        storeConfig.initializeContext(context, (IdentityStore)store);
                    }
                    catch (ClassCastException cce) {
                        throw IDMMessages.MESSAGES.storeUnexpectedType(identityStore.getClass(), CredentialStore.class);
                    }
                    if (!cls.equals(credentialClass)) continue;
                    return (T)store;
                }
            }
        }
        if (store == null) {
            throw IDMMessages.MESSAGES.credentialNoStoreForCredentials(credentialClass);
        }
        return (T)store;
    }

    public IdentityStore<?> getStoreForRelationshipOperation(IdentityContext context, Class<? extends Relationship> relationshipClass, Relationship relationship, IdentityStoreConfiguration.IdentityOperation operation) {
        Set<Partition> partitions = this.relationshipMetadata.getRelationshipPartitions(relationship);
        IdentityStore<?> store = null;
        if (partitions.size() == 1) {
            IdentityConfiguration config = null;
            config = this.partitionManagementConfig != null ? this.getConfigurationForPartition(partitions.iterator().next()) : this.configurations.iterator().next();
            if (config.getRelationshipPolicy().isSelfRelationshipSupported(relationshipClass)) {
                for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                    if (!storeConfig.supportsType(relationshipClass, operation)) continue;
                    store = this.stores.get(config).get(storeConfig);
                    storeConfig.initializeContext(context, store);
                }
            }
        } else {
            for (Partition partition : partitions) {
                IdentityConfiguration config = this.getConfigurationForPartition(partition);
                if (!config.getRelationshipPolicy().isGlobalRelationshipSupported(relationshipClass)) continue;
                for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                    if (!storeConfig.supportsType(relationshipClass, operation)) continue;
                    store = this.stores.get(config).get(storeConfig);
                    storeConfig.initializeContext(context, store);
                }
            }
        }
        if (store == null) {
            for (IdentityConfiguration cfg : this.configurations) {
                if (!cfg.getRelationshipPolicy().isGlobalRelationshipSupported(relationshipClass)) continue;
                for (IdentityStoreConfiguration storeConfig : cfg.getStoreConfiguration()) {
                    if (!storeConfig.supportsType(relationshipClass, operation)) continue;
                    store = this.stores.get(cfg).get(storeConfig);
                    storeConfig.initializeContext(context, store);
                }
            }
        }
        return store;
    }

    public Set<IdentityStore<?>> getStoresForRelationshipQuery(IdentityContext context, Class<? extends Relationship> relationshipClass, Set<Partition> partitions) {
        HashSet result = new HashSet();
        if (partitions.isEmpty()) {
            for (IdentityConfiguration config : this.configurations) {
                if (!config.getRelationshipPolicy().isGlobalRelationshipSupported(relationshipClass) && !config.getRelationshipPolicy().isSelfRelationshipSupported(relationshipClass)) continue;
                for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                    if (!storeConfig.supportsType(relationshipClass, IdentityStoreConfiguration.IdentityOperation.create)) continue;
                    IdentityStore<?> store = this.stores.get(config).get(storeConfig);
                    storeConfig.initializeContext(context, store);
                    result.add(store);
                }
            }
        } else {
            for (Partition partition : partitions) {
                IdentityConfiguration config = this.getConfigurationForPartition(partition);
                if (!config.getRelationshipPolicy().isGlobalRelationshipSupported(relationshipClass)) continue;
                for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                    if (!storeConfig.supportsType(relationshipClass, IdentityStoreConfiguration.IdentityOperation.create)) continue;
                    IdentityStore<?> store = this.stores.get(config).get(storeConfig);
                    storeConfig.initializeContext(context, store);
                    result.add(store);
                }
            }
        }
        return result;
    }

    public <T extends PartitionStore<?>> T getStoreForPartitionOperation(IdentityContext context) {
        Map<IdentityStoreConfiguration, IdentityStore<?>> configStores = this.stores.get(this.partitionManagementConfig);
        for (IdentityStoreConfiguration cfg : configStores.keySet()) {
            if (!cfg.supportsType(Partition.class, IdentityStoreConfiguration.IdentityOperation.create)) continue;
            PartitionStore store = null;
            try {
                store = (PartitionStore)configStores.get(cfg);
                cfg.initializeContext(context, (IdentityStore)store);
                return (T)store;
            }
            catch (ClassCastException cce) {
                throw IDMMessages.MESSAGES.storeUnexpectedType(store.getClass(), PartitionStore.class);
            }
        }
        throw IDMMessages.MESSAGES.storeNotFound(PartitionStore.class);
    }

    public <T extends AttributeStore<?>> T getStoreForAttributeOperation(IdentityContext context) {
        if (this.attributeManagementConfig != null) {
            Map<IdentityStoreConfiguration, IdentityStore<?>> configStores = this.stores.get(this.attributeManagementConfig);
            for (IdentityStoreConfiguration cfg : configStores.keySet()) {
                if (!cfg.supportsAttribute()) continue;
                AttributeStore store = null;
                try {
                    store = (AttributeStore)configStores.get(cfg);
                    cfg.initializeContext(context, (IdentityStore)store);
                    return (T)store;
                }
                catch (ClassCastException cce) {
                    throw IDMMessages.MESSAGES.storeUnexpectedType(store.getClass(), AttributeStore.class);
                }
            }
        }
        return null;
    }

    private String getDefaultConfigurationName() {
        for (IdentityConfiguration config : this.configurations) {
            if (!DEFAULT_CONFIGURATION_NAME.equals(config.getName())) continue;
            return DEFAULT_CONFIGURATION_NAME;
        }
        return this.configurations.iterator().next().getName();
    }

    private void checkPartitionManagementSupported() throws OperationNotSupportedException {
        if (this.partitionManagementConfig == null) {
            throw IDMMessages.MESSAGES.partitionManagementNoSupported(Partition.class, IdentityStoreConfiguration.IdentityOperation.create);
        }
    }

    private void checkSupportedTypes(Partition partition, Class<? extends AttributedType> type) {
        IdentityPartition identityPartition;
        if (partition != null && IdentityType.class.isAssignableFrom(type) && (identityPartition = partition.getClass().getAnnotation(IdentityPartition.class)) != null && IDMUtil.isTypeSupported(type, (Set)IDMUtil.toSet((Object[])identityPartition.supportedTypes()), (Set)IDMUtil.toSet((Object[])identityPartition.unsupportedTypes())) == -1) {
            throw new IdentityManagementException("Partition [" + partition + "] does not support type [" + type + "].");
        }
    }

    private void checkIfPartitionExists(Partition partition) {
        if (partition == null) {
            throw IDMMessages.MESSAGES.nullArgument("Partition");
        }
        if (this.lookupById(partition.getClass(), partition.getId()) == null) {
            throw IDMMessages.MESSAGES.partitionNotFoundWithName(partition.getClass(), partition.getName());
        }
    }

    private Partition createDefaultPartition() {
        Realm storedPartition = new Realm(DEFAULT_CONFIGURATION_NAME);
        storedPartition.setId(DEFAULT_CONFIGURATION_NAME);
        return storedPartition;
    }
}

